/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.services.pptx.tags;

import java.util.LinkedList;
import java.util.regex.Pattern;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.pptx.PPTXHelper;
import org.eclipse.gendoc.documents.IDocumentService;
import org.eclipse.gendoc.process.AbstractStepProcess;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.services.pptx.PPTXDocumentService;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SlideDropProcess
extends AbstractStepProcess {
    protected static final Pattern DROP_SLIDE_TAG_PATTERN = Pattern.compile("<\\s*dropSlide\\s*/\\s*>", 8);
    protected IDocumentService documentService = (IDocumentService)GendocServices.getDefault().getService(IDocumentService.class);
    protected LinkedList<Node> nodesToRemove;

    protected void doRun() throws GenDocException {
        if (!(this.documentService instanceof PPTXDocumentService)) {
            return;
        }
        this.nodesToRemove = new LinkedList();
        super.doRun();
        for (Node n : this.nodesToRemove) {
            Node parent = n.getParentNode();
            if (parent == null) continue;
            parent.removeChild(n);
        }
    }

    protected void step(Document document) throws GenDocException {
        String text;
        Node currentNode = document.getXMLParser().getCurrentNode();
        if (this.documentService.isPara(currentNode.getNodeName()) && (text = (String)document.get(Document.PROPERTY.text)) != null && DROP_SLIDE_TAG_PATTERN.matcher(text).find()) {
            Node start = this.findPrevStartSlideNode(currentNode);
            Node end = this.findNextEndSlideNode(currentNode);
            if (start == null || end == null) {
                return;
            }
            Node n = start;
            while (n != end) {
                this.nodesToRemove.add(n);
                n = n.getNextSibling();
            }
            this.nodesToRemove.add(end);
        }
    }

    private Node findPrevStartSlideNode(Node n) {
        return this.findSlideRefNode(n, true, PPTXHelper.GENDOC_REF_TYPE.startSlide);
    }

    private Node findNextEndSlideNode(Node n) {
        return this.findSlideRefNode(n, false, PPTXHelper.GENDOC_REF_TYPE.endSlide);
    }

    /*
     * Unable to fully structure code
     */
    private Node findSlideRefNode(Node n, boolean previous, PPTXHelper.GENDOC_REF_TYPE refType) {
        sibling = this.findFlattenStructureChildNode(n);
        if (sibling != null) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            if (sibling.getNodeName().equals("gendoc:ref") && (t = PPTXHelper.GENDOC_REF_TYPE.valueOf((String)(typeStr = ((Element)sibling).getAttribute("type")))) == refType) {
                return sibling;
            }
            v0 = sibling = previous != false ? sibling.getPreviousSibling() : sibling.getNextSibling();
lbl7:
            // 2 sources

            ** while (sibling != null)
        }
lbl8:
        // 1 sources

        return null;
    }

    private Node findFlattenStructureChildNode(Node n) {
        while (n != null) {
            if (n.getParentNode() != null && n.getParentNode().getNodeName().equals("gendoc:flatSlide")) {
                return n;
            }
            n = n.getParentNode();
        }
        return null;
    }
}

