/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.preferences.internal;

import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.gendoc.preferences.Activator;
import org.eclipse.gendoc.preferences.GendocNature;
import org.eclipse.gendoc.preferences.internal.GendocPreferenceUtils;
import org.eclipse.gendoc.wizard.IGendocRunner;
import org.eclipse.gendoc.wizard.IGendocRunnerProvider;

public class PreferenceGendocRunnerProvider
implements IGendocRunnerProvider {
    public IGendocRunner[] getGendocRunners() {
        ArrayList<IGendocRunner> runners = new ArrayList<IGendocRunner>();
        String templatesStr = Platform.getPreferencesService().getString("org.eclipse.gendoc.preferences", "genDocTemplates", "<templates/>", null);
        try {
            IGendocRunner[] templates = GendocPreferenceUtils.unmarshallTemplates(new ByteArrayInputStream(templatesStr.getBytes(Charset.forName("UTF-8"))));
            runners.addAll(Arrays.asList(templates));
        }
        catch (ParseException parseException) {}
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject proj = iProjectArray[n2];
            if (proj.isOpen()) {
                try {
                    GendocNature nature = (GendocNature)proj.getNature("org.eclipse.gendoc.preferences.GenDocNature");
                    if (nature != null) {
                        runners.addAll(nature.getGendocConfiguration().getGendocRunners());
                    }
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.gendoc.preferences", "Error retriving GenDocRunners from GendocRunnerProvider.", (Throwable)e));
                }
            }
            ++n2;
        }
        return runners.toArray(new IGendocRunner[runners.size()]);
    }
}

