/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.preferences.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IProject;
import org.eclipse.gendoc.preferences.IGendocConfiguration;
import org.eclipse.gendoc.preferences.internal.GendocConfiguration;
import org.eclipse.gendoc.preferences.internal.PreferenceGendocRunner;
import org.eclipse.gendoc.preferences.internal.PreferenceGendocTemplate;
import org.eclipse.gendoc.wizard.IGendocRunner;
import org.eclipse.gendoc.wizard.IGendocTemplate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class GendocPreferenceUtils {
    private static final DocumentBuilder DOC_BUILDER = GendocPreferenceUtils.initialize();
    private static final Transformer TRANSFORMER = GendocPreferenceUtils.initializeTr();
    private static final Transformer TRANSFORMER_NICE = GendocPreferenceUtils.initializeTrNice();

    private static DocumentBuilder initialize() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
    }

    private static Transformer initializeTr() {
        try {
            return TransformerFactory.newInstance().newTransformer();
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            return null;
        }
    }

    private static Transformer initializeTrNice() {
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("standalone", "yes");
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("encoding", "UTF-8");
            return tr;
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            return null;
        }
    }

    public static IGendocConfiguration unmarshall(IProject project, InputStream in) throws ParseException {
        try {
            Document doc = DOC_BUILDER.parse(in);
            Element root = doc.getDocumentElement();
            if (!root.getTagName().equals("gendoc")) {
                throw new ParseException(String.format("Invalid root element '%s'", root.getTagName()), 0);
            }
            GendocConfiguration configuration = new GendocConfiguration(project);
            NodeList templatesEls = root.getElementsByTagName("templates");
            if (templatesEls.getLength() == 1) {
                configuration.setGendocRunners(Arrays.asList(GendocPreferenceUtils.unmarshallTemplatesImpl(project, (Element)templatesEls.item(0))));
            }
            return configuration;
        }
        catch (SAXException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    public static IGendocRunner[] unmarshallTemplates(InputStream in) throws ParseException {
        try {
            Document doc = DOC_BUILDER.parse(in);
            Element root = doc.getDocumentElement();
            if (!root.getTagName().equals("templates")) {
                throw new ParseException(String.format("Invalid root element '%s'", root.getTagName()), 0);
            }
            return GendocPreferenceUtils.unmarshallTemplatesImpl(null, root);
        }
        catch (SAXException e) {
            throw new ParseException(e.getMessage(), 0);
        }
        catch (IOException e) {
            throw new ParseException(e.getMessage(), 0);
        }
    }

    private static IGendocRunner[] unmarshallTemplatesImpl(IProject project, Element templatesEl) throws ParseException {
        if (!templatesEl.getTagName().equals("templates")) {
            throw new ParseException(String.format("Invalid root element '%s'", templatesEl.getTagName()), 0);
        }
        ArrayList<PreferenceGendocRunner> runners = new ArrayList<PreferenceGendocRunner>();
        NodeList templateTypes = templatesEl.getElementsByTagName("templateType");
        int i = 0;
        while (i < templateTypes.getLength()) {
            Element templateTypeEl = (Element)templateTypes.item(i);
            PreferenceGendocRunner runner = new PreferenceGendocRunner(project, templateTypeEl.getAttribute("name"));
            runner.setDescription(templateTypeEl.getAttribute("description"));
            try {
                runner.setPattern(Pattern.compile(templateTypeEl.getAttribute("pattern")));
            }
            catch (Exception exception) {}
            NodeList parameters = templateTypeEl.getElementsByTagName("parameter");
            int j = 0;
            while (j < parameters.getLength()) {
                Element parameterEl = (Element)parameters.item(j);
                runner.addParameter(parameterEl.getAttribute("name"), parameterEl.getAttribute("description"));
                ++j;
            }
            NodeList templates = templateTypeEl.getElementsByTagName("template");
            int j2 = 0;
            while (j2 < templates.getLength()) {
                Element templateEl = (Element)templates.item(j2);
                try {
                    PreferenceGendocTemplate template = new PreferenceGendocTemplate(templateEl.getAttribute("extension"), new URL(templateEl.getAttribute("url")));
                    template.setDescription(templateEl.getAttribute("description"));
                    template.setModelKey(templateEl.getAttribute("modelKey"));
                    template.setOutputKey(templateEl.getAttribute("outputKey"));
                    if (templateEl.getAttribute("default").equals("true")) {
                        runner.addDefaultTemplate(template);
                    } else {
                        runner.addTemplate(template);
                    }
                }
                catch (Exception exception) {}
                ++j2;
            }
            runners.add(runner);
            ++i;
        }
        return runners.toArray(new IGendocRunner[0]);
    }

    public static void marshall(IGendocConfiguration config, OutputStream out) throws TransformerException {
        Document doc = DOC_BUILDER.newDocument();
        Element root = (Element)doc.appendChild(doc.createElement("gendoc"));
        GendocPreferenceUtils.marshallTemplatesImpl(config.getGendocRunners().toArray(new IGendocRunner[0]), root);
        TRANSFORMER_NICE.transform(new DOMSource(doc), new StreamResult(out));
    }

    public static void marshallTemplates(IGendocRunner[] runners, OutputStream out) throws TransformerException {
        Document doc = DOC_BUILDER.newDocument();
        GendocPreferenceUtils.marshallTemplatesImpl(runners, doc);
        TRANSFORMER.transform(new DOMSource(doc), new StreamResult(out));
    }

    public static void marshallTemplatesImpl(IGendocRunner[] runners, Node parent) {
        Document doc;
        Document document = doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        if (runners.length == 0) {
            return;
        }
        Element templatesEl = (Element)parent.appendChild(doc.createElement("templates"));
        IGendocRunner[] iGendocRunnerArray = runners;
        int n = runners.length;
        int n2 = 0;
        while (n2 < n) {
            PreferenceGendocRunner pr;
            IGendocRunner r = iGendocRunnerArray[n2];
            Element templateTypeEl = (Element)templatesEl.appendChild(doc.createElement("templateType"));
            templateTypeEl.setAttribute("name", r.getLabel());
            if (r.getPattern() != null) {
                templateTypeEl.setAttribute("pattern", r.getPattern().toString());
            }
            if (r instanceof PreferenceGendocRunner && (pr = (PreferenceGendocRunner)r).getDescription() != null) {
                templateTypeEl.setAttribute("description", pr.getDescription());
            }
            for (Map.Entry e : r.getAdditionnalParameters().entrySet()) {
                Element paramEl = (Element)templateTypeEl.appendChild(doc.createElement("parameter"));
                paramEl.setAttribute("name", (String)e.getKey());
                paramEl.setAttribute("description", (String)e.getValue());
            }
            for (IGendocTemplate template : r.getGendocTemplates()) {
                boolean isDef = false;
                if (r instanceof PreferenceGendocRunner) {
                    isDef = ((PreferenceGendocRunner)r).getDefaultTemplate() == template;
                }
                Element templateEl = (Element)templateTypeEl.appendChild(doc.createElement("template"));
                templateEl.setAttribute("extension", template.getOutPutExtension());
                templateEl.setAttribute("url", template.getTemplate().toExternalForm());
                templateEl.setAttribute("description", template.getDescription());
                templateEl.setAttribute("modelKey", template.getModelKey());
                templateEl.setAttribute("outputKey", template.getOutputKey());
                templateEl.setAttribute("default", isDef ? "true" : "false");
            }
            ++n2;
        }
    }
}

