/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.documents;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import org.eclipse.gendoc.document.parser.documents.AbstractDocument;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.Unzipper;
import org.eclipse.gendoc.document.parser.documents.XMLParser;
import org.eclipse.gendoc.document.parser.documents.XmlParsers;
import org.eclipse.gendoc.document.parser.documents.ZipDocument;
import org.eclipse.gendoc.document.parser.documents.Zipper;

public abstract class AbstractZipDocument
extends AbstractDocument
implements ZipDocument {
    private Unzipper unzipper = null;
    private Zipper zipper = null;
    private XmlParsers listOfXmlParsers;

    public AbstractZipDocument(File document) throws IOException {
        this(document, null);
    }

    public AbstractZipDocument(URL document) {
        this(document, null);
    }

    public AbstractZipDocument(File documentFile, Map<Document.CONFIGURATION, Boolean> configuration) throws IOException {
        this(documentFile.toURI().toURL(), configuration);
    }

    public AbstractZipDocument(URL documentFile, Map<Document.CONFIGURATION, Boolean> configuration) {
        super(documentFile, configuration);
        this.unzipper = new Unzipper(documentFile);
        this.getUnzipper().unzip();
        this.zipper = new Zipper(this.unzipper.getUnzipDocumentFile());
        this.listOfXmlParsers = new XmlParsers(this.getXmlParsers(Document.CONFIGURATION.content));
        if (configuration != null) {
            for (Document.CONFIGURATION c : configuration.keySet()) {
                if (c == Document.CONFIGURATION.content || !configuration.get((Object)c).booleanValue()) continue;
                this.listOfXmlParsers.addAll(this.getXmlParsers(c));
            }
        }
    }

    protected abstract Collection<XMLParser> getXmlParsers(Document.CONFIGURATION var1);

    @Override
    public XMLParser getXMLParser() {
        return this.listOfXmlParsers.getCurrent();
    }

    @Override
    public boolean next() {
        return this.listOfXmlParsers.next();
    }

    @Override
    public boolean jumpToNextFile() {
        return this.listOfXmlParsers.jumpToNextFile();
    }

    @Override
    public void zipToLocation(String locationToZip) {
        this.getZipper().zip(locationToZip);
    }

    @Override
    public File getUnzipLocationDocumentFile() {
        return this.getUnzipper().getUnzipDocumentFile();
    }

    protected Unzipper getUnzipper() {
        return this.unzipper;
    }

    protected Zipper getZipper() {
        return this.zipper;
    }

    public XmlParsers getListOfXmlParsers() {
        return this.listOfXmlParsers;
    }

    @Override
    public void jumpToStart() {
        this.listOfXmlParsers.jumpToStart();
    }
}

