/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.script.services.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gendoc.m2t.IFragmentService;
import org.eclipse.gendoc.m2t.IFragmentableM2TProcessor;
import org.eclipse.gendoc.m2t.IM2TProcessor;
import org.eclipse.gendoc.m2t.IScriptLanguageExtensionService;
import org.eclipse.gendoc.m2t.model.Fragment;
import org.eclipse.gendoc.script.acceleo.Generator;
import org.eclipse.gendoc.script.acceleo.IFileAndMMRegistry;
import org.eclipse.gendoc.script.acceleo.Messages;
import org.eclipse.gendoc.script.services.IModuleManagerService;
import org.eclipse.gendoc.script.services.impl.FragmentEdge;
import org.eclipse.gendoc.script.services.impl.TopologicalSort;
import org.eclipse.gendoc.services.AbstractService;
import org.eclipse.gendoc.services.GendocServices;
import org.eclipse.gendoc.services.exception.GenDocException;
import org.eclipse.gendoc.services.exception.GenerationException;
import org.eclipse.gendoc.services.exception.UnknownScriptLanguageException;
import org.eclipse.gendoc.tags.handlers.IConfigurationService;

public class ModuleManagerService
extends AbstractService
implements IModuleManagerService {
    Map<String, Set<Module>> mapMetamodels2CompiledBundlesIds = new HashMap<String, Set<Module>>();

    @Override
    public List<String> getImportedModules(EObject element) throws GenDocException {
        IConfigurationService config = (IConfigurationService)GendocServices.getDefault().getService(IConfigurationService.class);
        IScriptLanguageExtensionService scriptLanguageExtensionService = (IScriptLanguageExtensionService)GendocServices.getDefault().getService(IScriptLanguageExtensionService.class);
        try {
            IM2TProcessor processor = scriptLanguageExtensionService.getProcessor(config.getLanguage());
            if (processor instanceof IFragmentableM2TProcessor) {
                IFragmentableM2TProcessor fragmentable = (IFragmentableM2TProcessor)processor;
                IFragmentService fragmentService = (IFragmentService)GendocServices.getDefault().getService(IFragmentService.class);
                List fragments = fragmentService.getAllFragments();
                if (fragments != null) {
                    return this.manageFragments(element, fragments, fragmentable);
                }
            }
        }
        catch (UnknownScriptLanguageException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected List<String> manageFragments(EObject element, List<Fragment> fragments, IFragmentableM2TProcessor fragmentable) throws GenDocException {
        Collection<String> metamodels = this.getMetamodels(element);
        String id = this.getMMString(metamodels);
        Set<Module> result = this.mapMetamodels2CompiledBundlesIds.get(id);
        if (result == null) {
            result = new HashSet<Module>();
            this.mapMetamodels2CompiledBundlesIds.put(id, result);
            Map<String, Fragment> map = this.getFragmentsMap();
            try {
                fragments = this.topologicalSort(fragments);
            }
            catch (TopologicalSort.CycleException e) {
                throw new GenDocException("fragment dependency error from " + (e.getNode() != null ? e.getNode().toString() : "")){
                    private static final long serialVersionUID = 1L;
                };
            }
            String script = fragmentable.runFragmentsScript(element, fragments);
            try {
                ArrayList<URI> dependencies = new ArrayList<URI>();
                dependencies.add(this.getModuleURIForFragmentName(metamodels, "fragents"));
                Generator generator = new Generator(element, script, dependencies);
                Module m = generator.getModule();
                m.eResource().setURI(this.generateURI(id, m));
                if (m != null) {
                    result.add(m);
                }
            }
            catch (IOException e) {
                throw new GenerationException("Error during generation of the following script : \n" + script, (Throwable)e);
            }
        }
        LinkedList<String> toReturn = new LinkedList<String>();
        for (Module m : result) {
            toReturn.add(m.getName());
        }
        return toReturn;
    }

    private List<Fragment> topologicalSort(List<Fragment> fragments) throws TopologicalSort.CycleException {
        FragmentEdge edge = new FragmentEdge(this.getFragmentsMap());
        List<Fragment> result = TopologicalSort.sort(fragments, edge);
        Collections.reverse(result);
        return result;
    }

    Map<String, Fragment> getFragmentsMap() {
        IFragmentService service = (IFragmentService)GendocServices.getDefault().getService(IFragmentService.class);
        HashMap<String, Fragment> allFragments = new HashMap<String, Fragment>();
        for (Fragment f : service.getAllFragments()) {
            allFragments.put(f.getName(), f);
        }
        return allFragments;
    }

    private String getMMString(Collection<String> metamodels) {
        StringBuilder id = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>(metamodels);
        Collections.sort(list);
        for (String s : list) {
            id.append(s.replace(':', '_').replace('/', '_').replace('.', '_'));
        }
        return id.toString();
    }

    private URI getModuleURIForFragmentName(Collection<String> metamodels, String dep) {
        return this.generateURI(this.getMMString(metamodels), dep);
    }

    public void clear() {
        super.clear();
        for (Set<Module> list : this.mapMetamodels2CompiledBundlesIds.values()) {
            for (Module m : list) {
                if (m.eResource() == null) continue;
                m.eResource().unload();
            }
        }
        this.mapMetamodels2CompiledBundlesIds.clear();
    }

    protected URI generateURI(String generateUUID, Module m) {
        return this.generateURI(generateUUID, m.getName());
    }

    protected URI generateURI(String generateUUID, String moduleName) {
        return URI.createURI((String)(String.valueOf(Messages.GendocResourceFactory_BUNDLE_URI_SCHEME) + "://" + generateUUID + "/" + moduleName + ".emtl"));
    }

    protected Collection<String> getMetamodels(EObject element) {
        IFileAndMMRegistry registry = (IFileAndMMRegistry)GendocServices.getDefault().getService(IFileAndMMRegistry.class);
        Collection<String> metamodels = registry.getMetamodels(element);
        return metamodels;
    }

    @Override
    public List<URI> getModuleURIs(EObject element) {
        LinkedList<URI> result = new LinkedList<URI>();
        IFileAndMMRegistry registry = (IFileAndMMRegistry)GendocServices.getDefault().getService(IFileAndMMRegistry.class);
        Collection<String> metamodels = registry.getMetamodels(element);
        Set<Module> modules = this.mapMetamodels2CompiledBundlesIds.get(this.getMMString(metamodels));
        for (Module m : modules) {
            result.add(m.eResource().getURI());
        }
        return result;
    }

    @Override
    public Module getModule(URI uri) {
        String name;
        Set<Module> modules;
        if (uri == null) {
            return null;
        }
        if (uri.segmentCount() != 1) {
            return null;
        }
        String id = (uri = uri.trimFileExtension()).host();
        if (id != null && (modules = this.mapMetamodels2CompiledBundlesIds.get(id)) != null && (name = uri.segment(0)) != null) {
            for (Module m : modules) {
                if (!name.equals(m.getName())) continue;
                return m;
            }
        }
        return null;
    }

    class DependencyCycleRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public DependencyCycleRuntimeException(String message) {
            super(message);
        }
    }
}

