/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.preferences.internal;

import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gendoc.preferences.internal.GendocTemplateFileDialog;
import org.eclipse.gendoc.preferences.internal.GendocTemplateParameterDialog;
import org.eclipse.gendoc.preferences.internal.PreferenceGendocRunner;
import org.eclipse.gendoc.preferences.internal.PreferenceGendocTemplate;
import org.eclipse.gendoc.preferences.internal.TableFieldEditor;
import org.eclipse.gendoc.wizard.IGendocRunner;
import org.eclipse.gendoc.wizard.IGendocTemplate;
import org.eclipse.jface.databinding.dialog.TitleAreaDialogSupport;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GendocTemplateDialog
extends TitleAreaDialog {
    private IGendocRunner input;
    private DataBindingContext bindingCtx = new DataBindingContext();

    public GendocTemplateDialog(Shell parentShell) {
        super(parentShell);
    }

    protected IGendocRunner getInput() {
        return this.input;
    }

    protected void setInput(IGendocRunner input) {
        this.input = input;
        this.bindingCtx.updateTargets();
    }

    protected Control createDialogArea(Composite parent) {
        super.setTitle("Configure the GenDoc template sets.");
        Composite c = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(c, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        Label l = new Label(composite, 4);
        l.setText("&Name:");
        l.setLayoutData((Object)new GridData(4, 4, false, false));
        Text name = new Text(composite, 2048);
        name.setLayoutData((Object)new GridData(4, 4, true, false));
        l = new Label(composite, 4);
        l.setText("&Description:");
        l.setLayoutData((Object)new GridData(4, 4, false, false));
        Text description = new Text(composite, 2626);
        description.setLayoutData((Object)new GridData(4, 4, true, true));
        ((GridData)description.getLayoutData()).minimumHeight = 80;
        l = new Label(composite, 4);
        l.setText("&Model File regexp:");
        l.setLayoutData((Object)new GridData(4, 4, false, false));
        Text pattern = new Text(composite, 2048);
        pattern.setLayoutData((Object)new GridData(4, 4, true, false));
        l = new Label(composite, 0);
        l = new Label(composite, 68);
        l.setText("Note: This regular expression define for which model files, this GenDoc templates will be enable.\n    Example: .*\\.uml will enable this template to be used agains any file with extension 'uml'.\nThe regular expression is according to java regular expressions.");
        l.setLayoutData((Object)new GridData(4, 4, true, false));
        IValidator nameValidator = new IValidator(){

            public IStatus validate(Object value) {
                if (value == null || "".equals(value)) {
                    return ValidationStatus.error((String)"GenDoc Template Sets must have a name");
                }
                try {
                    Pattern.compile((String)value);
                }
                catch (Exception e) {
                    return ValidationStatus.error((String)("Model RegExp: " + e.getLocalizedMessage()), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        IValidator patternValidator = new IValidator(){

            public IStatus validate(Object value) {
                if (value == null || "".equals(value)) {
                    return ValidationStatus.error((String)"GenDoc Template Sets must specify a regular expresion used to match model files.");
                }
                return Status.OK_STATUS;
            }
        };
        this.bindingCtx.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)name), PojoProperties.value((String)"label").observe((Object)this.input), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setAfterConvertValidator(nameValidator), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        IValidator descriptionValidator = new IValidator(){

            public IStatus validate(Object value) {
                if (value == null || "".equals(value)) {
                    return ValidationStatus.warning((String)"GenDoc Template Parameters Set should have a description.");
                }
                return Status.OK_STATUS;
            }
        };
        this.bindingCtx.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)description), PojoProperties.value((String)"description").observe((Object)this.input), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setAfterConvertValidator(descriptionValidator), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        this.bindingCtx.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)pattern), PojoProperties.value((String)"pattern").observe((Object)this.input), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(String.class, Pattern.class){

            public Object convert(Object fromObject) {
                if (fromObject == null || "".equals(fromObject)) {
                    return null;
                }
                try {
                    return Pattern.compile((String)fromObject);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }).setAfterConvertValidator(patternValidator), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST).setConverter((IConverter)new Converter(Pattern.class, String.class){

            public Object convert(Object fromObject) {
                if (fromObject == null) {
                    return "";
                }
                return fromObject.toString();
            }
        }));
        Composite paramArea = this.createParameterArea(composite);
        paramArea.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Composite TemplateArea = this.createTemplateArea(composite);
        TemplateArea.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        TitleAreaDialogSupport.create((TitleAreaDialog)this, (DataBindingContext)this.bindingCtx);
        this.bindingCtx.updateTargets();
        this.bindingCtx.updateModels();
        return composite;
    }

    private Composite createTemplateArea(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        TableFieldEditor editor = new TableFieldEditor("templates", "Templates:", c){

            @Override
            protected Table createTableControl(Composite parent) {
                Table t = super.createTableControl(parent);
                t.setHeaderVisible(true);
                TableColumn col = new TableColumn(t, 16384);
                col.setText("Template File");
                col.setWidth(300);
                col = new TableColumn(t, 16384);
                col.setText("Output Type");
                col.setWidth(80);
                return t;
            }

            @Override
            protected Object getNewInputObject() {
                GendocTemplateFileDialog dlg = new GendocTemplateFileDialog(Display.getCurrent().getActiveShell());
                dlg.setInput(new PreferenceGendocTemplate("docx", null));
                int res = dlg.open();
                if (res == 0) {
                    return dlg.getInput();
                }
                return null;
            }

            @Override
            protected Object editInputObject(Object input) {
                PreferenceGendocTemplate cur = (PreferenceGendocTemplate)input;
                GendocTemplateFileDialog dlg = new GendocTemplateFileDialog(Display.getCurrent().getActiveShell());
                try {
                    dlg.setInput((PreferenceGendocTemplate)cur.clone());
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    return null;
                }
                int res = dlg.open();
                if (res == 0) {
                    return dlg.getInput();
                }
                return null;
            }

            @Override
            protected ITableLabelProvider createLabelProvider() {
                return new ITableLabelProvider(){

                    public void removeListener(ILabelProviderListener listener) {
                    }

                    public boolean isLabelProperty(Object element, String property) {
                        return true;
                    }

                    public void dispose() {
                    }

                    public void addListener(ILabelProviderListener listener) {
                    }

                    public String getColumnText(Object element, int columnIndex) {
                        IGendocTemplate template = (IGendocTemplate)element;
                        switch (columnIndex) {
                            case 0: {
                                return template.getTemplate() == null ? "" : template.getTemplate().toExternalForm();
                            }
                            case 1: {
                                return template.getOutPutExtension();
                            }
                        }
                        return "";
                    }

                    public Image getColumnImage(Object element, int columnIndex) {
                        return null;
                    }
                };
            }

            @Override
            protected void refreshViewer() {
                super.refreshViewer();
                GendocTemplateDialog.this.bindingCtx.updateModels();
            }
        };
        editor.adjustForNumColumns(2);
        IValidator templatesValidator = new IValidator(){

            public IStatus validate(Object value) {
                if (value == null || ((List)value).size() == 0) {
                    return ValidationStatus.error((String)"GenDoc Template Sets must have at least one GenDoc Template specified.");
                }
                List list = (List)value;
                HashSet outFormats = new HashSet();
                for (IGendocTemplate t : list) {
                    if (!outFormats.contains(t.getOutPutExtension())) continue;
                    return ValidationStatus.error((String)"Only one GenDoc Template associated with a output format can be specified.");
                }
                return Status.OK_STATUS;
            }
        };
        this.bindingCtx.bindValue(PojoProperties.value((String)"input").observe((Object)editor), PojoProperties.value((String)"gendocTemplates").observe((Object)this.input), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setAfterConvertValidator(templatesValidator), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        return c;
    }

    private Composite createParameterArea(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        TableFieldEditor editor = new TableFieldEditor("parameters", "Parameters:", c){

            @Override
            protected Table createTableControl(Composite parent) {
                Table t = super.createTableControl(parent);
                t.setHeaderVisible(true);
                TableColumn col = new TableColumn(t, 16384);
                col.setText("Parameter");
                col.setWidth(150);
                col = new TableColumn(t, 16384);
                col.setText("Description");
                col.setWidth(300);
                return t;
            }

            @Override
            protected Object getNewInputObject() {
                GendocTemplateParameterDialog dlg = new GendocTemplateParameterDialog(Display.getCurrent().getActiveShell());
                dlg.setInput(new PreferenceGendocRunner.Parameter("new_parameter", "New Parameter"));
                int res = dlg.open();
                if (res == 0) {
                    return dlg.getInput();
                }
                return null;
            }

            @Override
            protected Object editInputObject(Object input) {
                PreferenceGendocRunner.Parameter cur = (PreferenceGendocRunner.Parameter)input;
                GendocTemplateParameterDialog dlg = new GendocTemplateParameterDialog(Display.getCurrent().getActiveShell());
                dlg.setInput(new PreferenceGendocRunner.Parameter(cur.getName(), cur.getLabel()));
                int res = dlg.open();
                if (res == 0) {
                    return dlg.getInput();
                }
                return null;
            }

            @Override
            protected ITableLabelProvider createLabelProvider() {
                return new ITableLabelProvider(){

                    public void removeListener(ILabelProviderListener listener) {
                    }

                    public boolean isLabelProperty(Object element, String property) {
                        return true;
                    }

                    public void dispose() {
                    }

                    public void addListener(ILabelProviderListener listener) {
                    }

                    public String getColumnText(Object element, int columnIndex) {
                        switch (columnIndex) {
                            case 0: {
                                return ((PreferenceGendocRunner.Parameter)element).getName();
                            }
                            case 1: {
                                return ((PreferenceGendocRunner.Parameter)element).getLabel();
                            }
                        }
                        return "";
                    }

                    public Image getColumnImage(Object element, int columnIndex) {
                        return null;
                    }
                };
            }

            @Override
            protected void refreshViewer() {
                super.refreshViewer();
                GendocTemplateDialog.this.bindingCtx.updateModels();
            }
        };
        editor.adjustForNumColumns(2);
        this.bindingCtx.bindValue(PojoProperties.value((String)"input").observe((Object)editor), PojoProperties.value((String)"parameters").observe((Object)this.input), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_ON_REQUEST));
        return c;
    }
}

