/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.bundle.acceleo.html.files;

import java.io.BufferedReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.gendoc.bundle.acceleo.html.Activator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TextToHtmlBuilder {
    private static final Transformer TRANSFORMER = TextToHtmlBuilder.initTransformer();
    private static final DocumentBuilder DOC_BUILDER = TextToHtmlBuilder.initDocBuilder();
    private static final NumberFormat FLOAT_FORMAT = DecimalFormat.getNumberInstance(Locale.US);
    private static final Pattern PATTERN_ROMAN = Pattern.compile("(M|MM|MMM|m|mm|mmm)?(C|CC|CCC|CD|D|DC|DCC|DCCC|CM|c|cc|ccc|cd|d|dc|dcc|dccc|cm)?(X|XX|XXX|XL|L|LX|LXX|LXXX|XC|x|xx|xxx|xl|l|lx|lxx|lxxx|xc)?(I|II|III|IV|V|VI|VII|VIII|IX|i|ii|iii|iv|v|vi|vii|viii|ix)?(\\.|\\)|\\.-|\\-.)\\s+");
    private static final Pattern PATTERN_ORDER = Pattern.compile("([0-9]+|[a-zA-Z])(\\.([0-9]+|[a-zA-Z]))*(\\.|\\)|\\.-|\\-.|\\))\\s+");
    private static final Pattern PATTERN_SYM = Pattern.compile("[\\-\\+\\*\\\ufffd\ufffd\\>o]\\s+");
    private static final Pattern[] PATTERNS = new Pattern[]{PATTERN_SYM, PATTERN_ORDER, PATTERN_ROMAN};
    private static final Pattern[] PATTERNS_ORDER = new Pattern[]{PATTERN_ORDER, PATTERN_ROMAN};
    private Document document;
    private Element element;
    private int tabSpaces = 4;
    private float tabSize = 0.25f;
    private Stack<Integer> listTabs = new Stack();
    private int indentation = -1;

    private static Transformer initTransformer() {
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            tr.setOutputProperty("encoding", "UTF-8");
            tr.setOutputProperty("indent", "true");
            tr.setOutputProperty("method", "html");
            tr.setOutputProperty("omit-xml-declaration", "yes");
            tr.setOutputProperty("standalone", "no");
            return tr;
        }
        catch (TransformerConfigurationException e) {
            Activator.error(e.getMessage(), e);
            return null;
        }
    }

    private static DocumentBuilder initDocBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            Activator.error(e.getMessage(), e);
            return null;
        }
    }

    public TextToHtmlBuilder() {
        this.document = DOC_BUILDER.newDocument();
        this.element = (Element)this.document.appendChild(this.document.createElement("html"));
    }

    public void addText(String str) {
        try {
            BufferedReader r = new BufferedReader(new StringReader(str));
            String line = r.readLine();
            while (line != null) {
                int indent = this.getIndent(line, this.tabSpaces);
                int spaces = this.getWhitespaces(line);
                String listPrefix = this.getListPrefix(line = line.substring(spaces));
                if (listPrefix != null) {
                    line = line.substring(listPrefix.length());
                    this.listItem(indent, listPrefix, line);
                } else {
                    this.paragraph(indent, line);
                }
                line = r.readLine();
            }
        }
        catch (Exception e) {
            Activator.error(e.getMessage(), e);
        }
    }

    protected void listItem(int indent, String prefix, String line) {
        boolean isNumber = this.isNumber(prefix);
        int diff = indent - this.indentation;
        if (diff > 0) {
            this.indentation = indent;
            this.listTabs.push(this.indentation);
            this.element = (Element)this.element.appendChild(this.document.createElement(isNumber ? "ol" : "ul"));
        } else if (diff < 0) {
            this.popIndentation(indent);
        }
        if (this.element.getTagName().equals("li")) {
            this.element = (Element)this.element.getParentNode();
        }
        this.element = (Element)this.element.appendChild(this.document.createElement("li"));
        this.element.appendChild(this.document.createTextNode(line));
    }

    protected void paragraph(int indent, String line) {
        int diff = indent - this.indentation;
        if (this.indentation == -1) {
            Element pEl = (Element)this.element.appendChild(this.document.createElement("p"));
            pEl.appendChild(this.document.createTextNode(line));
            if (--diff > 0) {
                pEl.setAttribute("style", "margin-left:" + FLOAT_FORMAT.format(this.tabSize * (float)diff) + "cm;");
            }
            return;
        }
        if (diff > 0) {
            Element pEl = (Element)this.element.appendChild(this.document.createElement("p"));
            pEl.appendChild(this.document.createTextNode(line));
            if (diff > 0) {
                pEl.setAttribute("style", "margin-left:" + FLOAT_FORMAT.format(this.tabSize * (float)diff) + "cm;");
            }
            return;
        }
        if (diff < 0 || this.indentation == 0 && diff == 0) {
            this.popIndentation(indent);
        }
        if (this.element.getTagName().equals("li")) {
            this.element.appendChild(this.document.createElement("br"));
            this.element.appendChild(this.document.createTextNode(line));
        } else {
            this.element.appendChild(this.document.createElement("p")).appendChild(this.document.createTextNode(line));
        }
    }

    private void popIndentation(int indent) {
        while (this.indentation > indent) {
            if (this.element.getTagName().equals("li")) {
                this.element = (Element)this.element.getParentNode();
            }
            this.element = (Element)this.element.getParentNode();
            if (this.listTabs.size() <= 1) {
                this.indentation = -1;
                continue;
            }
            this.listTabs.pop();
            this.indentation = this.listTabs.peek();
        }
    }

    private int getIndent(String line, int tab) {
        int nInd = 0;
        int i = 0;
        while (i < line.length()) {
            char ch = line.charAt(i);
            if (ch == '\t') {
                nInd += tab;
            } else if (Character.isWhitespace(ch)) {
                ++nInd;
            } else {
                return nInd;
            }
            ++i;
        }
        return nInd;
    }

    private int getWhitespaces(String line) {
        int nInd = 0;
        int i = 0;
        while (i < line.length()) {
            char ch = line.charAt(i);
            if (Character.isWhitespace(ch)) {
                ++nInd;
            } else {
                return nInd;
            }
            ++i;
        }
        return nInd;
    }

    private String getListPrefix(String line) {
        Pattern[] patternArray = PATTERNS;
        int n = PATTERNS.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix;
            Pattern p = patternArray[n2];
            Matcher m = p.matcher(line);
            if (m.find() && m.start() == 0 && !(prefix = line.substring(0, m.end())).isEmpty()) {
                return prefix;
            }
            ++n2;
        }
        return null;
    }

    private boolean isNumber(String line) {
        Pattern[] patternArray = PATTERNS_ORDER;
        int n = PATTERNS_ORDER.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern p = patternArray[n2];
            Matcher m = p.matcher(line);
            if (m.matches()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String toString() {
        StringWriter w = new StringWriter();
        try {
            NodeList nl = this.document.getDocumentElement().getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                TRANSFORMER.transform(new DOMSource(nl.item(i)), new StreamResult(w));
                w.append("\n");
                ++i;
            }
        }
        catch (TransformerException e) {
            Activator.error(e.getMessage(), e);
        }
        return w.toString();
    }
}

