/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gendoc.document.parser.documents;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.gendoc.document.parser.documents.Document;
import org.eclipse.gendoc.document.parser.documents.helper.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLParser {
    private File xml;
    private Document document;
    private Node currentNode = null;
    private XPath xpath = null;
    private HashMap<String, XPathExpression> xpathes = new HashMap();
    private HashMap<String, NodeList> xpathesNodes = new HashMap();
    private Node nodeToEndParsing = null;
    private Document.CONFIGURATION myConfiguration = null;

    public XMLParser(File f) {
        this(f, Document.CONFIGURATION.undefined);
    }

    public XMLParser(File f, Document.CONFIGURATION idForDocument) {
        try {
            this.xml = f;
            if (f != null) {
                this.myConfiguration = idForDocument;
                DocumentBuilderFactory fabrique = DocumentBuilderFactory.newInstance();
                fabrique.setNamespaceAware(true);
                DocumentBuilder constructeur = fabrique.newDocumentBuilder();
                this.document = constructeur.parse(this.xml);
                this.currentNode = this.document.getFirstChild();
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalArgumentException(String.format("File %s can't be parsed", f.getName()));
        }
        catch (SAXException sAXException) {
            throw new IllegalArgumentException(String.format("File %s can't be parsed", f.getName()));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(String.format("File %s can't be parsed", f.getName()));
        }
    }

    public Document.CONFIGURATION getKind() {
        return this.myConfiguration;
    }

    public void setEndNode(Node endNode) {
        this.nodeToEndParsing = endNode;
    }

    public Node getCurrentNode() {
        return this.currentNode;
    }

    public void setCurrentNode(Node currentNode) {
        this.currentNode = currentNode;
    }

    public Document getDocument() {
        return this.document;
    }

    public boolean next() {
        this.currentNode = XMLHelper.next(this.currentNode);
        return this.currentNode != null && (this.nodeToEndParsing == null || this.currentNode != this.nodeToEndParsing);
    }

    public Node evaluateXPathExpression(String expression, NamespaceContext context) {
        Node resultat = null;
        try {
            if (this.xpath == null) {
                XPathFactory fabrique = XPathFactory.newInstance();
                this.xpath = fabrique.newXPath();
                this.xpath.setNamespaceContext(context);
            }
            XPathExpression exp = null;
            if (!this.xpathes.containsKey(expression)) {
                exp = this.xpath.compile(expression);
                this.xpathes.put(expression, exp);
            } else {
                exp = this.xpathes.get(expression);
            }
            resultat = (Node)exp.evaluate(this.document, XPathConstants.NODE);
        }
        catch (XPathExpressionException xpee) {
            xpee.printStackTrace();
        }
        return resultat;
    }

    public Node evaluateXPathExpression(String expression, String attributeName, String attributeValue, NamespaceContext context) {
        if (expression != null && attributeName != null && attributeValue != null) {
            NodeList resultats = null;
            try {
                if (this.xpath == null) {
                    XPathFactory fabrique = XPathFactory.newInstance();
                    this.xpath = fabrique.newXPath();
                    this.xpath.setNamespaceContext(context);
                }
                XPathExpression exp = null;
                if (!this.xpathesNodes.containsKey(expression)) {
                    exp = this.xpath.compile(expression);
                    resultats = (NodeList)exp.evaluate(this.document, XPathConstants.NODESET);
                    this.xpathesNodes.put(expression, resultats);
                } else {
                    resultats = this.xpathesNodes.get(expression);
                }
                return this.getResult(attributeName, attributeValue, resultats);
            }
            catch (XPathExpressionException xpee) {
                xpee.printStackTrace();
            }
        }
        return null;
    }

    public NodeList getNodesFromXPathExpression(String expression, NamespaceContext context) {
        if (expression != null) {
            NodeList results = null;
            try {
                if (this.xpath == null) {
                    XPathFactory factory = XPathFactory.newInstance();
                    this.xpath = factory.newXPath();
                    this.xpath.setNamespaceContext(context);
                }
                XPathExpression exp = null;
                if (!this.xpathesNodes.containsKey(expression)) {
                    exp = this.xpath.compile(expression);
                    results = (NodeList)exp.evaluate(this.document, XPathConstants.NODESET);
                    this.xpathesNodes.put(expression, results);
                } else {
                    results = this.xpathesNodes.get(expression);
                }
                return results;
            }
            catch (XPathExpressionException xpee) {
                xpee.printStackTrace();
            }
        }
        return null;
    }

    private Node getResult(String attributeName, String attributeValue, NodeList resultats) {
        int i = 0;
        while (i < resultats.getLength()) {
            Node n = resultats.item(i);
            int j = 0;
            while (j < n.getAttributes().getLength()) {
                Node nattribute = n.getAttributes().item(j);
                if (attributeName.equals(nattribute.getNodeName()) && attributeValue.equals(nattribute.getNodeValue())) {
                    return n;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public File getXmlFile() {
        return this.xml;
    }

    public void init() {
        this.xpathes.clear();
        this.xpathesNodes.clear();
    }

    public static class NullXMLParser
    extends XMLParser {
        public NullXMLParser(File f) {
            super(f);
        }

        @Override
        public Node evaluateXPathExpression(String expression, NamespaceContext context) {
            return null;
        }

        @Override
        public Node evaluateXPathExpression(String expression, String attributeName, String attributeValue, NamespaceContext context) {
            return null;
        }

        @Override
        public Node getCurrentNode() {
            return null;
        }

        @Override
        public Document getDocument() {
            return null;
        }

        @Override
        public Document.CONFIGURATION getKind() {
            return Document.CONFIGURATION.undefined;
        }

        @Override
        public NodeList getNodesFromXPathExpression(String expression, NamespaceContext context) {
            return null;
        }

        @Override
        public File getXmlFile() {
            return null;
        }

        public int hashCode() {
            return 0;
        }

        @Override
        public void init() {
        }

        @Override
        public boolean next() {
            return false;
        }

        @Override
        public void setCurrentNode(Node currentNode) {
        }

        @Override
        public void setEndNode(Node endNode) {
        }

        public String toString() {
            return "";
        }
    }
}

