/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.util;

import com.google.inject.Inject;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.XCasePart;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XSwitchExpression;
import org.eclipse.xtext.xbase.interpreter.ConstantExpressionEvaluationException;
import org.eclipse.xtext.xbase.interpreter.SwitchConstantExpressionsInterpreter;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;

public class XSwitchExpressions {
    @Inject
    @Extension
    private IBatchTypeResolver _iBatchTypeResolver;
    @Inject
    @Extension
    private SwitchConstantExpressionsInterpreter _switchConstantExpressionsInterpreter;

    public boolean isJavaSwitchExpression(XSwitchExpression it) {
        boolean _xblockexpression = false;
        LightweightTypeReference switchType = this.getSwitchVariableType(it);
        if (switchType == null) {
            return false;
        }
        boolean _isSubtypeOf = switchType.isSubtypeOf(Integer.TYPE);
        if (_isSubtypeOf) {
            return true;
        }
        boolean _isSubtypeOf_1 = switchType.isSubtypeOf(Enum.class);
        if (_isSubtypeOf_1) {
            return true;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    public boolean isJava7SwitchExpression(XSwitchExpression it) {
        boolean _xblockexpression = false;
        LightweightTypeReference switchType = this.getSwitchVariableType(it);
        if (switchType == null) {
            return false;
        }
        boolean _isSubtypeOf = switchType.isSubtypeOf(Integer.TYPE);
        if (_isSubtypeOf) {
            return true;
        }
        boolean _isSubtypeOf_1 = switchType.isSubtypeOf(Enum.class);
        if (_isSubtypeOf_1) {
            return true;
        }
        boolean _isSubtypeOf_2 = switchType.isSubtypeOf(String.class);
        if (_isSubtypeOf_2) {
            return true;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    public boolean isJavaCaseExpression(XSwitchExpression it, XCasePart casePart) {
        boolean _not;
        boolean _tripleNotEquals;
        boolean _xblockexpression = false;
        JvmTypeReference _typeGuard = casePart.getTypeGuard();
        boolean bl = _tripleNotEquals = _typeGuard != null;
        if (_tripleNotEquals) {
            return false;
        }
        XExpression case_ = casePart.getCase();
        if (case_ == null) {
            return false;
        }
        IResolvedTypes resolvedTypes = this._iBatchTypeResolver.resolveTypes(it);
        LightweightTypeReference caseType = resolvedTypes.getActualType(case_);
        if (caseType == null) {
            return false;
        }
        LightweightTypeReference switchType = this.getSwitchVariableType(it);
        boolean _isAssignableFrom = switchType.isAssignableFrom(caseType);
        boolean bl2 = _not = !_isAssignableFrom;
        if (_not) {
            return false;
        }
        _xblockexpression = true;
        return _xblockexpression;
    }

    public LightweightTypeReference getSwitchVariableType(XSwitchExpression it) {
        LightweightTypeReference _actualType;
        IResolvedTypes resolvedTypes = this._iBatchTypeResolver.resolveTypes(it);
        JvmFormalParameter declaredParam = it.getDeclaredParam();
        if (declaredParam == null) {
            return resolvedTypes.getActualType(it.getSwitch());
        }
        LightweightTypeReference paramType = resolvedTypes.getActualType((JvmIdentifiableElement)declaredParam);
        LightweightTypeReference _elvis = null;
        _elvis = paramType != null ? paramType : (_actualType = resolvedTypes.getActualType(it.getSwitch()));
        return _elvis;
    }

    public boolean isConstant(XCasePart casePart) {
        XExpression case_ = casePart.getCase();
        if (case_ == null) {
            return false;
        }
        try {
            this._switchConstantExpressionsInterpreter.evaluate(case_);
            return true;
        }
        catch (Throwable _t) {
            if (_t instanceof ConstantExpressionEvaluationException) {
                return false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public XExpression getThen(XCasePart casePart, XSwitchExpression switchExpression) {
        XExpression then = casePart.getThen();
        if (then != null) {
            return then;
        }
        int casePartIndex = switchExpression.getCases().indexOf((Object)casePart);
        if (casePartIndex == -1) {
            return null;
        }
        int count = switchExpression.getCases().size();
        if (casePartIndex == count - 1) {
            return switchExpression.getDefault();
        }
        if (casePartIndex + 1 < count) {
            return this.getThen((XCasePart)switchExpression.getCases().get(casePartIndex + 1), switchExpression);
        }
        return null;
    }
}

