/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.internal.core.natures.PDE;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.plugin.NewLibraryPluginProjectWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;

public class ConvertJarsAction
implements IObjectActionDelegate {
    private IStructuredSelection selection;
    private IWorkbench workbench;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.workbench = targetPart.getSite().getWorkbenchWindow().getWorkbench();
    }

    public void run(IAction action) {
        HashMap<Manifest, Object> filesMap = new HashMap<Manifest, Object>();
        HashSet<IProject> projectSelection = new HashSet<IProject>();
        Iterator i = this.selection.toList().iterator();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        while (i.hasNext()) {
            IPackageFragmentRoot pfr = (IPackageFragmentRoot)i.next();
            ZipFile file = null;
            try {
                try {
                    projectSelection.add(pfr.getJavaProject().getProject());
                    IClasspathEntry rawClasspathEntry = pfr.getRawClasspathEntry();
                    IPath path = rawClasspathEntry.getPath();
                    IFile iFile = root.getFile(path);
                    if (iFile.exists()) {
                        file = new JarFile(iFile.getLocation().toString());
                        if (!filesMap.containsKey(((JarFile)file).getManifest())) {
                            filesMap.put(((JarFile)file).getManifest(), iFile);
                        }
                    } else {
                        String pathStr = path.toString();
                        file = new JarFile(pathStr);
                        if (!filesMap.containsKey(((JarFile)file).getManifest())) {
                            filesMap.put(((JarFile)file).getManifest(), new File(file.getName()));
                        }
                    }
                }
                catch (Exception e) {
                    PDEPlugin.logException(e);
                    if (file == null) continue;
                    try {
                        file.close();
                    }
                    catch (IOException e2) {
                        PDEPlugin.logException(e2);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException e) {
                        PDEPlugin.logException(e);
                    }
                }
                throw throwable;
            }
            if (file == null) continue;
            try {
                file.close();
            }
            catch (IOException e) {
                PDEPlugin.logException(e);
            }
        }
        NewLibraryPluginProjectWizard wizard = new NewLibraryPluginProjectWizard(filesMap.values(), projectSelection);
        wizard.init(this.workbench, this.selection);
        WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        dialog.open();
    }

    public void selectionChanged(IAction action, ISelection s) {
        boolean enabled = true;
        if (s instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)s;
            if (this.selection.isEmpty()) {
                return;
            }
            for (Object obj : this.selection) {
                if (obj instanceof IPackageFragmentRoot) {
                    try {
                        IPackageFragmentRoot packageFragment = (IPackageFragmentRoot)obj;
                        if (packageFragment.getKind() == 2 && PDE.hasPluginNature((IProject)packageFragment.getJavaProject().getProject()) && packageFragment.getRawClasspathEntry().getEntryKind() == 1) {
                            continue;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
                enabled = false;
                break;
            }
        } else {
            enabled = false;
            this.selection = null;
        }
        action.setEnabled(enabled);
    }
}

