/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.feature.InfoSection;
import org.eclipse.pde.internal.ui.editor.text.ColorManager;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class InfoFormPage
extends PDEFormPage {
    public static final String PAGE_ID = "info";
    private IColorManager colorManager = ColorManager.getDefault();
    private InfoSection infoSection;

    public InfoFormPage(PDEFormEditor editor, String title) {
        super(editor, PAGE_ID, title);
    }

    @Override
    protected String getHelpResource() {
        return "org.eclipse.pde.doc.user.manifest_feature_info";
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        form.getBody().setLayout((Layout)FormLayoutFactory.createFormGridLayout(false, 1));
        form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_DOC_SECTION_OBJ));
        this.infoSection = new InfoSection((PDEFormPage)this, form.getBody(), this.colorManager);
        managedForm.addPart((IFormPart)this.infoSection);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.manifest_feature_info");
        this.initialize();
    }

    @Override
    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    public void initialize() {
        this.getManagedForm().getForm().setText(PDEUIMessages.FeatureEditor_InfoPage_heading);
    }
}

