/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.pde.internal.ui.PDEPluginImages;

public class CollapseAction
extends Action {
    private AbstractTreeViewer fTreeViewer;
    private Object fTreeObject;
    private int fExpandToLevel;

    public CollapseAction(AbstractTreeViewer viewer, String tooltipText, int expandToLevel, Object treeObject) {
        super(tooltipText, 1);
        this.fExpandToLevel = expandToLevel;
        this.fTreeObject = treeObject;
        this.initialize(viewer, tooltipText);
    }

    public CollapseAction(AbstractTreeViewer viewer, String tooltipText) {
        super(tooltipText, 1);
        this.fExpandToLevel = 0;
        this.fTreeObject = null;
        this.initialize(viewer, tooltipText);
    }

    private void initialize(AbstractTreeViewer viewer, String tooltipText) {
        this.setToolTipText(tooltipText);
        this.setImageDescriptor(PDEPluginImages.DESC_COLLAPSE_ALL);
        this.fTreeViewer = viewer;
    }

    public void run() {
        if (this.fTreeViewer == null) {
            return;
        }
        if (this.fTreeObject != null && this.fExpandToLevel > 0) {
            this.fTreeViewer.getControl().setRedraw(false);
            this.fTreeViewer.collapseAll();
            this.fTreeViewer.expandToLevel(this.fTreeObject, 1);
            this.fTreeViewer.getControl().setRedraw(true);
        } else {
            this.fTreeViewer.collapseAll();
        }
    }
}

