/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.macbundler;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jdt.internal.ui.macbundler.BundleAttributes;
import org.eclipse.jdt.internal.ui.macbundler.BundleBuilder;
import org.eclipse.jdt.internal.ui.macbundler.BundleDescription;
import org.eclipse.jdt.internal.ui.macbundler.BundleWizardPage1;
import org.eclipse.jdt.internal.ui.macbundler.BundleWizardPage2;
import org.eclipse.jdt.internal.ui.macbundler.BundleWizardPage3;
import org.eclipse.jdt.internal.ui.macbundler.MacOSXUILaunchingPlugin;
import org.eclipse.jdt.internal.ui.macbundler.Util;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;

public class MacBundleWizard
extends Wizard
implements IExportWizard,
BundleAttributes {
    IWorkbench fWorkbench;
    IStructuredSelection fSelection;
    BundleDescription fBundleDescription = new BundleDescription();

    public MacBundleWizard() {
        this.setDefaultPageImageDescriptor(MacBundleWizard.createWizardImageDescriptor("exportapp_wiz.png"));
        this.setWindowTitle(Util.getString("MacBundleWizard.title"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWorkbench = workbench;
        this.fSelection = selection;
    }

    IStructuredSelection getSelection() {
        return this.fSelection;
    }

    public void addPages() {
        super.addPages();
        this.addPage(new BundleWizardPage1(this.fBundleDescription));
        this.addPage(new BundleWizardPage2(this.fBundleDescription));
        this.addPage(new BundleWizardPage3(this.fBundleDescription));
    }

    public boolean performFinish() {
        try {
            BundleBuilder bb = new BundleBuilder();
            bb.createBundle(this.fBundleDescription, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static ImageDescriptor createWizardImageDescriptor(String name) {
        try {
            URL baseUrl = MacOSXUILaunchingPlugin.getDefault().getBundle().getEntry("/icons/full/wizban/");
            if (baseUrl != null) {
                return ImageDescriptor.createFromURL((URL)new URL(baseUrl, name));
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return ImageDescriptor.getMissingImageDescriptor();
    }
}

