/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.eobject;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.match.eobject.EUriFragmentFunction;
import org.eclipse.emf.compare.match.eobject.internal.AccessBasedLRUCache;
import org.eclipse.emf.ecore.EObject;

public class URIDistance
implements Function<EObject, Iterable<String>> {
    private static final int MAX_DISTANCE = 10;
    private Map<EObject, Iterable<String>> locationCache;
    private Map<EObject, String> fragmentsCache;
    private Function<EObject, String> fragmentComputation;
    private Optional<Comparison> underMatch = Optional.absent();

    public URIDistance() {
        this.locationCache = new AccessBasedLRUCache<EObject, Iterable<String>>(1000, 1000, 0.75f);
        this.fragmentsCache = new AccessBasedLRUCache<EObject, String>(1000, 1000, 0.75f);
        this.fragmentComputation = new EUriFragmentFunction();
    }

    public void setComparison(Comparison comparison) {
        this.underMatch = Optional.fromNullable((Object)comparison);
    }

    public int proximity(EObject a, EObject b) {
        Iterable<String> aPath = this.getOrComputeLocation(a);
        Iterable<String> bPath = this.getOrComputeLocation(b);
        return this.proximity(aPath, bPath);
    }

    public int proximity(Iterable<String> aPath, Iterable<String> bPath) {
        int aSize = 0;
        int bSize = 0;
        Iterator<String> itA = aPath.iterator();
        Iterator<String> itB = bPath.iterator();
        boolean areSame = true;
        int commonSegments = 0;
        int remainingASegments = 0;
        int remainingBSegments = 0;
        while (itA.hasNext() && itB.hasNext() && areSame) {
            String b;
            String a = itA.next();
            if (a.equals(b = itB.next())) {
                ++commonSegments;
            } else {
                areSame = false;
            }
            ++aSize;
            ++bSize;
        }
        if (commonSegments == 0) {
            return 10;
        }
        remainingASegments = aSize + Iterators.size(itA) - commonSegments;
        remainingBSegments = bSize + Iterators.size(itB) - commonSegments;
        int nbSegmentsToGoFromAToB = remainingASegments + remainingBSegments;
        return nbSegmentsToGoFromAToB * 10 / (commonSegments * 2 + nbSegmentsToGoFromAToB);
    }

    public Iterable<String> apply(EObject input) {
        String result = "";
        EObject container = input.eContainer();
        if (container != null) {
            if (this.underMatch.isPresent()) {
                Match m = ((Comparison)this.underMatch.get()).getMatch(container);
                if (m == null) {
                    result = this.retrieveFragment(input);
                }
            } else {
                result = this.retrieveFragment(input);
            }
        } else {
            result = "0";
        }
        ArrayList resultList = Lists.newArrayList((Object[])new String[]{result});
        if (container != null) {
            Iterables.addAll((Collection)resultList, this.getOrComputeLocation(container));
        }
        return resultList;
    }

    private Iterable<String> getOrComputeLocation(EObject container) {
        Iterable<String> result = this.locationCache.get(container);
        if (result == null) {
            result = this.apply(container);
            this.locationCache.put(container, result);
        }
        return result;
    }

    public String retrieveFragment(EObject input) {
        String result = this.fragmentsCache.get(input);
        if (result == null) {
            result = (String)this.fragmentComputation.apply((Object)input);
            this.fragmentsCache.put(input, result);
        }
        return result;
    }

    public int getUpperBoundDistance() {
        return 10;
    }
}

