/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.compare.ICompareContainer;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.ide.EMFCompareIDEPlugin;
import org.eclipse.emf.compare.ide.internal.hook.ResourceSetHookRegistry;
import org.eclipse.emf.compare.ide.internal.utils.NotLoadingResourceSet;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIMessages;
import org.eclipse.emf.compare.ide.ui.internal.EMFCompareIDEUIPlugin;
import org.eclipse.emf.compare.ide.ui.internal.logical.EmptyComparisonScope;
import org.eclipse.emf.compare.ide.ui.internal.logical.StreamAccessorStorage;
import org.eclipse.emf.compare.ide.ui.internal.logical.SubscriberStorageAccessor;
import org.eclipse.emf.compare.ide.ui.internal.util.PlatformElementUtil;
import org.eclipse.emf.compare.ide.ui.logical.IModelMinimizer;
import org.eclipse.emf.compare.ide.ui.logical.IModelResolver;
import org.eclipse.emf.compare.ide.ui.logical.IStorageProviderAccessor;
import org.eclipse.emf.compare.ide.ui.logical.SynchronizationModel;
import org.eclipse.emf.compare.ide.utils.ResourceUtil;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.subscribers.SubscriberMergeContext;
import org.eclipse.team.internal.ui.mapping.ModelCompareEditorInput;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ModelSynchronizeParticipant;

public final class ComparisonScopeBuilder {
    private final IModelResolver resolver;
    private final IModelMinimizer minimizer;
    private final IStorageProviderAccessor storageAccessor;
    private static final Logger LOGGER = Logger.getLogger(ComparisonScopeBuilder.class);
    private static final Function<IResource, URI> TO_FILE_URIS = new Function<IResource, URI>(){

        public URI apply(IResource input) {
            URI uri = input instanceof IStorage ? (URI)ResourceUtil.asURI().apply((Object)((IStorage)input)) : URI.createPlatformResourceURI((String)input.getFullPath().toString(), (boolean)true);
            return uri;
        }
    };

    public ComparisonScopeBuilder(IModelResolver resolver, IModelMinimizer minimizer) {
        this(resolver, minimizer, null);
    }

    public ComparisonScopeBuilder(IModelResolver resolver, IModelMinimizer minimizer, IStorageProviderAccessor storageAccessor) {
        this.resolver = (IModelResolver)Preconditions.checkNotNull((Object)resolver);
        this.minimizer = (IModelMinimizer)Preconditions.checkNotNull((Object)minimizer);
        this.storageAccessor = storageAccessor;
    }

    public IComparisonScope build(ITypedElement left, ITypedElement right, IProgressMonitor monitor) {
        return this.build(left, right, null, monitor);
    }

    public IComparisonScope build(ITypedElement left, ITypedElement right, ITypedElement origin, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        subMonitor.subTask(EMFCompareIDEUIMessages.getString("EMFSynchronizationModel.resolving"));
        try {
            SynchronizationModel syncModel = this.storageAccessor != null ? this.createSynchronizationModel(this.storageAccessor, left, right, origin, (IProgressMonitor)subMonitor.newChild(60)) : this.createSynchronizationModel(left, right, origin, (IProgressMonitor)subMonitor.newChild(60));
            return this.createMinimizedScope(left, syncModel, (IProgressMonitor)subMonitor.newChild(40));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            EmptyComparisonScope scope = new EmptyComparisonScope();
            scope.setDiagnostic(BasicDiagnostic.toDiagnostic((Throwable)e));
            return scope;
        }
    }

    SynchronizationModel buildSynchronizationModel(ITypedElement left, ITypedElement right, ITypedElement origin, IProgressMonitor monitor) throws InterruptedException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"buildSynchronizationModel - START");
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        subMonitor.subTask(EMFCompareIDEUIMessages.getString("EMFSynchronizationModel.resolving"));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"buildSynchronizationModel - Creating sync model");
        }
        SynchronizationModel syncModel = this.storageAccessor != null ? this.createSynchronizationModel(this.storageAccessor, left, right, origin, (IProgressMonitor)subMonitor.newChild(90)) : this.createSynchronizationModel(left, right, origin, (IProgressMonitor)subMonitor.newChild(90));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"buildSynchronizationModel - Minimizing model");
        }
        this.minimizer.minimize(PlatformElementUtil.findFile(left), syncModel, (IProgressMonitor)subMonitor.newChild(10));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"buildSynchronizationModel - FINISH NORMALLY");
        }
        return syncModel;
    }

    public static IComparisonScope create(ICompareContainer container, ITypedElement left, ITypedElement right, ITypedElement origin, IProgressMonitor monitor) {
        Object leftStorage;
        SubscriberStorageAccessor storageAccessor = null;
        Subscriber subscriber = ComparisonScopeBuilder.getSubscriber(container);
        if (subscriber != null) {
            storageAccessor = new SubscriberStorageAccessor(subscriber);
        }
        if ((leftStorage = PlatformElementUtil.findFile(left)) == null) {
            leftStorage = StreamAccessorStorage.fromTypedElement(left);
        }
        IModelResolver resolver = EMFCompareIDEUIPlugin.getDefault().getModelResolverRegistry().getBestResolverFor((IStorage)leftStorage);
        ComparisonScopeBuilder scopeBuilder = new ComparisonScopeBuilder(resolver, EMFCompareIDEUIPlugin.getDefault().getModelMinimizerRegistry().getCompoundMinimizer(), storageAccessor);
        return scopeBuilder.build(left, right, origin, monitor);
    }

    public static IComparisonScope create(SynchronizationModel synchronizationModel, IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return ComparisonScopeBuilder.createScope(synchronizationModel, monitor);
    }

    private static Subscriber getSubscriber(ICompareContainer container) {
        if (container instanceof ModelCompareEditorInput) {
            ModelCompareEditorInput modelInput = (ModelCompareEditorInput)container;
            ISynchronizeParticipant participant = null;
            try {
                final Field field = ModelCompareEditorInput.class.getDeclaredField("participant");
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        field.setAccessible(true);
                        return null;
                    }
                });
                participant = (ISynchronizeParticipant)field.get(modelInput);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {
                // empty catch block
            }
            if (participant instanceof ModelSynchronizeParticipant && ((ModelSynchronizeParticipant)participant).getContext() instanceof SubscriberMergeContext) {
                return ((SubscriberMergeContext)((ModelSynchronizeParticipant)participant).getContext()).getSubscriber();
            }
        }
        return null;
    }

    private SynchronizationModel createSynchronizationModel(IStorageProviderAccessor accessor, ITypedElement left, ITypedElement right, ITypedElement origin, IProgressMonitor monitor) throws InterruptedException {
        IFile localFile = PlatformElementUtil.findFile(left);
        String path = null;
        if (localFile != null) {
            path = localFile.getFullPath().toString();
        }
        StreamAccessorStorage leftStorage = StreamAccessorStorage.fromTypedElement(path, left);
        StreamAccessorStorage rightStorage = right instanceof IStreamContentAccessor ? StreamAccessorStorage.fromTypedElement(path, right) : null;
        StreamAccessorStorage originStorage = origin instanceof IStreamContentAccessor ? StreamAccessorStorage.fromTypedElement(path, origin) : null;
        return this.resolver.resolveModels(accessor, leftStorage, rightStorage, originStorage, monitor);
    }

    private SynchronizationModel createSynchronizationModel(ITypedElement left, ITypedElement right, ITypedElement origin, IProgressMonitor monitor) throws InterruptedException {
        IFile leftFile = PlatformElementUtil.findFile(left);
        IFile rightFile = PlatformElementUtil.findFile(right);
        if (leftFile != null && rightFile != null) {
            return this.resolver.resolveLocalModels((IResource)leftFile, (IResource)rightFile, (IResource)PlatformElementUtil.findFile(origin), monitor);
        }
        StreamAccessorStorage leftStorage = StreamAccessorStorage.fromTypedElement(left);
        Assert.isNotNull((Object)leftStorage);
        StreamAccessorStorage rightStorage = right instanceof IStreamContentAccessor ? StreamAccessorStorage.fromTypedElement(right) : null;
        StreamAccessorStorage originStorage = origin instanceof IStreamContentAccessor ? StreamAccessorStorage.fromTypedElement(origin) : null;
        return this.loadSingleResource(leftStorage, rightStorage, originStorage);
    }

    private SynchronizationModel loadSingleResource(IStorage left, IStorage right, IStorage origin) {
        StorageTraversal leftTraversal = new StorageTraversal(new LinkedHashSet<IStorage>(Arrays.asList(left)));
        StorageTraversal rightTraversal = right != null ? new StorageTraversal(new LinkedHashSet<IStorage>(Arrays.asList(right))) : new StorageTraversal((Set)Sets.newLinkedHashSet());
        StorageTraversal originTraversal = origin != null ? new StorageTraversal(new LinkedHashSet<IStorage>(Arrays.asList(origin))) : new StorageTraversal((Set)Sets.newLinkedHashSet());
        return new SynchronizationModel(leftTraversal, rightTraversal, originTraversal);
    }

    private IComparisonScope createMinimizedScope(ITypedElement left, SynchronizationModel syncModel, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        this.minimizer.minimize(PlatformElementUtil.findFile(left), syncModel, (IProgressMonitor)subMonitor.newChild(10));
        return ComparisonScopeBuilder.createScope(syncModel, (IProgressMonitor)subMonitor.newChild(90));
    }

    private static IComparisonScope createScope(SynchronizationModel syncModel, IProgressMonitor monitor) {
        NotLoadingResourceSet originResourceSet;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
        progress.subTask(EMFCompareIDEUIMessages.getString("EMFSynchronizationModel.creatingScope"));
        StorageTraversal leftTraversal = syncModel.getLeftTraversal();
        StorageTraversal rightTraversal = syncModel.getRightTraversal();
        StorageTraversal originTraversal = syncModel.getOriginTraversal();
        ResourceSetHookRegistry resourceSetHookRegistry = EMFCompareIDEPlugin.getDefault().getResourceSetHookRegistry();
        if (originTraversal == null || originTraversal.getStorages().isEmpty()) {
            originResourceSet = null;
            progress.setWorkRemaining(2);
        } else {
            originResourceSet = NotLoadingResourceSet.create((StorageTraversal)originTraversal, (IProgressMonitor)progress.newChild(1), (ResourceSetHookRegistry)resourceSetHookRegistry);
        }
        NotLoadingResourceSet leftResourceSet = NotLoadingResourceSet.create((StorageTraversal)leftTraversal, (IProgressMonitor)progress.newChild(1), (ResourceSetHookRegistry)resourceSetHookRegistry);
        NotLoadingResourceSet rightResourceSet = NotLoadingResourceSet.create((StorageTraversal)rightTraversal, (IProgressMonitor)progress.newChild(1), (ResourceSetHookRegistry)resourceSetHookRegistry);
        ExtensibleURIConverterImpl converter = new ExtensibleURIConverterImpl();
        LinkedHashSet urisInScope = Sets.newLinkedHashSet();
        for (IStorage left : leftTraversal.getStorages()) {
            urisInScope.add(converter.normalize(ResourceUtil.createURIFor((IStorage)left)));
        }
        for (IStorage right : rightTraversal.getStorages()) {
            urisInScope.add(converter.normalize(ResourceUtil.createURIFor((IStorage)right)));
        }
        if (originTraversal != null) {
            for (IStorage origin : originTraversal.getStorages()) {
                urisInScope.add(converter.normalize(ResourceUtil.createURIFor((IStorage)origin)));
            }
        }
        DefaultComparisonScope scope = new DefaultComparisonScope((Notifier)leftResourceSet, (Notifier)rightResourceSet, (Notifier)originResourceSet);
        scope.setResourceSetContentFilter(ComparisonScopeBuilder.isInScope(urisInScope));
        Set<IResource> involvedResources = syncModel.getAllInvolvedResources();
        Collection involvedResourceURIs = Collections2.transform(involvedResources, TO_FILE_URIS);
        scope.getAllInvolvedResourceURIs().addAll(involvedResourceURIs);
        Diagnostic syncModelDiagnostic = syncModel.getDiagnostic();
        Diagnostic scopeDiagnostic = ComparisonScopeBuilder.computeDiagnostics((ResourceSet)originResourceSet, (ResourceSet)leftResourceSet, (ResourceSet)rightResourceSet);
        BasicDiagnostic basicDiagnostic = new BasicDiagnostic(0, "org.eclipse.emf.compare.ide.ui", 0, null, new Object[0]);
        basicDiagnostic.add(syncModelDiagnostic);
        basicDiagnostic.add(scopeDiagnostic);
        scope.setDiagnostic((Diagnostic)basicDiagnostic);
        return scope;
    }

    private static Diagnostic computeDiagnostics(ResourceSet originResourceSet, ResourceSet leftResourceSet, ResourceSet rightResourceSet) {
        BasicDiagnostic originDiagnostic = originResourceSet != null ? ComparisonScopeBuilder.getResourceSetDiagnostic(originResourceSet, null, true) : null;
        BasicDiagnostic leftDiagnostic = ComparisonScopeBuilder.getResourceSetDiagnostic(leftResourceSet, DifferenceSource.LEFT, true);
        BasicDiagnostic rightDiagnostic = ComparisonScopeBuilder.getResourceSetDiagnostic(rightResourceSet, DifferenceSource.RIGHT, true);
        BasicDiagnostic diagnostic = new BasicDiagnostic(0, "org.eclipse.emf.compare.ide.ui", 0, EMFCompareIDEUIMessages.getString("ComparisonScopeBuilder.comparisonScopeDiagnostic"), new Object[0]);
        if (originDiagnostic != null) {
            diagnostic.add((Diagnostic)originDiagnostic);
        }
        diagnostic.add((Diagnostic)leftDiagnostic);
        diagnostic.add((Diagnostic)rightDiagnostic);
        return diagnostic;
    }

    private static BasicDiagnostic getResourceSetDiagnostic(ResourceSet resourceSet, DifferenceSource side, boolean includeWarning) {
        String sideStr = side == DifferenceSource.LEFT ? EMFCompareIDEUIMessages.getString("ComparisonScopeBuilder.left") : (side == DifferenceSource.RIGHT ? EMFCompareIDEUIMessages.getString("ComparisonScopeBuilder.right") : EMFCompareIDEUIMessages.getString("ComparisonScopeBuilder.ancestor"));
        BasicDiagnostic diagnostic = new BasicDiagnostic("org.eclipse.emf.compare.ide.ui", 0, EMFCompareIDEUIMessages.getString("ComparisonScopeBuilder.resourceSetDiagnostic", sideStr), new Object[0]);
        for (Resource resource : resourceSet.getResources()) {
            Diagnostic resourceDiagnostic = EcoreUtil.computeDiagnostic((Resource)resource, (boolean)includeWarning);
            diagnostic.merge(resourceDiagnostic);
        }
        return diagnostic;
    }

    private static Predicate<Resource> isInScope(final Set<URI> uris) {
        return new Predicate<Resource>(){

            public boolean apply(Resource input) {
                boolean result;
                if (input != null) {
                    URI inputUri = input.getURI();
                    if (uris.contains(inputUri)) {
                        result = true;
                    } else if (input.getResourceSet() != null && input.getResourceSet().getURIConverter() != null) {
                        URI normalizedInputUri = input.getResourceSet().getURIConverter().normalize(inputUri);
                        result = uris.contains(normalizedInputUri);
                    } else {
                        result = false;
                    }
                } else {
                    result = false;
                }
                return result;
            }
        };
    }
}

