/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.service;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.core.data.LayoutMetaDataService;
import org.eclipse.elk.core.service.LayoutConnectorsService;
import org.eclipse.elk.core.service.util.MonitoredOperation;
import org.eclipse.elk.core.util.Pair;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;

public final class ElkServicePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.elk.core.service";
    private static ElkServicePlugin plugin;
    private ExecutorService executorService;
    private final Multimap<Pair<IWorkbenchPart, Object>, MonitoredOperation> runningOperations = HashMultimap.create();
    protected static final String EXTP_ID_LAYOUT_PROVIDERS = "org.eclipse.elk.core.layoutProviders";
    protected static final String ELEMENT_PROVIDER = "provider";
    protected static final String ATTRIBUTE_CLASS = "class";

    public static ElkServicePlugin getInstance() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.loadLayoutProviders();
    }

    public void stop(BundleContext context) throws Exception {
        LayoutMetaDataService.unload();
        LayoutConnectorsService.unload();
        if (this.executorService != null) {
            this.executorService.shutdown();
            this.executorService = null;
        }
        plugin = null;
        super.stop(context);
    }

    public synchronized ExecutorService getExecutorService() {
        if (this.executorService == null && plugin != null) {
            this.executorService = Executors.newCachedThreadPool();
        }
        return this.executorService;
    }

    public Multimap<Pair<IWorkbenchPart, Object>, MonitoredOperation> getRunningOperations() {
        return this.runningOperations;
    }

    private void loadLayoutProviders() {
        IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_ID_LAYOUT_PROVIDERS);
        LayoutMetaDataService service = LayoutMetaDataService.getInstance();
        IConfigurationElement[] iConfigurationElementArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                ILayoutMetaDataProvider provider;
                if (ELEMENT_PROVIDER.equals(element.getName()) && (provider = (ILayoutMetaDataProvider)element.createExecutableExtension(ATTRIBUTE_CLASS)) != null) {
                    service.registerLayoutMetaDataProviders(new ILayoutMetaDataProvider[]{provider});
                }
            }
            catch (CoreException exception) {
                StatusManager.getManager().handle(exception, PLUGIN_ID);
            }
            ++n2;
        }
    }
}

