/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ajdt.internal.core.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.ajdt.core.ReflectionUtils;
import org.eclipse.ajdt.core.codeconversion.ConversionOptions;
import org.eclipse.ajdt.core.codeconversion.ITDAwareLookupEnvironment;
import org.eclipse.ajdt.core.codeconversion.ITDAwareNameEnvironment;
import org.eclipse.ajdt.core.codeconversion.JavaCompatibleBuffer;
import org.eclipse.ajdt.core.javaelements.AJCompilationUnit;
import org.eclipse.ajdt.core.javaelements.AspectElement;
import org.eclipse.ajdt.core.javaelements.IntertypeElement;
import org.eclipse.ajdt.core.javaelements.IntertypeElementInfo;
import org.eclipse.ajdt.core.model.AJProjectModelFacade;
import org.eclipse.ajdt.core.model.AJProjectModelFactory;
import org.eclipse.ajdt.core.model.AJRelationshipManager;
import org.eclipse.ajdt.internal.core.ras.CoreFFDC;
import org.eclipse.ajdt.internal.core.search.ExtraITDFinder;
import org.eclipse.ajdt.internal.core.search.ExtraPackageReferenceFinder;
import org.eclipse.ajdt.internal.core.search.ExtraTypeReferenceFinder;
import org.eclipse.ajdt.internal.core.search.IExtraMatchFinder;
import org.eclipse.ajdt.internal.core.search.NullMatchFinder;
import org.eclipse.contribution.jdt.itdawareness.ISearchProvider;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyResolver;
import org.eclipse.jdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.jdt.internal.core.search.matching.FieldPattern;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.search.matching.OrPattern;
import org.eclipse.jdt.internal.core.search.matching.PackageReferencePattern;
import org.eclipse.jdt.internal.core.search.matching.PossibleMatch;
import org.eclipse.jdt.internal.core.search.matching.TypeReferencePattern;

public class AJDTSearchProvider
implements ISearchProvider {
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.EnclosingStaticPart ajc$tjp_13;

    public IntertypeElement findITDGetter(IField field) {
        return this.findITDAccessor(field, true);
    }

    public IntertypeElement findITDSetter(IField field) {
        return this.findITDAccessor(field, false);
    }

    private IntertypeElement findITDAccessor(IField field, boolean getter) {
        AJProjectModelFacade model = AJProjectModelFactory.getInstance().getModelForJavaElement((IJavaElement)field);
        List<IJavaElement> rels = model.getRelationshipsForElement((IJavaElement)field.getDeclaringType(), AJRelationshipManager.ASPECT_DECLARATIONS);
        for (IJavaElement elt : rels) {
            IntertypeElement itd;
            if (!(elt instanceof IntertypeElement) || !this.isAccessorITDName((itd = (IntertypeElement)elt).getElementName(), field.getElementName(), field.getDeclaringType().getElementName(), field.getDeclaringType().getFullyQualifiedName(), getter) || !this.checkParameters(itd, field, getter) || !this.checkReturnType(itd, field, getter)) continue;
            return itd;
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkReturnType(IntertypeElement itd, IField field, boolean getter) {
        JavaModelException javaModelException2222222;
        block5: {
            block4: {
                if (!getter) break block4;
                return itd.getReturnType().equals(field.getTypeSignature()) || field.getTypeSignature().equals(String.valueOf(itd.getQualifiedReturnType()));
            }
            try {}
            catch (JavaModelException javaModelException2222222) {
                // empty catch block
                break block5;
            }
            return itd.getReturnType().equals("V");
            catch (JavaModelException javaModelException3) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException3, this, ajc$tjp_0, (JoinPoint.StaticPart)ajc$tjp_1);
                JavaModelException javaModelException4 = javaModelException3;
            }
        }
        CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException2222222, this, ajc$tjp_2, (JoinPoint.StaticPart)ajc$tjp_1);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkParameters(IntertypeElement itd, IField field, boolean getter) {
        block7: {
            JavaModelException javaModelException2;
            block8: {
                String typeSignature;
                String[] parameterTypes = itd.getParameterTypes();
                if (getter) {
                    return parameterTypes == null || parameterTypes.length == 0;
                }
                try {
                    if (parameterTypes == null || parameterTypes.length != 1) break block7;
                    typeSignature = field.getTypeSignature();
                    if (parameterTypes[0].equals(typeSignature)) {
                        return true;
                    }
                }
                catch (JavaModelException javaModelException2) {
                    // empty catch block
                    break block8;
                }
                try {
                    String itdParamSignature = itd.getQualifiedParameterTypes()[0];
                    int arrayCount = org.eclipse.jdt.core.Signature.getArrayCount((String)itdParamSignature);
                    if (itdParamSignature.charAt(arrayCount) == 'L') {
                        itdParamSignature = String.valueOf(itdParamSignature.substring(0, arrayCount)) + 'Q' + itdParamSignature.substring(arrayCount + 1);
                    }
                    return typeSignature.equals(itdParamSignature);
                }
                catch (JavaModelException javaModelException3) {
                    CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException3, this, ajc$tjp_3, (JoinPoint.StaticPart)ajc$tjp_4);
                    JavaModelException javaModelException4 = javaModelException3;
                }
            }
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException2, this, ajc$tjp_5, (JoinPoint.StaticPart)ajc$tjp_4);
        }
        return false;
    }

    private boolean isAccessorITDName(String itdName, String fieldName, String declaringTypeName, String declaringFullyQualifedName, boolean getter) {
        String prefix = getter ? "get" : "set";
        int lastDot = itdName.lastIndexOf(46);
        if (getter && lastDot >= 0 && itdName.indexOf(".is", lastDot) > 0) {
            prefix = "is";
        }
        String suffix = String.valueOf(prefix) + Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
        String accessorName = String.valueOf(declaringTypeName) + "." + suffix;
        if (itdName.equals(accessorName)) {
            return true;
        }
        accessorName = String.valueOf(declaringFullyQualifedName) + "." + suffix;
        return itdName.equals(accessorName);
    }

    public IJavaElement convertJavaElement(IJavaElement origElement) {
        if (origElement instanceof IntertypeElement) {
            try {
                IType targetType;
                IMember newElement;
                AJProjectModelFacade model;
                List<IJavaElement> rels;
                char[] targetTypeName = ((IntertypeElementInfo)((IntertypeElement)origElement).getElementInfo()).getTargetType();
                if (targetTypeName != null && (rels = (model = AJProjectModelFactory.getInstance().getModelForJavaElement(origElement)).getRelationshipsForElement(origElement, AJRelationshipManager.DECLARED_ON)).size() > 0 && rels.get(0) instanceof IType && (newElement = ((IntertypeElement)origElement).createMockDeclaration(targetType = (IType)rels.get(0))) != null) {
                    return newElement;
                }
            }
            catch (JavaModelException javaModelException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_6, (JoinPoint.StaticPart)ajc$tjp_7);
            }
        }
        return origElement;
    }

    public LookupEnvironment createLookupEnvironment(LookupEnvironment orig, ICompilationUnit[] workingCopies, JavaProject project) {
        try {
            ITDAwareNameEnvironment env = new ITDAwareNameEnvironment(project, workingCopies);
            return new ITDAwareLookupEnvironment(orig, (INameEnvironment)env);
        }
        catch (JavaModelException javaModelException) {
            CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_8, (JoinPoint.StaticPart)ajc$tjp_9);
            return orig;
        }
    }

    private IntertypeElement findMatchingITD(AspectElement parent, IMethod possibleTest, String itdName) throws JavaModelException {
        IntertypeElement[] allITDs;
        IntertypeElement[] intertypeElementArray = allITDs = parent.getITDs();
        int n = allITDs.length;
        int n2 = 0;
        while (n2 < n) {
            IntertypeElement itd = intertypeElementArray[n2];
            if (itdName.equals(itd.getElementName()) && Arrays.equals(itd.getParameterTypes(), possibleTest.getParameterTypes())) {
                return itd;
            }
            ++n2;
        }
        return null;
    }

    public IJavaElement filterJUnit4TestMatch(IJavaElement possibleTest) throws JavaModelException {
        String itdName;
        IntertypeElement matchingITD;
        if (!(possibleTest instanceof IMethod)) {
            return possibleTest;
        }
        IJavaElement parent = possibleTest.getAncestor(7);
        if (parent instanceof AspectElement && (matchingITD = this.findMatchingITD((AspectElement)parent, (IMethod)possibleTest, itdName = possibleTest.getElementName().replace('$', '.'))) != null) {
            return matchingITD.createMockDeclaration();
        }
        return possibleTest;
    }

    public List<SearchMatch> findExtraMatches(PossibleMatch match, SearchPattern pattern, HierarchyResolver resolver) throws JavaModelException {
        ArrayList<SearchMatch> extraMatches;
        if (match.openable instanceof AJCompilationUnit) {
            ((AJCompilationUnit)match.openable).requestOriginalContentMode();
        }
        if (pattern instanceof OrPattern) {
            SearchPattern[] patterns;
            extraMatches = new ArrayList();
            SearchPattern[] searchPatternArray = patterns = (SearchPattern[])ReflectionUtils.getPrivateField(OrPattern.class, "patterns", (OrPattern)pattern);
            int n = patterns.length;
            int n2 = 0;
            while (n2 < n) {
                SearchPattern orPattern = searchPatternArray[n2];
                extraMatches.addAll(this.findExtraMatches(match, orPattern, resolver));
                ++n2;
            }
        } else {
            IExtraMatchFinder<? extends SearchPattern> finder = this.getExtraMatchFinder(match, pattern);
            extraMatches = finder.findExtraMatches(match, (SearchPattern)pattern, resolver);
        }
        return extraMatches;
    }

    public void matchProcessed(PossibleMatch match) {
        if (match.openable instanceof AJCompilationUnit) {
            try {
                ((AJCompilationUnit)match.openable).discardOriginalContentMode();
            }
            catch (JavaModelException javaModelException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_10, (JoinPoint.StaticPart)ajc$tjp_11);
            }
        }
    }

    private IExtraMatchFinder<? extends SearchPattern> getExtraMatchFinder(PossibleMatch match, SearchPattern pattern) {
        if (match.openable instanceof AJCompilationUnit) {
            if (pattern instanceof MethodPattern || pattern instanceof ConstructorPattern || pattern instanceof FieldPattern) {
                return new ExtraITDFinder();
            }
            if (pattern instanceof TypeReferencePattern) {
                return new ExtraTypeReferenceFinder();
            }
            if (pattern instanceof PackageReferencePattern) {
                return new ExtraPackageReferenceFinder();
            }
        }
        return new NullMatchFinder();
    }

    public boolean isInteresting(IOpenable elt) {
        return elt instanceof AJCompilationUnit;
    }

    public char[] findSource(IOpenable elt) {
        if (elt instanceof AJCompilationUnit) {
            try {
                IBuffer buf = elt.getBuffer();
                if (buf instanceof JavaCompatibleBuffer) {
                    JavaCompatibleBuffer convertingBuf = (JavaCompatibleBuffer)buf;
                    ConversionOptions orig = convertingBuf.getConversionOptions();
                    convertingBuf.setConversionOptions(ConversionOptions.CONSTANT_SIZE);
                    char[] contents = convertingBuf.getCharacters();
                    convertingBuf.setConversionOptions(orig);
                    return contents;
                }
            }
            catch (JavaModelException javaModelException) {
                CoreFFDC.aspectOf().ajc$before$org_eclipse_ajdt_core_ras_FFDC$2$7ced305e(javaModelException, this, ajc$tjp_12, (JoinPoint.StaticPart)ajc$tjp_13);
            }
            return ((AJCompilationUnit)elt).getContents();
        }
        return null;
    }

    static {
        AJDTSearchProvider.ajc$preClinit();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AJDTSearchProvider.java", AJDTSearchProvider.class);
        ajc$tjp_0 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 97);
        ajc$tjp_1 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "checkReturnType", "org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.ajdt.core.javaelements.IntertypeElement:org.eclipse.jdt.core.IField:boolean", "itd:field:getter", "", "boolean"), 88);
        ajc$tjp_10 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 241);
        ajc$tjp_11 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "matchProcessed", "org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.jdt.internal.core.search.matching.PossibleMatch", "match", "", "void"), 235);
        ajc$tjp_12 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 279);
        ajc$tjp_13 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "findSource", "org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.jdt.core.IOpenable", "elt", "", "[C"), 267);
        ajc$tjp_2 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 97);
        ajc$tjp_3 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 124);
        ajc$tjp_4 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("2", "checkParameters", "org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.ajdt.core.javaelements.IntertypeElement:org.eclipse.jdt.core.IField:boolean", "itd:field:getter", "", "boolean"), 102);
        ajc$tjp_5 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 124);
        ajc$tjp_6 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 162);
        ajc$tjp_7 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "convertJavaElement", "org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.jdt.core.IJavaElement", "origElement", "", "org.eclipse.jdt.core.IJavaElement"), 147);
        ajc$tjp_8 = factory.makeSJP("exception-handler", (Signature)factory.makeCatchClauseSig("org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.jdt.core.JavaModelException", "<missing>"), 174);
        ajc$tjp_9 = factory.makeESJP("method-execution", (Signature)factory.makeMethodSig("1", "createLookupEnvironment", "org.eclipse.ajdt.internal.core.search.AJDTSearchProvider", "org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment:[Lorg.eclipse.jdt.core.ICompilationUnit;:org.eclipse.jdt.internal.core.JavaProject", "orig:workingCopies:project", "", "org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment"), 168);
    }
}

