/**
 * Copyright (c) 2017 Inria and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Inria - initial API and implementation
 */
package fr.inria.diverse.melange.ast;

import com.google.common.collect.Iterables;
import fr.inria.diverse.melange.metamodel.melange.Language;
import fr.inria.diverse.melange.metamodel.melange.Mapping;
import fr.inria.diverse.melange.metamodel.melange.ModelType;
import fr.inria.diverse.melange.metamodel.melange.ModelTypingSpace;
import fr.inria.diverse.melange.metamodel.melange.XbaseTransformation;

/**
 * A collection of utilities around Melange's AST
 */
@SuppressWarnings("all")
public class ASTHelper {
  public Iterable<Language> getLanguages(final ModelTypingSpace root) {
    return Iterables.<Language>filter(root.getElements(), Language.class);
  }
  
  public Iterable<ModelType> getModelTypes(final ModelTypingSpace root) {
    return Iterables.<ModelType>filter(root.getElements(), ModelType.class);
  }
  
  public Iterable<XbaseTransformation> getTransformations(final ModelTypingSpace root) {
    return Iterables.<XbaseTransformation>filter(root.getElements(), XbaseTransformation.class);
  }
  
  public Iterable<Mapping> getMappings(final ModelTypingSpace root) {
    return Iterables.<Mapping>filter(root.getElements(), Mapping.class);
  }
}
