/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core.nd.java;

import org.aspectj.org.eclipse.jdt.internal.core.nd.Nd;
import org.aspectj.org.eclipse.jdt.internal.core.nd.NdNode;
import org.aspectj.org.eclipse.jdt.internal.core.nd.db.IndexException;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldManyToOne;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.FieldOneToMany;
import org.aspectj.org.eclipse.jdt.internal.core.nd.field.StructDef;
import org.aspectj.org.eclipse.jdt.internal.core.nd.java.NdBinding;

public abstract class NdTreeNode
extends NdNode {
    public static final FieldManyToOne<NdTreeNode> PARENT;
    public static final FieldOneToMany<NdTreeNode> CHILDREN;
    public static final StructDef<NdTreeNode> type;

    static {
        type = StructDef.create(NdTreeNode.class, NdNode.type);
        PARENT = FieldManyToOne.create(type, null);
        CHILDREN = FieldOneToMany.create(type, PARENT, 16);
        type.done();
    }

    public NdTreeNode(Nd nd, long address) {
        super(nd, address);
    }

    protected NdTreeNode(Nd nd, NdTreeNode parent) {
        super(nd);
        PARENT.put(nd, this.address, parent == null ? 0L : parent.address);
    }

    public int getChildrenCount() {
        return CHILDREN.size(this.getNd(), this.address);
    }

    public NdTreeNode getChild(int index) {
        return CHILDREN.get(this.getNd(), this.address, index);
    }

    public <T extends NdTreeNode> T getAncestorOfType(Class<T> ancestorType) {
        long targetType = this.getNd().getNodeType(ancestorType);
        Nd nd = this.getNd();
        long current = PARENT.getAddress(nd, this.address);
        while (current != 0L) {
            short currentType = NdNode.NODE_TYPE.get(nd, current);
            if ((long)currentType == targetType) {
                NdNode result = NdTreeNode.load(nd, current);
                if (ancestorType.isInstance(result)) {
                    return (T)((NdTreeNode)result);
                }
                throw new IndexException("The node at address " + current + " should have been an instance of " + ancestorType.getName() + " but was an instance of " + result.getClass().getName());
            }
            current = PARENT.getAddress(nd, current);
        }
        return null;
    }

    NdTreeNode getParentNode() {
        return PARENT.get(this.getNd(), this.address);
    }

    public NdBinding getParentBinding() throws IndexException {
        NdTreeNode parent = this.getParentNode();
        if (parent instanceof NdBinding) {
            return (NdBinding)((Object)parent);
        }
        return null;
    }
}

