/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.validation;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.etrice.core.common.validation.CustomValidatorManager;
import org.eclipse.etrice.core.common.validation.ICustomValidator;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.osgi.framework.Bundle;

public class ValidatorExtensionManager
extends CustomValidatorManager {
    protected boolean isRegistryAvailable = Registry.isAvailable();

    @Inject
    public void registerExtensionValidators(Injector injector) {
        if (this.isRegistryAvailable) {
            Registry.getInstance().loadValidatorExtensions(injector);
        }
    }

    public void checkObjectsStandalone(EObject object) {
    }

    @Check(value=CheckType.FAST)
    public void checkObjectFast(EObject object) {
        this.checkObject(object, CheckType.FAST);
    }

    @Check(value=CheckType.NORMAL)
    public void checkObjectNormal(EObject object) {
        this.checkObject(object, CheckType.NORMAL);
    }

    @Check(value=CheckType.EXPENSIVE)
    public void checkObjectExpensive(EObject object) {
        this.checkObject(object, CheckType.EXPENSIVE);
    }

    protected void checkObject(EObject object, CheckType checkType) {
        CheckMode checkMode = switch (checkType) {
            case CheckType.FAST -> CheckMode.FAST_ONLY;
            case CheckType.NORMAL -> CheckMode.NORMAL_ONLY;
            case CheckType.EXPENSIVE -> CheckMode.EXPENSIVE_ONLY;
            default -> throw new IllegalArgumentException(Objects.toString(checkType));
        };
        if (this.isRegistryAvailable) {
            CustomValidatorManager.ValidationContextImpl context = new CustomValidatorManager.ValidationContextImpl(this.isStandalone(), this.isGeneration(), checkMode);
            for (ICustomValidator val : Registry.getInstance().getValidatorsToExecute(object, checkMode, this.getMessageAcceptor())) {
                this.executeValidator(val, object, null, this.getMessageAcceptor(), (ICustomValidator.ValidationContext)context);
            }
        } else {
            super.checkObjectsStandalone(object);
        }
    }

    public static class Registry {
        private static final String IVALIDATOR_ID = "org.eclipse.etrice.core.room.validation";
        private static Registry instance = null;
        private HashMap<String, ArrayList<ICustomValidator>> fastClass2Ext = new HashMap();
        private HashMap<String, ArrayList<ICustomValidator>> normalClass2Ext = new HashMap();
        private HashMap<String, ArrayList<ICustomValidator>> expensiveClass2Ext = new HashMap();
        private ArrayList<ValidatorInfo> infos = new ArrayList();
        private ArrayList<ValidatorInfo> excludedInfos = new ArrayList();
        private HashSet<ICustomValidator> excluded = new HashSet();

        public static Registry getInstance() {
            if (instance == null) {
                instance = new Registry();
            }
            return instance;
        }

        public static boolean isAvailable() {
            return EMFPlugin.IS_ECLIPSE_RUNNING && Platform.getExtensionRegistry() != null && Platform.getExtensionRegistry().getExtensionPoint(IVALIDATOR_ID) != null;
        }

        public void loadValidatorExtensions(Injector injector) {
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(IVALIDATOR_ID);
            HashMap<String, ArrayList<String>> cls2sub = new HashMap<String, ArrayList<String>>();
            for (EClassifier cls : RoomPackage.eINSTANCE.getEClassifiers()) {
                if (!(cls instanceof EClass)) continue;
                EList superTypes = ((EClass)cls).getESuperTypes();
                if (!cls.getName().equals("ActorClass")) continue;
                for (EClass sup : superTypes) {
                    EPackage pckg = (EPackage)sup.eContainer();
                    String path = pckg.getName();
                    this.put(path + "." + sup.getName(), cls.getEPackage().getName() + "." + ((EClass)cls).getName(), cls2sub);
                }
            }
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                try {
                    String extContributor = e.getContributor().getName();
                    Bundle extBundle = Platform.getBundle((String)extContributor);
                    String extClassName = e.getAttribute("class");
                    Class extClass = extBundle.loadClass(extClassName);
                    Object ext = injector.getInstance(extClass);
                    if (ext instanceof ICustomValidator) {
                        HashMap<String, ArrayList<ICustomValidator>> map;
                        ICustomValidator validator = (ICustomValidator)ext;
                        String mode = e.getAttribute("mode");
                        this.infos.add(new ValidatorInfo(validator, mode, e.getName() + "@" + e.getNamespaceIdentifier()));
                        String classToCheck = e.getAttribute("classToCheck");
                        int pos = classToCheck.lastIndexOf(46);
                        if (pos >= 0 && (pos = classToCheck.lastIndexOf(46, pos - 1)) >= 0) {
                            classToCheck = classToCheck.substring(pos + 1);
                        }
                        if ((map = this.getMap(mode)) != null) {
                            this.put(map, classToCheck, (ICustomValidator)ext);
                            ArrayList<String> subTypes = cls2sub.get(classToCheck);
                            if (subTypes != null) {
                                for (String type : subTypes) {
                                    this.put(map, type, (ICustomValidator)ext);
                                }
                            }
                        }
                    } else {
                        System.out.println("ValidatorExtensionManager: unexpected extension");
                    }
                }
                catch (ClassNotFoundException ex) {
                    System.out.println(ex.toString());
                }
                ++n2;
            }
        }

        public void exclude(ValidatorInfo info) {
            this.excludedInfos.add(info);
            this.excluded.add(info.getValidator());
        }

        public void include(ValidatorInfo info) {
            this.excludedInfos.remove(info);
            this.excluded.remove(info.getValidator());
        }

        public void setIncluded(Collection<ValidatorInfo> includedInfos) {
            this.excluded.clear();
            this.excludedInfos.clear();
            HashSet<ValidatorInfo> toExclude = new HashSet<ValidatorInfo>(this.infos);
            toExclude.removeAll(includedInfos);
            this.excludedInfos.addAll(toExclude);
            for (ValidatorInfo info : this.excludedInfos) {
                this.excluded.add(info.getValidator());
            }
        }

        public List<ValidatorInfo> getInfos() {
            return Collections.unmodifiableList(this.infos);
        }

        public List<ValidatorInfo> getExcludedInfos() {
            return Collections.unmodifiableList(this.excludedInfos);
        }

        public List<ICustomValidator> getValidatorsToExecute(EObject object, CheckMode checkMode, ValidationMessageAcceptor messageAcceptor) {
            LinkedHashSet<ICustomValidator> validators = new LinkedHashSet<ICustomValidator>();
            if (checkMode.shouldCheck(CheckType.FAST)) {
                validators.addAll(this.getValidators(object, messageAcceptor, this.fastClass2Ext));
            }
            if (checkMode.shouldCheck(CheckType.NORMAL)) {
                validators.addAll(this.getValidators(object, messageAcceptor, this.normalClass2Ext));
            }
            if (checkMode.shouldCheck(CheckType.EXPENSIVE)) {
                validators.addAll(this.getValidators(object, messageAcceptor, this.expensiveClass2Ext));
            }
            validators.removeAll(this.excluded);
            return Lists.newArrayList(validators);
        }

        private List<ICustomValidator> getValidators(EObject object, ValidationMessageAcceptor messageAcceptor, HashMap<String, ArrayList<ICustomValidator>> map) {
            ArrayList<ICustomValidator> result = new ArrayList<ICustomValidator>();
            ArrayList<ICustomValidator> validators = map.get(object.eClass().getEPackage().getName() + "." + object.eClass().getName());
            if (validators != null) {
                for (ICustomValidator validator : validators) {
                    result.add(validator);
                }
            }
            return result;
        }

        private void put(String cls, String sub, HashMap<String, ArrayList<String>> cls2sub) {
            ArrayList<String> list = cls2sub.get(cls);
            if (list == null) {
                list = new ArrayList();
                cls2sub.put(cls, list);
            }
            list.add(sub);
        }

        private void put(HashMap<String, ArrayList<ICustomValidator>> map, String cls, ICustomValidator val) {
            ArrayList<Object> list = map.get(cls);
            if (list == null) {
                list = new ArrayList();
                map.put(cls, list);
            }
            list.add(val);
        }

        private HashMap<String, ArrayList<ICustomValidator>> getMap(String mode) {
            if (mode.equals(CheckType.FAST.name())) {
                return this.fastClass2Ext;
            }
            if (mode.equals(CheckType.NORMAL.name())) {
                return this.normalClass2Ext;
            }
            if (mode.equals(CheckType.EXPENSIVE.name())) {
                return this.normalClass2Ext;
            }
            return null;
        }
    }

    public static class ValidatorInfo {
        public static final String SEP = "@";
        private ICustomValidator validator;
        private String id;
        private String mode;

        public ValidatorInfo(ICustomValidator validator, String mode, String id) {
            this.validator = validator;
            this.mode = mode;
            this.id = id;
        }

        public ICustomValidator getValidator() {
            return this.validator;
        }

        public String getName() {
            return this.validator.getName();
        }

        public String getDescription() {
            return this.validator.getDescription();
        }

        public String getMode() {
            return this.mode;
        }

        public String getId() {
            return this.id;
        }
    }
}

