/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.MessageHandler;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.c.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.fsm.generic.IDetailCodeTranslator;
import org.eclipse.etrice.generator.generic.GenericProtocolClassGenerator;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.etrice.generator.generic.TypeHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class ProtocolClassGen
extends GenericProtocolClassGenerator {
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    @Extension
    private CExtensions _cExtensions;
    @Inject
    @Extension
    private RoomExtensions roomExt;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;
    @Inject
    @Extension
    private TypeHelpers _typeHelpers;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;
    @Inject
    @Extension
    protected IDetailCodeTranslator _iDetailCodeTranslator;
    @Inject
    protected ILanguageExtension languageExt;
    @Inject
    private ILogger logger;

    public void doGenerate(Root root) {
        Functions.Function1 function1 = it -> {
            boolean bl = this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
            return !bl;
        };
        Consumer<ProtocolClass> consumer = pc -> {
            String path = this.roomExt.getPath((RoomClass)pc);
            String file = this._cExtensions.getCHeaderFileName((RoomClass)pc);
            this.fileIO.generateFile("generating ProtocolClass header", path + file, this.generateHeaderFile(root, (ProtocolClass)pc));
            file = this._cExtensions.getCUtilsFileName((RoomClass)pc);
            this.fileIO.generateFile("generating ProtocolClass utils", path + file, this.generateUtilsFile(root, (ProtocolClass)pc));
            file = this._cExtensions.getCSourceFileName((RoomClass)pc);
            this.fileIO.generateFile("generating ProtocolClass source", path + file, this.generateSourceFile(root, (ProtocolClass)pc));
        };
        IterableExtensions.filter((Iterable)root.getProtocolClasses(), (Functions.Function1)function1).forEach(consumer);
    }

    private CharSequence generateHeaderFile(Root root, ProtocolClass pc) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/**");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* @author generated by eTrice");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* Header File of ProtocolClass ");
        String string = pc.getName();
        stringConcatenation.append(string, " ");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append(" ");
        stringConcatenation.append("* ");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*/");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        CharSequence charSequence = this._cExtensions.generateIncludeGuardBegin((RoomClass)pc);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"etDatatypes.h\"");
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"modelbase/etPort.h\"");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        CharSequence charSequence2 = this._procedureHelpers.userCode(pc, 1);
        stringConcatenation.append((Object)charSequence2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("/* include all referenced room classes */");
        stringConcatenation.newLine();
        Object object = root.getReferencedProtocolClasses((RoomClass)pc);
        EList eList = root.getReferencedDataClasses((RoomClass)pc);
        Object object2 = Iterables.concat((Iterable)object, (Iterable)eList);
        Object object3 = root.getReferencedEnumClasses((RoomClass)pc);
        Object object4 = it -> this._cExtensions.getIncludePath((RoomClass)it);
        List list = IterableExtensions.sort((Iterable)IterableExtensions.map((Iterable)Iterables.concat((Iterable)object2, (Iterable)object3), (Functions.Function1)object4));
        for (String path : list) {
            stringConcatenation.append("#include ");
            stringConcatenation.append(path);
            stringConcatenation.newLineIfNotEmpty();
        }
        stringConcatenation.newLine();
        object = pc.getCommType();
        boolean bl = Objects.equals(object, CommunicationType.EVENT_DRIVEN);
        if (bl) {
            stringConcatenation.newLine();
            stringConcatenation.append("/* message IDs */");
            stringConcatenation.newLine();
            object2 = this.genMessageIDs(pc);
            stringConcatenation.append((String)object2);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.newLine();
            stringConcatenation.append("/*--------------------- port structs and methods */");
            stringConcatenation.newLine();
            object3 = this.portClassHeader(pc, false);
            stringConcatenation.append(object3);
            stringConcatenation.newLineIfNotEmpty();
            object4 = this.portClassHeader(pc, true);
            stringConcatenation.append(object4);
            stringConcatenation.newLineIfNotEmpty();
        } else {
            object2 = pc.getCommType();
            boolean bl2 = Objects.equals(object2, CommunicationType.DATA_DRIVEN);
            if (bl2) {
                stringConcatenation.append("/*--------------------- port structs and methods */");
                stringConcatenation.newLine();
                object4 = this.genDataDrivenPortHeaders(pc);
                stringConcatenation.append(object4);
                stringConcatenation.newLineIfNotEmpty();
            } else {
                object4 = pc.getCommType();
                boolean bl3 = Objects.equals(object4, CommunicationType.SYNCHRONOUS);
                if (bl3) {
                    stringConcatenation.append("#error \"synchronoue protocols not implemented yet\"");
                    stringConcatenation.newLine();
                }
            }
        }
        stringConcatenation.newLine();
        stringConcatenation.append("/*--------------------- debug helpers */");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("/* get message string for message id */");
        stringConcatenation.newLine();
        stringConcatenation.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("const char* ");
        object = pc.getName();
        stringConcatenation.append((String)object, "\t");
        stringConcatenation.append("_getMessageString(int msg_id);");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("#endif");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        CharSequence charSequence3 = this._procedureHelpers.userCode(pc, 2);
        stringConcatenation.append((Object)charSequence3);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        object2 = this._cExtensions.generateIncludeGuardEnd((RoomClass)pc);
        stringConcatenation.append(object2);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        return stringConcatenation;
    }

    private CharSequence generateUtilsFile(Root root, ProtocolClass pc) {
        CharSequence charSequence;
        boolean bl;
        StringConcatenation stringConcatenation = null;
        EObject eObject = pc.eContainer();
        String string = ((RoomModel)eObject).getName().replaceAll("\\.", "_");
        String string2 = string + "_";
        String string3 = pc.getName();
        String string4 = string2 + string3;
        String filename = string4 + "_Utils";
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Utils File of ProtocolClass ");
        String string5 = pc.getName();
        stringConcatenation2.append(string5, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* ");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        CharSequence charSequence2 = this._cExtensions.generateIncludeGuardBegin(filename);
        stringConcatenation2.append((Object)charSequence2);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        Object object = pc.getBase();
        boolean bl2 = bl = object != null;
        if (bl) {
            stringConcatenation2.append("// include base class utils");
            stringConcatenation2.newLine();
            stringConcatenation2.append("#include ");
            charSequence = this._cExtensions.getUtilsIncludePath((RoomClass)pc.getBase());
            stringConcatenation2.append(charSequence);
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("#include ");
        object = this._cExtensions.getIncludePath((RoomClass)pc);
        stringConcatenation2.append((String)object);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* access macros for operations and attributes");
        stringConcatenation2.newLine();
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        CharSequence charSequence3 = this.generateUtilsFile(pc, false);
        stringConcatenation2.append((Object)charSequence3);
        stringConcatenation2.newLineIfNotEmpty();
        charSequence = this.generateUtilsFile(pc, true);
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        CharSequence charSequence4 = this._cExtensions.generateIncludeGuardEnd(filename);
        stringConcatenation2.append((Object)charSequence4);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence generateUtilsFile(ProtocolClass pc, boolean conj) {
        StringConcatenation stringConcatenation = null;
        PortClass portClass = this.roomExt.getPortClass(pc, conj);
        String portClassName = this.roomExt.getPortClassName(pc, conj);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        if (portClass != null) {
            stringConcatenation2.append("/* ");
            if (conj) {
                stringConcatenation2.append("conjugate");
            } else {
                stringConcatenation2.append("regular");
            }
            stringConcatenation2.append(" port class */");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.newLine();
            stringConcatenation2.append("/* operations */");
            stringConcatenation2.newLine();
            EList eList = portClass.getOperations();
            for (PortOperation op : eList) {
                boolean bl;
                String params = this.operationParams((Operation)op);
                stringConcatenation2.newLineIfNotEmpty();
                String args = this.operationArgs((Operation)op);
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("#define ");
                String string = op.getName();
                stringConcatenation2.append(string);
                stringConcatenation2.append("(");
                stringConcatenation2.append(params);
                stringConcatenation2.append(") ");
                stringConcatenation2.append(portClassName);
                stringConcatenation2.append("_");
                String string2 = op.getName();
                stringConcatenation2.append(string2);
                stringConcatenation2.append("(self");
                boolean bl2 = op.getArguments().isEmpty();
                boolean bl3 = bl = !bl2;
                if (bl) {
                    stringConcatenation2.append(", ");
                    stringConcatenation2.append(args);
                }
                stringConcatenation2.append(")");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.newLine();
            stringConcatenation2.append("/* attributes */");
            stringConcatenation2.newLine();
            eList = portClass.getAttributes();
            for (Attribute a : eList) {
                stringConcatenation2.append("#define ");
                String string = a.getName();
                stringConcatenation2.append(string);
                stringConcatenation2.append(" (((");
                stringConcatenation2.append(portClassName);
                stringConcatenation2.append("_var*)(self->varData))->");
                String string3 = a.getName();
                stringConcatenation2.append(string3);
                stringConcatenation2.append(")");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private String operationParams(Operation op) {
        Functions.Function1 function1 = it -> {
            String string = null;
            boolean bl = false;
            boolean bl2 = it.isVarargs();
            if (bl2) {
                bl = true;
                string = "...";
            }
            if (!bl) {
                string = it.getName();
            }
            return string;
        };
        return IterableExtensions.join((Iterable)ListExtensions.map((List)op.getArguments(), (Functions.Function1)function1), (CharSequence)", ");
    }

    private String operationArgs(Operation op) {
        Functions.Function1 function1 = it -> {
            String string = null;
            boolean bl = false;
            boolean bl2 = it.isVarargs();
            if (bl2) {
                bl = true;
                string = "__VA_ARGS__";
            }
            if (!bl) {
                string = it.getName();
            }
            return string;
        };
        return IterableExtensions.join((Iterable)ListExtensions.map((List)op.getArguments(), (Functions.Function1)function1), (CharSequence)", ");
    }

    private CharSequence generateSourceFile(Root root, ProtocolClass pc) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("/**");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* @author generated by eTrice");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("* Source File of ProtocolClass ");
        String string = pc.getName();
        stringConcatenation.append(string, " ");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append(" ");
        stringConcatenation.append("* ");
        stringConcatenation.newLine();
        stringConcatenation.append(" ");
        stringConcatenation.append("*/");
        stringConcatenation.newLine();
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"");
        String string2 = this._cExtensions.getCHeaderFileName((RoomClass)pc);
        stringConcatenation.append(string2);
        stringConcatenation.append("\"");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("#include \"debugging/etMSCLogger.h\"");
        stringConcatenation.newLine();
        stringConcatenation.append("#include \"");
        String string3 = this._cExtensions.getCUtilsFileName((RoomClass)pc);
        stringConcatenation.append(string3);
        stringConcatenation.append("\"");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        CharSequence charSequence = this._procedureHelpers.userCode(pc, 3);
        stringConcatenation.append((Object)charSequence);
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("/*--------------------- port methods */");
        stringConcatenation.newLine();
        CommunicationType communicationType = pc.getCommType();
        boolean bl = Objects.equals(communicationType, CommunicationType.EVENT_DRIVEN);
        if (bl) {
            CharSequence charSequence2 = this.portClassSource(pc, false);
            stringConcatenation.append((Object)charSequence2);
            stringConcatenation.newLineIfNotEmpty();
            CharSequence charSequence3 = this.portClassSource(pc, true);
            stringConcatenation.append((Object)charSequence3);
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.newLine();
            stringConcatenation.append("/*--------------------- debug helpers */");
            stringConcatenation.newLine();
            stringConcatenation.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
            stringConcatenation.newLine();
            stringConcatenation.append("\t");
            CharSequence charSequence4 = this.generateDebugHelpersImplementation(root, pc);
            stringConcatenation.append((Object)charSequence4, "\t");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("#endif");
            stringConcatenation.newLine();
        } else {
            CommunicationType communicationType2 = pc.getCommType();
            boolean bl2 = Objects.equals(communicationType2, CommunicationType.DATA_DRIVEN);
            if (bl2) {
                CharSequence charSequence5 = this.genDataDrivenPortSources(pc);
                stringConcatenation.append((Object)charSequence5);
                stringConcatenation.newLineIfNotEmpty();
            } else {
                CommunicationType communicationType3 = pc.getCommType();
                boolean bl3 = Objects.equals(communicationType3, CommunicationType.SYNCHRONOUS);
                if (bl3) {
                    stringConcatenation.append("#error \"synchronous protocols not implemented yet\"");
                    stringConcatenation.newLine();
                }
            }
        }
        return stringConcatenation;
    }

    private CharSequence portClassHeader(ProtocolClass pc, Boolean conj) {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        boolean bl2;
        StringConcatenation stringConcatenation = null;
        String portClassName = this.roomExt.getPortClassName(pc, conj.booleanValue());
        String replPortClassName = this.roomExt.getPortClassName(pc, conj.booleanValue(), true);
        List list = null;
        list = conj != false ? this._roomHelpers.getAllIncomingMessages(pc) : this._roomHelpers.getAllOutgoingMessages(pc);
        List messages = list;
        List allPortClasses = this.roomExt.getAllPortClasses(pc, conj.booleanValue());
        Functions.Function1 function1 = p -> p.getAttributes();
        List allAttributes = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)allPortClasses, (Functions.Function1)function1)));
        Functions.Function1 function12 = p -> p.getOperations();
        List allOperations = IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)allPortClasses, (Functions.Function1)function12)));
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("typedef etPort ");
        stringConcatenation2.append(portClassName);
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("typedef etReplPort ");
        stringConcatenation2.append(replPortClassName);
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        boolean bl3 = allAttributes.isEmpty();
        boolean bl4 = bl2 = !bl3;
        if (bl2) {
            stringConcatenation2.append("/* variable part of PortClass (RAM) */");
            stringConcatenation2.newLine();
            stringConcatenation2.append("typedef struct ");
            stringConcatenation2.append(portClassName);
            stringConcatenation2.append("_var ");
            stringConcatenation2.append(portClassName);
            stringConcatenation2.append("_var; ");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("struct ");
            stringConcatenation2.append(portClassName);
            stringConcatenation2.append("_var {");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            object3 = this._procedureHelpers.attributes(allAttributes);
            stringConcatenation2.append(object3, "\t");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("};");
            stringConcatenation2.newLine();
            for (Attribute a : allAttributes) {
                boolean bl5;
                String string = a.getDefaultValueLiteral();
                boolean bl6 = bl5 = string != null;
                if (!bl5) continue;
                String string2 = a.getName();
                object2 = portClassName + " " + string2;
                String string3 = (String)object2 + ": Attribute initialization not supported in C";
                this.logger.logInfo(string3);
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        for (Message message : messages) {
            object3 = message.getData();
            boolean hasData = object3 != null;
            stringConcatenation2.newLineIfNotEmpty();
            object = null;
            object = hasData ? this._typeHelpers.typeName(message.getData().getRefType().getType()) : "";
            String typeName = object;
            stringConcatenation2.newLineIfNotEmpty();
            String string = null;
            string = hasData && (!this._typeHelpers.isEnumerationOrPrimitive(message.getData().getRefType().getType()) || message.getData().getRefType().isRef()) ? "*" : "";
            String refp = string;
            stringConcatenation2.newLineIfNotEmpty();
            object2 = null;
            object2 = hasData ? ", " + typeName + refp + " data" : "";
            String data = object2;
            stringConcatenation2.newLineIfNotEmpty();
            String string4 = this.messageSignature(portClassName, message.getName(), "", data);
            stringConcatenation2.append(string4);
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
            String string5 = this.messageSignature(replPortClassName, message.getName(), "_broadcast", data);
            stringConcatenation2.append(string5);
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
            String string6 = this.messageSignature(replPortClassName, message.getName(), "", ", int idx" + data);
            stringConcatenation2.append(string6);
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        bl3 = allOperations.isEmpty();
        boolean bl7 = bl = !bl3;
        if (bl) {
            object3 = this._procedureHelpers.portOperationsForC(allOperations, portClassName, true);
            stringConcatenation2.append(object3);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        bl3 = this.roomExt.handlesReceiveIncludingSuper(pc, conj.booleanValue());
        if (bl3) {
            List list2 = this.roomExt.getReceiveHandlersIncludingSuper(pc, conj.booleanValue());
            for (MessageHandler h : list2) {
                stringConcatenation2.append("void ");
                stringConcatenation2.append(portClassName);
                stringConcatenation2.append("_");
                object = h.getMsg().getName();
                stringConcatenation2.append((String)object);
                stringConcatenation2.append("_receiveHandler(");
                stringConcatenation2.append(portClassName);
                stringConcatenation2.append("* self, const etMessage* msg, void * actor, etActorReceiveMessage receiveMessageFunc);");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.append("etInt32 ");
        stringConcatenation2.append(replPortClassName);
        stringConcatenation2.append("_getReplication(const ");
        stringConcatenation2.append(replPortClassName);
        stringConcatenation2.append("* self);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence genDataDrivenPortHeaders(ProtocolClass pc) {
        String string;
        String string2;
        StringConcatenation stringConcatenation = null;
        Functions.Function1 function1 = m -> {
            MessageData messageData = m.getData();
            return messageData != null;
        };
        Iterable sentMsgs = IterableExtensions.filter((Iterable)this._roomHelpers.getAllIncomingMessages(pc), (Functions.Function1)function1);
        Functions.Function1 function12 = m -> this._typeHelpers.isEnumeration(m.getData().getRefType().getType());
        Iterable enumMsgs = IterableExtensions.filter((Iterable)sentMsgs, (Functions.Function1)function12);
        Functions.Function1 function13 = m -> this._typeHelpers.isBoolean(m.getData().getRefType().getType());
        Iterable boolMsgs = IterableExtensions.filter((Iterable)sentMsgs, (Functions.Function1)function13);
        boolean usesMSC = !IterableExtensions.isEmpty((Iterable)enumMsgs) || !IterableExtensions.isEmpty((Iterable)boolMsgs);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/* data driven send port (conjugated) */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("typedef struct ");
        String string3 = this.roomExt.getPortClassName(pc, true);
        stringConcatenation2.append(string3);
        stringConcatenation2.append(" {");
        stringConcatenation2.newLineIfNotEmpty();
        for (Message msg : sentMsgs) {
            stringConcatenation2.append("\t");
            String typeName = this._typeHelpers.typeName(msg.getData().getRefType().getType());
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            string2 = null;
            boolean bl = msg.getData().getRefType().isRef();
            string2 = bl ? "*" : "";
            String refp = string2;
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append(typeName, "\t");
            stringConcatenation2.append(refp, "\t");
            stringConcatenation2.append(" ");
            string = msg.getName();
            stringConcatenation2.append(string, "\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        if (usesMSC) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("const char* instName;");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("const char** peerNames;");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("#endif");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        String string4 = this.roomExt.getPortClassName(pc, true);
        stringConcatenation2.append(string4);
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* data driven receive port (regular) */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("typedef struct ");
        String string5 = this.roomExt.getPortClassName(pc, false);
        stringConcatenation2.append(string5);
        stringConcatenation2.append(" {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("const ");
        String string6 = this.roomExt.getPortClassName(pc, true);
        stringConcatenation2.append(string6, "\t");
        stringConcatenation2.append("* peer;");
        stringConcatenation2.newLineIfNotEmpty();
        if (usesMSC) {
            String string7;
            boolean bl;
            stringConcatenation2.append("\t");
            stringConcatenation2.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("const char* instName;");
            stringConcatenation2.newLine();
            for (Message msg_1 : enumMsgs) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                String typeName_1 = this._typeHelpers.typeName(msg_1.getData().getRefType().getType());
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                string = null;
                bl = msg_1.getData().getRefType().isRef();
                string = bl ? "*" : "";
                String refp_1 = string;
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append(typeName_1, "\t\t");
                stringConcatenation2.append(refp_1, "\t\t");
                stringConcatenation2.append(" ");
                string7 = msg_1.getName();
                stringConcatenation2.append(string7, "\t\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
            }
            for (Message msg_2 : boolMsgs) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                String typeName_2 = this._typeHelpers.typeName(msg_2.getData().getRefType().getType());
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                string = null;
                bl = msg_2.getData().getRefType().isRef();
                string = bl ? "*" : "";
                String refp_2 = string;
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append(typeName_2, "\t\t");
                stringConcatenation2.append(refp_2, "\t\t");
                stringConcatenation2.append(" ");
                string7 = msg_2.getName();
                stringConcatenation2.append(string7, "\t\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("\t");
            stringConcatenation2.append("#endif");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        string2 = this.roomExt.getPortClassName(pc, false);
        stringConcatenation2.append(string2);
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        for (Message message : sentMsgs) {
            string = message.getData();
            boolean hasData = string != null;
            stringConcatenation2.newLineIfNotEmpty();
            String string8 = null;
            string8 = hasData ? this._typeHelpers.typeName(message.getData().getRefType().getType()) : "";
            String typeName_3 = string8;
            stringConcatenation2.newLineIfNotEmpty();
            String string9 = null;
            string9 = hasData && !this._typeHelpers.isEnumerationOrPrimitive(message.getData().getRefType().getType()) ? "*" : "";
            String refp_3 = string9;
            stringConcatenation2.newLineIfNotEmpty();
            Object object = null;
            object = hasData ? ", " + typeName_3 + refp_3 + " data" : "";
            String data = object;
            stringConcatenation2.newLineIfNotEmpty();
            String string10 = this.messageSetterSignature(this.roomExt.getPortClassName(pc, true), message.getName(), data);
            stringConcatenation2.append(string10);
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
            String string11 = this.messageGetterSignature(this.roomExt.getPortClassName(pc, false), message.getName(), typeName_3);
            stringConcatenation2.append(string11);
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.newLine();
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence genDataDrivenPortSources(ProtocolClass pc) {
        StringConcatenation stringConcatenation = null;
        Functions.Function1 function1 = m -> {
            MessageData messageData = m.getData();
            return messageData != null;
        };
        Iterable messages = IterableExtensions.filter((Iterable)this._roomHelpers.getAllIncomingMessages(pc), (Functions.Function1)function1);
        Functions.Function1 function12 = m -> this._typeHelpers.isEnumeration(m.getData().getRefType().getType());
        Iterable enumMsgs = IterableExtensions.filter((Iterable)messages, (Functions.Function1)function12);
        Functions.Function1 function13 = m -> this._typeHelpers.isBoolean(m.getData().getRefType().getType());
        Iterable boolMsgs = IterableExtensions.filter((Iterable)messages, (Functions.Function1)function13);
        boolean usesMSC = !IterableExtensions.isEmpty((Iterable)enumMsgs) || !IterableExtensions.isEmpty((Iterable)boolMsgs);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        for (Message message : messages) {
            String string;
            String string2;
            String typeName = this._typeHelpers.typeName(message.getData().getRefType().getType());
            stringConcatenation2.newLineIfNotEmpty();
            String string3 = null;
            boolean bl = this._typeHelpers.isEnumerationOrPrimitive(message.getData().getRefType().getType());
            boolean bl2 = !bl;
            string3 = bl2 ? "*" : "";
            String refp = string3;
            stringConcatenation2.newLineIfNotEmpty();
            String data = ", " + typeName + refp + " data";
            stringConcatenation2.newLineIfNotEmpty();
            String string4 = this.messageSetterSignature(this.roomExt.getPortClassName(pc, true), message.getName(), data);
            stringConcatenation2.append(string4);
            stringConcatenation2.append(" {");
            stringConcatenation2.newLineIfNotEmpty();
            if (usesMSC && IterableExtensions.exists((Iterable)enumMsgs, m -> Objects.equals(m, message))) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("{");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("const char** peerName;");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("for (peerName=self->peerNames; *peerName!=NULL; ++peerName) {");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t\t\t");
                stringConcatenation2.append("ET_MSC_LOGGER_ASYNC_OUT(self->instName, ");
                string2 = message.getData().getRefType().getType().getName();
                stringConcatenation2.append(string2, "\t\t\t\t");
                stringConcatenation2.append("_getLiteralName(data), *peerName)");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t\t\t");
                stringConcatenation2.append("ET_MSC_LOGGER_ASYNC_IN(self->instName, ");
                string = message.getData().getRefType().getType().getName();
                stringConcatenation2.append(string, "\t\t\t\t");
                stringConcatenation2.append("_getLiteralName(data), *peerName)");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("#endif");
                stringConcatenation2.newLine();
            }
            if (usesMSC && IterableExtensions.exists((Iterable)boolMsgs, m -> Objects.equals(m, message))) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("#ifdef ET_ASYNC_MSC_LOGGER_ACTIVATE");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("{");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("const char** peerName;");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("for (peerName=self->peerNames; *peerName!=NULL; ++peerName) {");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t\t\t");
                stringConcatenation2.append("ET_MSC_LOGGER_ASYNC_OUT(self->instName, data?\"true\":\"false\", *peerName)");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t\t\t");
                stringConcatenation2.append("ET_MSC_LOGGER_ASYNC_IN(self->instName, data?\"true\":\"false\", *peerName)");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("#endif");
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("\t");
            stringConcatenation2.append("self->");
            string2 = message.getName();
            stringConcatenation2.append(string2, "\t");
            stringConcatenation2.append(" = ");
            stringConcatenation2.append(refp, "\t");
            stringConcatenation2.append("data;");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            string = this.messageGetterSignature(this.roomExt.getPortClassName(pc, false), message.getName(), typeName);
            stringConcatenation2.append(string);
            stringConcatenation2.append(" {");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("return self->peer->");
            String string5 = message.getName();
            stringConcatenation2.append(string5, "\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            stringConcatenation2.newLine();
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private boolean messageHasStringMessageAnnotation(Message m) {
        Functions.Function1 function1 = an -> {
            String string = an.getType().getName();
            return Objects.equals(string, "StringMessage");
        };
        return IterableExtensions.exists((Iterable)m.getAnnotations(), (Functions.Function1)function1);
    }

    private CharSequence genStringMessageHandler(Message m, String selfName, boolean conj) {
        StringConcatenation stringConcatenation = null;
        String string = null;
        string = conj ? "IN_" : "OUT_";
        String dir = string;
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("// charPtr handled as c-string as @StringMessage annotation is present on the message");
        stringConcatenation2.newLine();
        stringConcatenation2.append("ET_MSC_LOGGER_ASYNC_OUT((");
        stringConcatenation2.append(selfName);
        stringConcatenation2.append(")->myInstName, \"");
        String string2 = m.getName();
        stringConcatenation2.append(string2);
        stringConcatenation2.append("\", (");
        stringConcatenation2.append(selfName);
        stringConcatenation2.append(")->peerInstName)");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("etPort_sendStringMessage(");
        stringConcatenation2.append(selfName);
        stringConcatenation2.append(", ");
        String string3 = this._roomHelpers.getProtocolClass((EObject)m).getName();
        String string4 = m.getName();
        String string5 = dir + string4;
        String string6 = this._cExtensions.memberInUse(string3, string5);
        stringConcatenation2.append(string6);
        stringConcatenation2.append(", data__et);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence portClassSource(ProtocolClass pc, Boolean conj) {
        boolean bl;
        CharSequence charSequence;
        StringConcatenation stringConcatenation = null;
        List allPortClasses = this.roomExt.getAllPortClasses(pc, conj.booleanValue());
        String portClassName = this.roomExt.getPortClassName(pc, conj.booleanValue());
        String replPortClassName = this.roomExt.getPortClassName(pc, conj.booleanValue(), true);
        List list = null;
        list = conj != false ? this._roomHelpers.getAllIncomingMessages(pc) : this._roomHelpers.getAllOutgoingMessages(pc);
        List messages = list;
        String string = null;
        string = conj != false ? "IN_" : "OUT_";
        String dir = string;
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        for (Message message : messages) {
            CharSequence charSequence2;
            Object object;
            Object object2;
            Object object3;
            CharSequence charSequence3;
            CharSequence charSequence4;
            MessageData messageData = message.getData();
            boolean hasData = messageData != null;
            stringConcatenation2.newLineIfNotEmpty();
            charSequence = null;
            charSequence = hasData ? this._typeHelpers.typeName(message.getData().getRefType().getType()) : "";
            String typeName = charSequence;
            stringConcatenation2.newLineIfNotEmpty();
            String string2 = null;
            string2 = hasData && message.getData().getRefType().isRef() ? "*" : "";
            String refp = string2;
            stringConcatenation2.newLineIfNotEmpty();
            String string3 = null;
            string3 = hasData && (!this._typeHelpers.isEnumerationOrPrimitive(message.getData().getRefType().getType()) || message.getData().getRefType().isRef()) ? "*" : "";
            String refpd = string3;
            stringConcatenation2.newLineIfNotEmpty();
            String string4 = null;
            string4 = hasData && !this._typeHelpers.isEnumerationOrPrimitive(message.getData().getRefType().getType()) && !message.getData().getRefType().isRef() ? "" : "&";
            String refa = string4;
            stringConcatenation2.newLineIfNotEmpty();
            Object object4 = null;
            object4 = hasData ? ", " + typeName + refpd + " data__et" : "";
            String data = object4;
            stringConcatenation2.newLineIfNotEmpty();
            String string5 = null;
            string5 = hasData ? ", data__et" : "";
            String dataCall = string5;
            stringConcatenation2.newLineIfNotEmpty();
            MessageHandler hdlr = this.roomExt.getSendHandler(message, conj.booleanValue());
            stringConcatenation2.newLineIfNotEmpty();
            boolean needsStringMessageHandler = this.messageHasStringMessageAnnotation(message);
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.newLine();
            String string6 = this.messageSignature(portClassName, message.getName(), "", data);
            stringConcatenation2.append(string6);
            stringConcatenation2.append(" {");
            stringConcatenation2.newLineIfNotEmpty();
            if (hdlr != null) {
                stringConcatenation2.append("\t");
                charSequence4 = this._iDetailCodeTranslator.getTranslatedCode(hdlr.getDetailCode());
                stringConcatenation2.append(charSequence4, "\t");
                stringConcatenation2.newLineIfNotEmpty();
            } else if (needsStringMessageHandler) {
                stringConcatenation2.append("\t");
                charSequence4 = this.genStringMessageHandler(message, "self", conj);
                stringConcatenation2.append((Object)charSequence4, "\t");
                stringConcatenation2.newLineIfNotEmpty();
            } else {
                stringConcatenation2.append("\t");
                charSequence4 = pc.getName();
                charSequence3 = message.getName();
                object3 = dir + charSequence3;
                object2 = this.sendMessageCall(hasData, "self", this._cExtensions.memberInUse((String)charSequence4, (String)object3), typeName + refp, refa + "data__et");
                stringConcatenation2.append(object2, "\t");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("ET_MSC_LOGGER_ASYNC_OUT(self->myInstName, \"");
                object = message.getName();
                stringConcatenation2.append((String)object, "\t");
                stringConcatenation2.append("\", self->peerInstName)");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            stringConcatenation2.newLine();
            charSequence4 = this.messageSignature(replPortClassName, message.getName(), "_broadcast", data);
            stringConcatenation2.append(charSequence4);
            stringConcatenation2.append(" {");
            stringConcatenation2.newLineIfNotEmpty();
            if (hdlr != null) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("int i;");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("for (i=0; i<((etReplPort*)self)->size; ++i) {");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append(portClassName, "\t\t");
                stringConcatenation2.append("_");
                charSequence3 = message.getName();
                stringConcatenation2.append(charSequence3, "\t\t");
                stringConcatenation2.append("(&((etReplPort*)self)->ports[i].port");
                stringConcatenation2.append(dataCall, "\t\t");
                stringConcatenation2.append(");");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            } else if (needsStringMessageHandler) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("int i;");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("for (i=0; i<((etReplPort*)self)->size; ++i) {");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                charSequence3 = this.genStringMessageHandler(message, "&((etReplPort*)self)->ports[i].port", conj);
                stringConcatenation2.append((Object)charSequence3, "\t\t");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            } else {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("int i;");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("for (i=0; i<((etReplPort*)self)->size; ++i) {");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                charSequence3 = pc.getName();
                object3 = message.getName();
                object2 = dir + (String)object3;
                object = this.sendMessageCall(hasData, "(&((etReplPort*)self)->ports[i].port)", this._cExtensions.memberInUse((String)charSequence3, (String)object2), typeName + refp, refa + "data__et");
                stringConcatenation2.append(object, "\t\t");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("ET_MSC_LOGGER_ASYNC_OUT(((etReplPort*)self)->ports[i].port.myInstName, \"");
                charSequence2 = message.getName();
                stringConcatenation2.append(charSequence2, "\t\t");
                stringConcatenation2.append("\", ((etReplPort*)self)->ports[i].port.peerInstName)");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            stringConcatenation2.newLine();
            charSequence3 = this.messageSignature(replPortClassName, message.getName(), "", ", int idx__et" + data);
            stringConcatenation2.append(charSequence3);
            stringConcatenation2.append(" {");
            stringConcatenation2.newLineIfNotEmpty();
            if (hdlr != null) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append(portClassName, "\t");
                stringConcatenation2.append("_");
                object3 = message.getName();
                stringConcatenation2.append((String)object3, "\t");
                stringConcatenation2.append("(&((etReplPort*)self)->ports[idx__et].port");
                stringConcatenation2.append(dataCall, "\t");
                stringConcatenation2.append(");");
                stringConcatenation2.newLineIfNotEmpty();
            } else if (needsStringMessageHandler) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("if (0<=idx__et && idx__et<((etReplPort*)self)->size) {");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                object3 = this.genStringMessageHandler(message, "(&((etReplPort*)self)->ports[idx__et].port)", conj);
                stringConcatenation2.append(object3, "\t\t");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            } else {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("if (0<=idx__et && idx__et<((etReplPort*)self)->size) {");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                object3 = pc.getName();
                object2 = message.getName();
                object = dir + (String)object2;
                charSequence2 = this.sendMessageCall(hasData, "(&((etReplPort*)self)->ports[idx__et].port)", this._cExtensions.memberInUse((String)object3, (String)object), typeName + refp, refa + "data__et");
                stringConcatenation2.append((Object)charSequence2, "\t\t");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("ET_MSC_LOGGER_ASYNC_OUT(((etReplPort*)self)->ports[idx__et].port.myInstName, \"");
                String string7 = message.getName();
                stringConcatenation2.append(string7, "\t\t");
                stringConcatenation2.append("\", ((etReplPort*)self)->ports[idx__et].port.peerInstName)");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("}");
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            stringConcatenation2.newLine();
        }
        boolean bl2 = allPortClasses.isEmpty();
        boolean bl3 = bl = !bl2;
        if (bl) {
            stringConcatenation2.append("/* begin ");
            stringConcatenation2.append(portClassName);
            stringConcatenation2.append(" specific (including base classes) */");
            stringConcatenation2.newLineIfNotEmpty();
            for (PortClass p : allPortClasses) {
                charSequence = this._procedureHelpers.userCode(p.getUserCode());
                stringConcatenation2.append((Object)charSequence);
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.newLine();
            for (PortClass p_1 : allPortClasses) {
                charSequence = this._procedureHelpers.portOperationsForC((List)p_1.getOperations(), portClassName, false);
                stringConcatenation2.append((Object)charSequence);
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("/* end ");
            stringConcatenation2.append(portClassName);
            stringConcatenation2.append(" specific (including base classes) */");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("etInt32 ");
        stringConcatenation2.append(replPortClassName);
        stringConcatenation2.append("_getReplication(const ");
        stringConcatenation2.append(replPortClassName);
        stringConcatenation2.append("* self) {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("return ((etReplPort*)self)->size;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        bl2 = this.roomExt.handlesReceive(pc, conj.booleanValue());
        if (bl2) {
            CharSequence charSequence5 = this.genReceiveHandlers(pc, conj);
            stringConcatenation2.append((Object)charSequence5);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence sendMessageCall(boolean hasData, String selfPtr, String msg, String typeName, String data) {
        StringConcatenation stringConcatenation = new StringConcatenation();
        if (hasData) {
            stringConcatenation.append("etPort_sendMessage(");
            stringConcatenation.append(selfPtr);
            stringConcatenation.append(", ");
            stringConcatenation.append(msg);
            stringConcatenation.append(", sizeof(");
            stringConcatenation.append(typeName);
            stringConcatenation.append("), ");
            stringConcatenation.append(data);
            stringConcatenation.append(");");
            stringConcatenation.newLineIfNotEmpty();
        } else {
            stringConcatenation.append("etPort_sendMessage(");
            stringConcatenation.append(selfPtr);
            stringConcatenation.append(", ");
            stringConcatenation.append(msg);
            stringConcatenation.append(", 0, NULL);");
            stringConcatenation.newLineIfNotEmpty();
        }
        return stringConcatenation;
    }

    private String messageSignature(String className, String messageName, String methodSuffix, String data) {
        return "void " + className + "_" + messageName + methodSuffix + "(const " + className + "* self" + data + ")";
    }

    private String messageSetterSignature(String className, String messageName, String data) {
        return "void " + className + "_" + messageName + "_set(" + className + "* self" + data + ")";
    }

    private String messageGetterSignature(String className, String messageName, String type) {
        return type + " " + className + "_" + messageName + "_get(const " + className + "* const self)";
    }

    private CharSequence genReceiveHandlers(ProtocolClass pc, Boolean conj) {
        StringConcatenation stringConcatenation = null;
        String portClassName = this.roomExt.getPortClassName(pc, conj.booleanValue());
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/* receiver handlers */");
        stringConcatenation2.newLine();
        List list = this.roomExt.getReceiveHandlers(pc, conj.booleanValue());
        for (MessageHandler h : list) {
            stringConcatenation2.append("void ");
            stringConcatenation2.append(portClassName);
            stringConcatenation2.append("_");
            String string = h.getMsg().getName();
            stringConcatenation2.append(string);
            stringConcatenation2.append("_receiveHandler(");
            stringConcatenation2.append(portClassName);
            stringConcatenation2.append("* self, const etMessage* msg, void * actor, etActorReceiveMessage receiveMessageFunc){");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            String string2 = this._iDetailCodeTranslator.getTranslatedCode(h.getDetailCode());
            stringConcatenation2.append(string2, "\t");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("/* hand over the message to the actor:      */");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("/* (*receiveMessageFunc)(actor, self, msg); */");
            stringConcatenation2.newLine();
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence generateDebugHelpersImplementation(Root root, ProtocolClass pc) {
        String string;
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.newLine();
        stringConcatenation.append("/* message names as strings for debugging (generate MSC) */");
        stringConcatenation.newLine();
        stringConcatenation.append("static const char* const ");
        String string2 = pc.getName();
        stringConcatenation.append(string2);
        stringConcatenation.append("_messageStrings[] = {\"MIN\", ");
        Object object = this._roomHelpers.getAllOutgoingMessages(pc);
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            Message m = (Message)object2.next();
            stringConcatenation.append("\"");
            string = m.getName();
            stringConcatenation.append(string);
            stringConcatenation.append("\",");
        }
        object = this._roomHelpers.getAllIncomingMessages(pc);
        object2 = object.iterator();
        while (object2.hasNext()) {
            Message m_1 = (Message)object2.next();
            stringConcatenation.append("\"");
            string = m_1.getName();
            stringConcatenation.append(string);
            stringConcatenation.append("\", ");
        }
        stringConcatenation.append("\"MAX\"};");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.newLine();
        stringConcatenation.append("const char* ");
        object = pc.getName();
        stringConcatenation.append((String)object);
        stringConcatenation.append("_getMessageString(int msg_id) {");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        stringConcatenation.append("if (msg_id<");
        String string3 = pc.getName();
        stringConcatenation.append(string3, "\t");
        stringConcatenation.append("_MSG_MIN || msg_id>");
        object2 = pc.getName();
        stringConcatenation.append((String)object2, "\t");
        stringConcatenation.append("_MSG_MAX+1){");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("/* id out of range */");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("return \"Message ID out of range\";");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.append("\t");
        stringConcatenation.append("else{");
        stringConcatenation.newLine();
        stringConcatenation.append("\t\t");
        stringConcatenation.append("return ");
        string = pc.getName();
        stringConcatenation.append(string, "\t\t");
        stringConcatenation.append("_messageStrings[msg_id];");
        stringConcatenation.newLineIfNotEmpty();
        stringConcatenation.append("\t");
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        stringConcatenation.append("}");
        stringConcatenation.newLine();
        return stringConcatenation;
    }
}

