/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.abstractexec.behavior;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.abstractexec.behavior.ActionCodeAnalyzer;
import org.eclipse.etrice.abstractexec.behavior.Activator;
import org.eclipse.etrice.abstractexec.behavior.ActiveRules;
import org.eclipse.etrice.abstractexec.behavior.HandledMessage;
import org.eclipse.etrice.core.fsm.fSM.InitialTransition;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.naming.FSMNameProvider;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.CommonTrigger;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphContainer;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.GraphItem;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Link;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Node;

public class SemanticsCheck {
    private GraphContainer gc;
    private Queue<Node> queue = new LinkedList<Node>();
    private Set<Node> visited = new HashSet<Node>();
    private HashMap<GraphItem, ActiveRules> mapToRules = new HashMap();
    private ActionCodeAnalyzer codeAnalyzer;
    private HashMap<GraphItem, List<HandledMessage>> mapToWarnings = new HashMap();
    private FSMNameProvider fsmNameProvider = new FSMNameProvider();
    private static boolean traceChecks = false;
    private static int traceLevel = 0;
    private static final int TRACE_RESULT = 1;
    private static final int TRACE_DETAILS = 2;

    static {
        if (Activator.getDefault().isDebugging()) {
            String value = Platform.getDebugOption((String)"org.eclipse.etrice.abstractexec.behavior/trace/checks");
            if (value != null && value.equalsIgnoreCase(Boolean.toString(true))) {
                traceChecks = true;
            }
            if ((value = Platform.getDebugOption((String)"org.eclipse.etrice.abstractexec.behavior/trace/checks/level")) != null) {
                traceLevel = Integer.parseInt(value);
            }
        }
    }

    public SemanticsCheck(GraphContainer gc) {
        this.gc = gc;
        this.codeAnalyzer = new ActionCodeAnalyzer(gc.getComponent());
    }

    public void checkSemantics() {
        if (traceChecks) {
            System.out.println("checkSemantics: check of ActorClass " + this.gc.getComponent().getComponentName());
        }
        ActiveRules localRules = new ActiveRules();
        localRules.buildInitLocalRules(this.gc.getComponent());
        this.addStartingPoints(this.gc.getGraph(), localRules);
        this.doTraversal();
        if (traceChecks) {
            if (traceLevel >= 1) {
                this.printRules();
            }
            System.out.println("checkSemantics: done with check of ActorClass " + this.gc.getComponent().getComponentName());
        }
    }

    private void addStartingPoints(Graph graph, ActiveRules localRules) {
        EList links = graph.getLinks();
        for (Link link : links) {
            List<HandledMessage> wrongMsgList;
            if (!(link.getTransition() instanceof InitialTransition)) continue;
            Node cur = link.getTarget();
            List<HandledMessage> msgList = this.codeAnalyzer.analyze(link.getTransition().getAction());
            if (cur.getStateGraphNode() instanceof State) {
                msgList.addAll(this.codeAnalyzer.analyze(((State)cur.getStateGraphNode()).getEntryCode()));
            }
            if (!(wrongMsgList = localRules.consumeMessages(msgList)).isEmpty()) {
                this.addToWarning((GraphItem)link, wrongMsgList);
            }
            boolean rulesChanged = false;
            if (this.mapToRules.containsKey(cur)) {
                rulesChanged = this.mapToRules.get(cur).merge(localRules);
            } else {
                this.mapToRules.put((GraphItem)link.getTarget(), localRules);
                rulesChanged = true;
            }
            if (this.visited.contains(link.getTarget()) && !rulesChanged) break;
            this.queue.add(link.getTarget());
            break;
        }
    }

    private void doTraversal() {
        while (!this.queue.isEmpty()) {
            this.visit(this.queue.poll());
        }
    }

    private void visit(Node node) {
        this.visited.add(node);
        if (node.getStateGraphNode() instanceof State) {
            State st = (State)node.getStateGraphNode();
            if (node.getSubgraph() != null) {
                this.addStartingPoints(node.getSubgraph(), this.mapToRules.get(node));
            } else {
                for (CommonTrigger trigger : node.getCaughtTriggers()) {
                    if (traceChecks && traceLevel >= 2) {
                        System.out.println("  Currently visiting: " + st.getName());
                        System.out.println("  Trigger: " + this.fsmNameProvider.getMessageName(trigger.getMsg()));
                    }
                    for (Link link : trigger.getLinks()) {
                        List<HandledMessage> wrongMsgList;
                        Node target = link.getTarget();
                        LinkedList<HandledMessage> msgList = new LinkedList<HandledMessage>();
                        msgList.add(new HandledMessage(trigger.getIfitem(), trigger.getMsg(), (EObject)trigger));
                        StateGraph triggerContext = link.getGraph().getStateGraph();
                        State exitCalled = st;
                        while (true) {
                            msgList.addAll(this.codeAnalyzer.analyze(exitCalled.getExitCode()));
                            if (exitCalled.eContainer() == triggerContext) break;
                            exitCalled = (State)exitCalled.eContainer().eContainer();
                        }
                        msgList.addAll(this.codeAnalyzer.analyze(link.getTransition().getAction()));
                        if (target.getStateGraphNode() instanceof State) {
                            msgList.addAll(this.codeAnalyzer.analyze(((State)target.getStateGraphNode()).getEntryCode()));
                        }
                        ActiveRules tempRule = this.mapToRules.get(node).createCopy();
                        if (traceChecks && traceLevel >= 2) {
                            System.out.println("  Messages in msglist before consuming: ");
                            for (HandledMessage msg : msgList) {
                                System.out.println("  Msg: " + this.fsmNameProvider.getMessageName(msg.getMsg()));
                            }
                        }
                        if (traceChecks && traceLevel >= 2) {
                            System.out.println("  rules before consuming message list : ");
                            this.printRules();
                        }
                        if (!(wrongMsgList = tempRule.consumeMessages(msgList)).isEmpty()) {
                            this.addToWarning((GraphItem)link, wrongMsgList);
                        }
                        if (traceChecks && traceLevel >= 2) {
                            System.out.println("  Messages consumed");
                        }
                        this.addAndMergeRules(target, tempRule);
                        if (!traceChecks || traceLevel < 2) continue;
                        System.out.println("  rules after consuming and merging message list : ");
                        this.printRules();
                    }
                }
            }
        } else {
            for (Link link : node.getOutgoing()) {
                List<HandledMessage> wrongMsgList;
                ActiveRules tempRule = this.mapToRules.get(node).createCopy();
                List<HandledMessage> msgList = this.codeAnalyzer.analyze(link.getTransition().getAction());
                Node target = link.getTarget();
                if (target.getStateGraphNode() instanceof State) {
                    msgList.addAll(this.codeAnalyzer.analyze(((State)target.getStateGraphNode()).getEntryCode()));
                }
                if (!(wrongMsgList = tempRule.consumeMessages(msgList)).isEmpty()) {
                    this.addToWarning((GraphItem)link, wrongMsgList);
                }
                this.addAndMergeRules(target, tempRule);
            }
        }
    }

    private void addToWarning(GraphItem item, List<HandledMessage> wrongMsgList) {
        if (this.mapToWarnings.containsKey(item)) {
            this.mapToWarnings.get(item).addAll(wrongMsgList);
        } else {
            this.mapToWarnings.put(item, wrongMsgList);
        }
    }

    private void addAndMergeRules(Node target, ActiveRules tempRule) {
        boolean rulesChanged = false;
        if (this.mapToRules.containsKey(target)) {
            rulesChanged = this.mapToRules.get(target).merge(tempRule);
        } else {
            this.mapToRules.put((GraphItem)target, tempRule);
            rulesChanged = true;
        }
        if (!this.visited.contains(target) || rulesChanged) {
            this.queue.add(target);
        }
    }

    public void printRules() {
        System.out.println("  Current Rules: ");
        System.out.println("    MapToRules size: " + this.mapToRules.size());
        for (GraphItem item : this.mapToRules.keySet()) {
            System.out.println("    Rules for " + FsmGenExtensions.getName((GraphItem)item) + " : ");
            this.mapToRules.get(item).print();
        }
    }

    public ActiveRules getActiveRules(GraphItem item) {
        return this.mapToRules.get(item);
    }

    public List<HandledMessage> getWarningMsg(GraphItem item) {
        return this.mapToWarnings.get(item);
    }
}

