/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.validation;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Binding;
import org.eclipse.etrice.core.room.BindingEndPoint;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.ConnectionNecessity;
import org.eclipse.etrice.core.room.LayerConnection;
import org.eclipse.etrice.core.room.LogicalSystem;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.ReferenceType;
import org.eclipse.etrice.core.room.RoomPackage;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.SubSystemRef;
import org.eclipse.etrice.core.room.util.Multiplicities;
import org.eclipse.etrice.core.room.util.RoomHelpers;
import org.eclipse.xtext.validation.AbstractDeclarativeValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class WiringValidator
extends AbstractDeclarativeValidator {
    @Inject
    RoomHelpers roomHelpers;
    public static final String MULTIPLICITY_ANY_REQUIRES_OPTIONAL = "multiplicity any [*] requires optional";
    public static final String ACTOR_REF_CHANGE_REF_TYPE_TO_OPTIONAL = "MultiplicityValidator.ActorRefChangeRefTypeToOptional";

    @Check
    public void checkDataDrivenPortMultiplicity(Port port) {
        if (port.getProtocol() instanceof ProtocolClass && port.getProtocol().getCommType() == CommunicationType.DATA_DRIVEN && port.getMultiplicity() != 1) {
            this.error("multiplicity must be 1 for data driven ports", (EStructuralFeature)RoomPackage.eINSTANCE.getPort_Multiplicity());
        }
    }

    @Check
    public void checkActorRefMultiplicity(ActorRef ref) {
        if (ref.getMultiplicity() == -1 && ref.getRefType() != ReferenceType.OPTIONAL) {
            this.error(MULTIPLICITY_ANY_REQUIRES_OPTIONAL, (EStructuralFeature)RoomPackage.eINSTANCE.getActorRef_RefType(), ACTOR_REF_CHANGE_REF_TYPE_TO_OPTIONAL, new String[0]);
        }
        if (ref.getMultiplicity() != 1) {
            ActorClass ac = ref.getType();
            if (this.getAll(ac, ActorClass::getInterfacePorts).stream().anyMatch(port -> port.getMultiplicity() == -1)) {
                this.error("replicated actors must not have replicated ports with multiplicity any", null);
            }
            if (this.getAll(ac, ActorContainerClass::getServiceProvisionPoints).stream().anyMatch(spp -> true)) {
                this.error("replicated actors must not have service provision points", null);
            }
        }
    }

    @Check
    public void checkLayerConnectionTarget(LayerConnection lc) {
        if (lc.getTo().getRef() instanceof ActorRef && ((ActorRef)lc.getTo().getRef()).getMultiplicity() > 1) {
            this.error("layer connection must not connect to replicated actor", null);
        }
    }

    @Check
    public void checkOptionalRelayPortBinding(Binding binding) {
        boolean isEp2Relay;
        EndPoint ep1 = new EndPoint(binding.getEndpoint1());
        EndPoint ep2 = new EndPoint(binding.getEndpoint2());
        boolean isEp1Relay = ep1.ref == null && this.roomHelpers.isRelay(ep1.port);
        boolean bl = isEp2Relay = ep2.ref == null && this.roomHelpers.isRelay(ep2.port);
        if (ep1.ref != null && isEp2Relay || ep2.ref != null && isEp1Relay) {
            EndPoint otherEp;
            Port relayPort = isEp1Relay ? ep1.port : ep2.port;
            EndPoint endPoint = otherEp = isEp1Relay ? ep2 : ep1;
            if (this.checkMandatoryKeyword(otherEp.port) && !this.checkMandatoryKeyword(relayPort)) {
                boolean isRelayInherited = this.roomHelpers.getStructureClass(relayPort) != this.roomHelpers.getStructureClass(binding);
                String quickfixCode = isRelayInherited ? null : "RoomJavaValidator.ChangeConnectionNecessity";
                this.warning("Relay port \"" + relayPort.getName() + "\" is connected to mandatory port \"" + otherEp.toString() + "\" which requires a connection but the relay port is not defined as \"mandatory Port\"", null, quickfixCode, new String[]{relayPort.getName()});
            }
        }
    }

    @Check
    public void checkPortMultiplicities(LogicalSystem ls) {
        ArrayList<EndPoint> endpoints = new ArrayList<EndPoint>();
        for (SubSystemRef ref : ls.getSubSystems()) {
            EList<Port> relayPorts = ref.getType().getRelayPorts();
            for (Port port : relayPorts) {
                EndPoint ep = new EndPoint(ref, port);
                endpoints.add(ep);
            }
        }
        this.checkPortMultiplicities(true, (List<Binding>)ls.getBindings(), Collections.emptyList(), (List<EndPoint>)endpoints);
    }

    @Check
    public void checkPortMultiplicities(SubSystemClass ssc) {
        EList<Port> relayPorts = ssc.getRelayPorts();
        ArrayList<EndPoint> endpoints = new ArrayList<EndPoint>();
        for (Port port : relayPorts) {
            EndPoint ep = new EndPoint(port);
            endpoints.add(ep);
        }
        for (ActorRef ref : ssc.getActorRefs()) {
            List interfacePorts = this.getAll(ref.getType(), ActorClass::getInterfacePorts);
            for (Port port : interfacePorts) {
                EndPoint ep = new EndPoint(ref, port);
                endpoints.add(ep);
            }
        }
        this.checkPortMultiplicities(true, (List<Binding>)ssc.getBindings(), (List<Port>)relayPorts, (List<EndPoint>)endpoints);
    }

    @Check
    public void checkPortMultiplicities(ActorClass ac) {
        EndPoint ep;
        List relayPorts = this.getAll(ac, ActorClass::getRelayPorts);
        ArrayList<EndPoint> endpoints = new ArrayList<EndPoint>();
        List internalPorts = this.getAll(ac, ActorClass::getInternalPorts);
        for (Port port : internalPorts) {
            ep = new EndPoint(port);
            endpoints.add(ep);
        }
        for (Port port : relayPorts) {
            ep = new EndPoint(port);
            endpoints.add(ep);
        }
        for (ActorRef ref : this.getAll(ac, ActorContainerClass::getActorRefs)) {
            List interfacePorts = this.getAll(ref.getType(), ActorClass::getInterfacePorts);
            for (Port port : interfacePorts) {
                EndPoint ep2 = new EndPoint(ref, port);
                endpoints.add(ep2);
            }
        }
        this.checkPortMultiplicities(!ac.isAbstract(), this.getAll(ac, StructureClass::getBindings), relayPorts, endpoints);
    }

    private void checkPortMultiplicities(boolean checkForMandatoryBindings, List<Binding> bindings, List<Port> relays, List<EndPoint> endpoints) {
        HashMap computedPeerCount = new HashMap();
        endpoints.forEach(ep -> computedPeerCount.put(ep, 0));
        bindings.forEach(binding -> {
            EndPoint ep1 = new EndPoint(binding.getEndpoint1());
            EndPoint ep2 = new EndPoint(binding.getEndpoint2());
            int multiplicity = Multiplicities.minimum(this.getMultiplicity(ep1), this.getMultiplicity(ep2));
            computedPeerCount.merge(ep1, multiplicity, Multiplicities::plus);
            computedPeerCount.merge(ep2, multiplicity, Multiplicities::plus);
        });
        computedPeerCount.entrySet().forEach(entry -> {
            EndPoint ep = (EndPoint)entry.getKey();
            int multiplicity = this.getMultiplicity(ep);
            int calculated = (Integer)entry.getValue();
            if (checkForMandatoryBindings && Multiplicities.compare(calculated, multiplicity) < 0) {
                if (relays.contains(ep.port) && ep.ref == null) {
                    if (calculated == 0) {
                        this.warning("Relay port \"" + ep.toString() + "\" is not connected.\nRelay ports must be connected internally.", (EStructuralFeature)RoomPackage.eINSTANCE.getRoomClass_Name());
                    } else {
                        this.warning("Relay port \"" + ep.toString() + "\" is connected to " + Multiplicities.toString(calculated) + " peers but its multiplicity is " + Multiplicities.toString(multiplicity) + ". \nFor replicated relay ports each port must have a peer.", (EStructuralFeature)RoomPackage.eINSTANCE.getRoomClass_Name());
                    }
                } else if (this.checkMandatoryKeyword(ep.port)) {
                    if (calculated == 0) {
                        this.warning("mandatory port \"" + ep.toString() + "\" is not connected", (EStructuralFeature)RoomPackage.eINSTANCE.getRoomClass_Name());
                    } else {
                        this.warning("mandatory port \"" + ep.toString() + "\" is connected to " + Multiplicities.toString(calculated) + " peers but its multiplicity is " + Multiplicities.toString(multiplicity) + ". \nFor mandatory ports with multiplicity > 1 each port must have a peer.", (EStructuralFeature)RoomPackage.eINSTANCE.getRoomClass_Name());
                    }
                }
            } else if (Multiplicities.compare(calculated, multiplicity) > 0) {
                if (multiplicity == 1) {
                    this.warning("port \"" + ep.toString() + "\" is connected to more than one peer", (EStructuralFeature)RoomPackage.eINSTANCE.getRoomClass_Name());
                } else {
                    this.warning("port \"" + ep.toString() + "\" is connected to " + Multiplicities.toString(calculated) + " peers but its multiplicity is only " + Multiplicities.toString(multiplicity), (EStructuralFeature)RoomPackage.eINSTANCE.getRoomClass_Name());
                }
            }
        });
    }

    private int getMultiplicity(EndPoint ep) {
        int multiplicator = ep.ref != null && ep.ref instanceof ActorRef ? ((ActorRef)ep.ref).getMultiplicity() : 1;
        return Multiplicities.times(multiplicator, ep.port.getMultiplicity());
    }

    private <T> List<T> getAll(ActorClass ac, Function<ActorClass, Collection<? extends T>> getter) {
        return this.roomHelpers.getClassHierarchy(ac).stream().flatMap(getter.andThen(Collection::stream)).collect(Collectors.toList());
    }

    public void register(EValidatorRegistrar registrar) {
    }

    public boolean checkMandatoryKeyword(Port port) {
        return port.getConnectionNecessity() == ConnectionNecessity.MANDATORY;
    }

    private static class EndPoint {
        public final ActorContainerRef ref;
        public final Port port;

        public EndPoint(Port port) {
            this.ref = null;
            this.port = port;
        }

        public EndPoint(ActorContainerRef ref, Port port) {
            this.ref = ref;
            this.port = port;
        }

        public EndPoint(BindingEndPoint ep) {
            this(ep.getActorRef(), ep.getPort());
        }

        public String toString() {
            return this.ref == null ? this.port.getName() : String.valueOf(this.ref.getName()) + "." + this.port.getName();
        }

        public int hashCode() {
            return Objects.hash(this.port, this.ref);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EndPoint other = (EndPoint)obj;
            return Objects.equals(this.port, other.port) && Objects.equals(this.ref, other.ref);
        }
    }
}

