/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ide.modelpath;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.etrice.core.common.ide.modelpath.ModelPathDescriptionLexer;
import org.eclipse.etrice.generator.base.io.FileSystemModelPath;
import org.eclipse.etrice.generator.base.io.IModelPath;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.WorkspaceFolder;
import org.eclipse.xtext.xbase.lib.Pair;

public class ModelPathManager {
    private static final Logger LOG = Logger.getLogger(ModelPathManager.class);
    public static final String MODELPATH_FILE_NAME = "modelpath";
    private Map<Path, ModelPathDescription> descriptions = new HashMap<Path, ModelPathDescription>();
    private ListMultimap<String, ModelPathDescription> name2description = MultimapBuilder.hashKeys().arrayListValues().build();
    private Map<Path, FileSystemModelPath> modelpaths = Collections.emptyMap();

    @Inject
    public ModelPathManager() {
    }

    public IModelPath getModelPath(String uri) {
        return ModelPathManager.uriToPath(uri).map(this.modelpaths::get).orElse(IModelPath.EMPTY);
    }

    public Stream<String> getModelDirectories(String uri) {
        return ModelPathManager.uriToPath(uri).map(this.descriptions::get).map(description -> description.modelDirs.stream().map(dir -> modelPathDescription.path.relativize(dir.getPath()).toString())).orElse(Stream.empty());
    }

    public Set<String> getProjectDependencies(String uri) {
        return ModelPathManager.uriToPath(uri).map(this.descriptions::get).map(this::getAllDependencies).orElse(Collections.emptySet());
    }

    public void workspaceFoldersChanged(List<WorkspaceFolder> added, List<WorkspaceFolder> removed) {
        removed.forEach(folder -> ModelPathManager.uriToPath(folder.getUri()).ifPresent(path -> this.discardDescription((Path)path, folder.getName())));
        added.forEach(folder -> ModelPathManager.uriToPath(folder.getUri()).ifPresent(path -> this.loadDescription((Path)path, folder.getName())));
        this.computeModelPaths();
    }

    public boolean filesChanged(List<FileEvent> changes) {
        ArrayList<Pair> dirtyDescriptions = new ArrayList<Pair>();
        changes.forEach(event -> ModelPathManager.uriToPath(event.getUri()).ifPresent(path -> this.findDescription((Path)path).ifPresent(description -> {
            if (description.path.resolve(MODELPATH_FILE_NAME).equals(path)) {
                dirtyDescriptions.add(Pair.of((Object)description.path, (Object)description.name));
            }
            if (event.getType() != FileChangeType.Changed) {
                this.findDirectory((ModelPathDescription)description, (Path)path).ifPresent(modelDir -> {
                    if (event.getType() == FileChangeType.Created && Files.isRegularFile(path, new LinkOption[0])) {
                        modelDir.addFile(path);
                    } else if (event.getType() == FileChangeType.Deleted) {
                        modelDir.removeFile(path);
                    }
                });
            }
        })));
        if (!dirtyDescriptions.isEmpty()) {
            dirtyDescriptions.forEach(pair -> {
                this.discardDescription((Path)pair.getKey(), (String)pair.getValue());
                this.loadDescription((Path)pair.getKey(), (String)pair.getValue());
            });
            this.computeModelPaths();
            return true;
        }
        return false;
    }

    private void computeModelPaths() {
        this.modelpaths = this.descriptions.values().stream().collect(Collectors.toMap(description -> description.path, description -> Stream.concat(Stream.of(description), this.getAllDependencies((ModelPathDescription)description).stream().flatMap(name -> this.name2description.get(name).stream())).flatMap(descr -> descr.modelDirs.stream()).collect(Collectors.collectingAndThen(Collectors.toList(), FileSystemModelPath::new))));
    }

    private HashSet<String> getAllDependencies(ModelPathDescription description) {
        HashSet<String> dependencies = new HashSet<String>();
        description.dependencies.forEach(name -> this.addAllDependencies((String)name, dependencies));
        return dependencies;
    }

    private void addAllDependencies(String name, HashSet<String> dependencies) {
        if (dependencies.add(name)) {
            this.name2description.get((Object)name).forEach(description -> description.dependencies.forEach(dependency -> this.addAllDependencies((String)dependency, dependencies)));
        }
    }

    private void loadDescription(Path path, String name) {
        Path file = path.resolve(MODELPATH_FILE_NAME);
        List<ModelPathDescriptionLexer.ModelPathDescriptionEntry> entries = Collections.emptyList();
        if (Files.isRegularFile(file, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream input = Files.newInputStream(file, new OpenOption[0]);){
                    entries = ModelPathDescriptionLexer.read(input);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                LOG.error((Object)("Failed to read modelpath description file " + file + " of project " + name), (Throwable)e);
            }
        }
        ArrayList<FileSystemModelPath.ModelDirectory> modelDirs = new ArrayList<FileSystemModelPath.ModelDirectory>();
        ArrayList<String> dependencies = new ArrayList<String>();
        entries.forEach(entry -> {
            if (entry.key.equals("srcDir")) {
                try {
                    Path dir = path.resolve(entry.value);
                    modelDirs.add(new FileSystemModelPath.ModelDirectory(dir));
                }
                catch (InvalidPathException invalidPathException) {
                    LOG.error((Object)("Invalid model directory name " + entry.value + " in modelpath description of project " + name));
                }
            } else if (entry.key.equals("project")) {
                dependencies.add(entry.value);
            } else {
                LOG.error((Object)("Unknown keyword " + entry.key + " in modelpath description of project " + name));
            }
        });
        modelDirs.forEach(modelDir -> {
            if (Files.isDirectory(modelDir.getPath(), new LinkOption[0])) {
                try {
                    modelDir.indexDirectory();
                }
                catch (IOException e) {
                    LOG.error((Object)("Failed to read model directory " + modelDir.getPath() + " of project " + name), (Throwable)e);
                }
            } else {
                LOG.warn((Object)("Model directory " + modelDir.getPath() + " of project " + name + " does not exists."));
            }
        });
        ModelPathDescription description = new ModelPathDescription(path, name, modelDirs, dependencies);
        this.descriptions.put(path, description);
        this.name2description.put((Object)name, (Object)description);
    }

    private void discardDescription(Path path, String name) {
        this.descriptions.remove(path);
        this.name2description.get((Object)name).removeIf(description -> description.path.equals(path));
    }

    private Optional<ModelPathDescription> findDescription(Path path) {
        return this.descriptions.values().stream().filter(description -> path.startsWith(description.path)).max(Comparator.comparingInt(description -> description.path.getNameCount()));
    }

    private Optional<FileSystemModelPath.ModelDirectory> findDirectory(ModelPathDescription description, Path path) {
        Optional<FileSystemModelPath.ModelDirectory> result = description.modelDirs.stream().filter(dir -> path.startsWith(dir.getPath())).max(Comparator.comparingInt(dir -> dir.getPath().getNameCount()));
        return result;
    }

    private static Optional<Path> uriToPath(String uri) {
        try {
            return Optional.of(Paths.get(URI.create(uri)));
        }
        catch (FileSystemNotFoundException e) {
            LOG.error((Object)("Unknown uri " + uri + "; " + e.getMessage()), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Illegal uri " + uri + "; " + e.getMessage()), (Throwable)e);
        }
        return Optional.empty();
    }

    private static class ModelPathDescription {
        public final Path path;
        public final String name;
        public final List<FileSystemModelPath.ModelDirectory> modelDirs;
        public final List<String> dependencies;

        public ModelPathDescription(Path path, String name, List<FileSystemModelPath.ModelDirectory> modelDirs, List<String> dependencies) {
            this.path = path;
            this.name = name;
            this.modelDirs = modelDirs;
            this.dependencies = dependencies;
        }
    }
}

