/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.apps;

import java.util.EnumSet;
import java.util.List;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.eventbased.SupervisorSynthesis;
import org.eclipse.escet.cif.eventbased.analysis.SynthesisDummyDump;
import org.eclipse.escet.cif.eventbased.analysis.SynthesisDump;
import org.eclipse.escet.cif.eventbased.analysis.SynthesisDumpInterface;
import org.eclipse.escet.cif.eventbased.apps.conversion.ConvertFromEventBased;
import org.eclipse.escet.cif.eventbased.apps.conversion.ConvertToEventBased;
import org.eclipse.escet.cif.eventbased.apps.conversion.ConvertToEventBasedPreChecker;
import org.eclipse.escet.cif.eventbased.apps.options.AddStateAnnosOption;
import org.eclipse.escet.cif.eventbased.apps.options.DumpFileEnableOption;
import org.eclipse.escet.cif.eventbased.apps.options.DumpFileOption;
import org.eclipse.escet.cif.eventbased.apps.options.ResultNameOption;
import org.eclipse.escet.cif.eventbased.apps.options.WarnDisjunctGroups;
import org.eclipse.escet.cif.eventbased.apps.options.WarnEmptyAlphabet;
import org.eclipse.escet.cif.eventbased.apps.options.WarnMarkedDeadlock;
import org.eclipse.escet.cif.eventbased.apps.options.WarnSingleUseControllable;
import org.eclipse.escet.cif.eventbased.automata.Automaton;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.io.CifWriter;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.options.OutputFileOption;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.PathPair;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.Termination;
import org.eclipse.escet.common.java.exceptions.ApplicationException;
import org.eclipse.escet.common.java.exceptions.InvalidModelException;

public class SupervisorSynthesisApplication
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        SupervisorSynthesisApplication app = new SupervisorSynthesisApplication();
        app.run(args, true);
    }

    public SupervisorSynthesisApplication() {
    }

    public SupervisorSynthesisApplication(AppStreams streams) {
        super(streams);
    }

    private OptionCategory getTransformationOptionPage() {
        List subPages = Lists.list();
        List options = Lists.list();
        options.add(Options.getInstance(InputFileOption.class));
        options.add(Options.getInstance(OutputFileOption.class));
        options.add(Options.getInstance(ResultNameOption.class));
        options.add(Options.getInstance(AddStateAnnosOption.class));
        options.add(Options.getInstance(DumpFileEnableOption.class));
        options.add(Options.getInstance(DumpFileOption.class));
        options.add(Options.getInstance(WarnDisjunctGroups.class));
        options.add(Options.getInstance(WarnEmptyAlphabet.class));
        options.add(Options.getInstance(WarnMarkedDeadlock.class));
        options.add(Options.getInstance(WarnSingleUseControllable.class));
        return new OptionCategory("Supervisor synthesis", "CIF Event-based supervisor synthesis options.", subPages, options);
    }

    protected OptionCategory getAllOptions() {
        List subPages = Lists.list();
        subPages.add(this.getTransformationOptionPage());
        subPages.add(SupervisorSynthesisApplication.getGeneralOptionCategory());
        List options = Lists.list();
        String optDesc = "All options for the event-based supervisor synthesis tool.";
        return new OptionCategory("Event-based supervisor synthesis options", optDesc, subPages, options);
    }

    protected OutputProvider<IOutputComponent> createProvider() {
        return new OutputProvider();
    }

    protected int runInternal() {
        String resultName;
        Specification spec;
        CifReader cifReader;
        block19: {
            Automaton aut;
            block18: {
                String dumpFilename;
                ConvertToEventBased cte;
                block16: {
                    block15: {
                        String absSpecPath;
                        block14: {
                            try {
                                OutputProvider.dbg((String)"Loading CIF specification \"%s\"...", (Object[])new Object[]{InputFileOption.getPath()});
                                cifReader = (CifReader)new CifReader().init();
                                spec = (Specification)cifReader.read();
                                absSpecPath = Paths.resolve((String)InputFileOption.getPath());
                                if (!this.isTerminationRequested()) break block14;
                                return 0;
                            }
                            catch (ApplicationException e) {
                                String msg = Strings.fmt((String)"Failed to create supervisor for CIF file \"%s\".", (Object[])new Object[]{InputFileOption.getPath()});
                                throw new ApplicationException(msg, (Throwable)e);
                            }
                        }
                        new ElimComponentDefInst().transform(spec);
                        boolean allowPlainEvents = false;
                        boolean allowNonDeterminism = false;
                        ConvertToEventBasedPreChecker.ExpectedNumberOfAutomata expectedNumberOfAutomata = ConvertToEventBasedPreChecker.ExpectedNumberOfAutomata.AT_LEAST_ONE_PLANT_AUTOMATON;
                        EnumSet<SupKind> disallowedAutSupKinds = EnumSet.of(SupKind.NONE, SupKind.SUPERVISOR);
                        boolean requireAutHasInitLoc = false;
                        boolean requireReqSubsetPlantAlphabet = true;
                        boolean requireAutMarkedAndNonMarked = false;
                        Termination termination = () -> this.isTerminationRequested();
                        ConvertToEventBasedPreChecker checker = new ConvertToEventBasedPreChecker(allowPlainEvents, allowNonDeterminism, expectedNumberOfAutomata, disallowedAutSupKinds, requireAutHasInitLoc, requireReqSubsetPlantAlphabet, requireAutMarkedAndNonMarked, termination);
                        checker.reportPreconditionViolations(spec, absSpecPath, this.getAppName());
                        OutputProvider.dbg((String)"Converting to internal representation...");
                        cte = new ConvertToEventBased();
                        cte.convertSpecification(spec);
                        cte.sortAutomata();
                        if (!this.isTerminationRequested()) break block15;
                        return 0;
                    }
                    OutputProvider.dbg((String)"Computing supervisor...");
                    SupervisorSynthesis.synthesisPreCheck(cte.automata, WarnDisjunctGroups.isEnabled(), WarnEmptyAlphabet.isEnabled(), WarnMarkedDeadlock.isEnabled(), WarnSingleUseControllable.isEnabled());
                    if (!this.isTerminationRequested()) break block16;
                    return 0;
                }
                if (DumpFileOption.getPath() == null && !DumpFileEnableOption.isEnabled()) {
                    dumpFilename = null;
                } else {
                    dumpFilename = DumpFileOption.getDerivedPath(".cif", ".synth_dump");
                    dumpFilename = Paths.resolve((String)dumpFilename);
                }
                aut = null;
                try (SynthesisDumpInterface synDump = null;){
                    synDump = dumpFilename == null ? new SynthesisDummyDump() : new SynthesisDump(dumpFilename);
                    aut = SupervisorSynthesis.synthesis(cte.automata, synDump);
                }
                synDump = null;
                if (aut.initial == null) {
                    throw new InvalidModelException("Supervisor is empty.");
                }
                if (!this.isTerminationRequested()) break block18;
                return 0;
            }
            OutputProvider.dbg((String)"Converting from internal representation...");
            resultName = "sup";
            resultName = ResultNameOption.getRsltName(resultName);
            boolean doAddStateAnnos = AddStateAnnosOption.getStateAnnotationsEnabled();
            ConvertFromEventBased cfe = new ConvertFromEventBased();
            spec = cfe.convertAutomaton(aut, resultName, doAddStateAnnos);
            if (!this.isTerminationRequested()) break block19;
            return 0;
        }
        Object outPath = "_" + resultName + ".cif";
        outPath = OutputFileOption.getDerivedPath((String)".cif", (String)outPath);
        OutputProvider.dbg((String)"Writing result to \"%s\"...", (Object[])new Object[]{outPath});
        String absOutPath = Paths.resolve((String)outPath);
        CifWriter.writeCifSpec((Specification)spec, (PathPair)new PathPair((String)outPath, absOutPath), (String)cifReader.getAbsDirPath());
        return 0;
    }

    public String getAppName() {
        return "CIF supervisor synthesis tool";
    }

    public String getAppDescription() {
        return "Constructs a maximal permissive supervisor automaton from deterministic event-based plant and requirement automata.";
    }
}

