/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.cif2cif;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.escet.cif.cif2cif.CifToCifPreconditionException;
import org.eclipse.escet.cif.cif2cif.CifToCifTransformation;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.common.CifGuardUtils;
import org.eclipse.escet.cif.common.CifScopeUtils;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.common.CifValueUtils;
import org.eclipse.escet.cif.metamodel.cif.ComplexComponent;
import org.eclipse.escet.cif.metamodel.cif.Component;
import org.eclipse.escet.cif.metamodel.cif.Group;
import org.eclipse.escet.cif.metamodel.cif.InvKind;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.automata.Edge;
import org.eclipse.escet.cif.metamodel.cif.automata.EdgeEvent;
import org.eclipse.escet.cif.metamodel.cif.automata.Location;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.BinaryOperator;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.output.WarnOutput;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class ElimStateEvtExclInvs
implements CifToCifTransformation {
    private final WarnOutput warnOutput;
    private Set<Event> specSyncSendRecvAlphabet;
    private boolean anyStateEventExclInvsRemoved;

    public ElimStateEvtExclInvs() {
        this(OutputProvider.getWarningOutputStream());
    }

    public ElimStateEvtExclInvs(WarnOutput warnOutput) {
        this.warnOutput = warnOutput;
    }

    @Override
    public void transform(Specification spec) {
        if (CifScopeUtils.hasCompDefInst((Group)spec)) {
            String msg = "Eliminating state/event exclusion invariants for a CIF specification with component definitions is currently not supported.";
            throw new CifToCifPreconditionException(msg);
        }
        List alphabets = CifEventUtils.getAllAlphabets((Specification)spec);
        this.specSyncSendRecvAlphabet = (Set)alphabets.stream().flatMap(a -> Stream.concat(Stream.concat(a.syncAlphabet.stream(), a.sendAlphabet.stream()), a.recvAlphabet.stream())).collect(Sets.toSet());
        this.anyStateEventExclInvsRemoved = false;
        this.elimStateEvtExclInvs((ComplexComponent)spec);
        if (this.anyStateEventExclInvsRemoved) {
            this.warnOutput.line("One or more state/event exclusion invariants were removed, since their events are not in the synchronization, send or receive alphabet of the specification.");
        }
    }

    private void elimStateEvtExclInvs(ComplexComponent comp) {
        List<Invariant> compInvs = this.filterInvs((List<Invariant>)comp.getInvariants());
        this.rewriteDisablesInvs(compInvs);
        List locInvs = Lists.list();
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            for (Location loc : aut.getLocations()) {
                List<Invariant> invs = this.filterInvs((List<Invariant>)loc.getInvariants());
                this.rewriteDisablesInvs(invs);
                this.modifyLocInvs(aut, invs);
                locInvs.addAll(invs);
            }
        }
        List invs = Lists.concat(compInvs, (List)locInvs);
        Iterator invIter = invs.iterator();
        while (invIter.hasNext()) {
            Event event;
            Invariant inv2 = (Invariant)invIter.next();
            Expression eventRef = inv2.getEvent();
            if (eventRef == null || this.specSyncSendRecvAlphabet.contains(event = ((EventExpression)eventRef).getEvent())) continue;
            invIter.remove();
            this.anyStateEventExclInvsRemoved = true;
        }
        List<Invariant> namedInvs = invs.stream().filter(inv -> inv.getName() != null).toList();
        List<Invariant> unnamedInvs = invs.stream().filter(inv -> inv.getName() == null).toList();
        for (Invariant inv3 : namedInvs) {
            this.createAutomaton(comp, Lists.list((Object)inv3));
        }
        if (!invs.isEmpty()) {
            List<List<Invariant>> supKindsInvs = this.partitionPerSupKind(unnamedInvs);
            for (List<Invariant> supKindInvs : supKindsInvs) {
                this.createAutomaton(comp, supKindInvs);
            }
        }
        this.removeInvs((EList<Invariant>)comp.getInvariants());
        if (comp instanceof Automaton) {
            Automaton aut = (Automaton)comp;
            for (Location loc : aut.getLocations()) {
                this.removeInvs((EList<Invariant>)loc.getInvariants());
            }
        }
        if (comp instanceof Group) {
            List children = Lists.copy((List)((Group)comp).getComponents());
            for (Component child : children) {
                this.elimStateEvtExclInvs((ComplexComponent)child);
            }
        }
    }

    private List<Invariant> filterInvs(List<Invariant> invs) {
        List filtered = Lists.list();
        for (Invariant inv : invs) {
            if (inv.getInvKind() == InvKind.STATE) continue;
            filtered.add(inv);
        }
        return filtered;
    }

    private void rewriteDisablesInvs(List<Invariant> invs) {
        for (Invariant inv : invs) {
            if (inv.getInvKind() != InvKind.EVENT_DISABLES) continue;
            inv.setInvKind(InvKind.EVENT_NEEDS);
            inv.setPredicate(CifValueUtils.makeInverse((Expression)inv.getPredicate()));
        }
    }

    private void modifyLocInvs(Automaton aut, List<Invariant> invs) {
        if (aut.getLocations().size() == 1) {
            return;
        }
        for (Invariant inv : invs) {
            Location loc = (Location)inv.eContainer();
            Expression locRef = CifGuardUtils.LocRefExprCreator.DEFAULT.create(loc);
            Expression invPred = inv.getPredicate();
            BinaryExpression pred = CifConstructors.newBinaryExpression();
            pred.setOperator(BinaryOperator.IMPLICATION);
            pred.setLeft(locRef);
            pred.setRight(invPred);
            pred.setType((CifType)CifConstructors.newBoolType());
            inv.setPredicate((Expression)pred);
        }
    }

    private List<List<Invariant>> partitionPerSupKind(List<Invariant> invs) {
        Map invMap = Maps.map();
        for (Invariant inv : invs) {
            List kindInvs = (List)invMap.get(inv.getSupKind());
            if (kindInvs == null) {
                kindInvs = Lists.list();
                invMap.put(inv.getSupKind(), kindInvs);
            }
            kindInvs.add(inv);
        }
        return new ArrayList<List<Invariant>>(invMap.values());
    }

    private void createAutomaton(ComplexComponent comp, List<Invariant> invs) {
        List evtInvs;
        Event event;
        Set usedNames;
        Object name;
        boolean invsHaveName = ((Invariant)Lists.first(invs)).getName() != null;
        SupKind supKind = ((Invariant)Lists.first(invs)).getSupKind();
        Assert.implies((boolean)invsHaveName, (invs.size() == 1 ? 1 : 0) != 0);
        Assert.implies((!invsHaveName ? 1 : 0) != 0, (boolean)invs.stream().allMatch(inv -> inv.getSupKind() == ((Invariant)Lists.first((List)invs)).getSupKind()));
        ComplexComponent parent = comp instanceof Group ? comp : CifScopeUtils.getScope((PositionObject)comp);
        Group group = (Group)parent;
        if (invsHaveName && comp instanceof Group) {
            name = ((Invariant)Lists.first(invs)).getName();
        } else if (invsHaveName) {
            name = CifTextUtils.getName((PositionObject)comp) + ((Invariant)Lists.first(invs)).getName();
        } else {
            Object object = name = comp instanceof Group ? "" : CifTextUtils.getName((PositionObject)comp);
            if (supKind != SupKind.NONE) {
                String txt = supKind.getName().toLowerCase(Locale.US);
                txt = StringUtils.capitalize((String)txt);
                name = (String)name + txt;
            }
            name = (String)name + "StateEvtExcls";
        }
        if (!(invsHaveName && comp instanceof Group || !(usedNames = CifScopeUtils.getSymbolNamesForScope((PositionObject)parent, null)).contains(name))) {
            name = CifScopeUtils.getUniqueName((String)name, (Set)usedNames, Collections.emptySet());
        }
        Automaton aut = CifConstructors.newAutomaton();
        group.getComponents().add((Object)aut);
        aut.setName((String)name);
        aut.setKind(supKind);
        if (invsHaveName) {
            aut.getAnnotations().addAll((Collection)((Invariant)Lists.first(invs)).getAnnotations());
        }
        Location loc = CifConstructors.newLocation();
        aut.getLocations().add((Object)loc);
        loc.getInitials().add((Object)CifValueUtils.makeTrue());
        loc.getMarkeds().add((Object)CifValueUtils.makeTrue());
        Map evtMap = Maps.map();
        for (Invariant invariant : invs) {
            event = ((EventExpression)invariant.getEvent()).getEvent();
            evtInvs = (List)evtMap.get(event);
            if (evtInvs == null) {
                evtInvs = Lists.list();
                evtMap.put(event, evtInvs);
            }
            evtInvs.add(invariant);
        }
        for (Map.Entry entry : evtMap.entrySet()) {
            event = (Event)entry.getKey();
            evtInvs = (List)entry.getValue();
            List guards = Lists.listc((int)evtInvs.size());
            for (Invariant inv3 : evtInvs) {
                Assert.check((inv3.getInvKind() == InvKind.EVENT_NEEDS ? 1 : 0) != 0);
                Expression guard = inv3.getPredicate();
                Assert.notNull((Object)guard);
                guards.add(guard);
            }
            Edge edge = CifConstructors.newEdge();
            loc.getEdges().add((Object)edge);
            edge.getGuards().addAll((Collection)guards);
            EventExpression evtRef = CifConstructors.newEventExpression();
            evtRef.setEvent(event);
            evtRef.setType((CifType)CifConstructors.newBoolType());
            EdgeEvent edgeEvent = CifConstructors.newEdgeEvent();
            edge.getEvents().add((Object)edgeEvent);
            edgeEvent.setEvent((Expression)evtRef);
        }
    }

    private void removeInvs(EList<Invariant> invs) {
        Iterator invsIter = invs.iterator();
        while (invsIter.hasNext()) {
            Invariant inv = (Invariant)invsIter.next();
            if (inv.getInvKind() == InvKind.STATE) continue;
            invsIter.remove();
        }
    }
}

