/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.relations;

import java.util.List;
import org.eclipse.escet.cif.cif2cif.ElimComponentDefInst;
import org.eclipse.escet.cif.cif2cif.ElimSelf;
import org.eclipse.escet.cif.cif2cif.RemoveAnnotations;
import org.eclipse.escet.cif.cif2cif.RemoveIoDecls;
import org.eclipse.escet.cif.cif2cif.SimplifyValuesOptimized;
import org.eclipse.escet.cif.common.CifTextUtils;
import org.eclipse.escet.cif.io.CifReader;
import org.eclipse.escet.cif.metamodel.cif.Invariant;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.relations.ciftodmm.CifRelations;
import org.eclipse.escet.cif.relations.ciftodmm.CifToDmm;
import org.eclipse.escet.cif.relations.options.PlantGroupsDmmOutputFileOption;
import org.eclipse.escet.cif.relations.options.PlantGroupsRequirementGroupsDmmOutputFileOption;
import org.eclipse.escet.cif.relations.options.RequirementGroupsDmmOutputFileOption;
import org.eclipse.escet.cif.relations.options.Rfc1480ComplianceOption;
import org.eclipse.escet.common.app.framework.Application;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.app.framework.io.AppStreams;
import org.eclipse.escet.common.app.framework.io.FileAppStream;
import org.eclipse.escet.common.app.framework.options.InputFileOption;
import org.eclipse.escet.common.app.framework.options.OptionCategory;
import org.eclipse.escet.common.app.framework.options.Options;
import org.eclipse.escet.common.app.framework.output.IOutputComponent;
import org.eclipse.escet.common.app.framework.output.OutputProvider;
import org.eclipse.escet.common.dsm.Dmm;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.PathPair;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class CifRelationsApp
extends Application<IOutputComponent> {
    public static void main(String[] args) {
        CifRelationsApp app = new CifRelationsApp();
        app.run(args, true);
    }

    public CifRelationsApp() {
    }

    public CifRelationsApp(AppStreams streams) {
        super(streams);
    }

    protected int runInternal() {
        CifReader cifReader = (CifReader)new CifReader().init();
        Specification inputSpec = (Specification)cifReader.read();
        String inputSpecPath = InputFileOption.getPath();
        String absInputSpecPath = Paths.resolve((String)inputSpecPath);
        if (this.isTerminationRequested()) {
            return 0;
        }
        new RemoveAnnotations().except(new String[]{"requirement:reachable"}).transform(inputSpec);
        new ElimComponentDefInst().transform(inputSpec);
        new ElimSelf().transform(inputSpec);
        new SimplifyValuesOptimized().transform(inputSpec);
        if (this.isTerminationRequested()) {
            return 0;
        }
        RemoveIoDecls removeIoDecls = new RemoveIoDecls();
        removeIoDecls.transform(inputSpec);
        removeIoDecls.warnAboutIgnoredSvgInputDecsIfRemoved(this.getAppEnvData().getProvider().getWarningOutputStream());
        if (this.isTerminationRequested()) {
            return 0;
        }
        CifToDmm.checkSpec(inputSpec, absInputSpecPath, () -> this.isTerminationRequested());
        if (this.isTerminationRequested()) {
            return 0;
        }
        CifRelations relations = CifToDmm.transformToDmms(inputSpec);
        if (this.isTerminationRequested()) {
            return 0;
        }
        boolean rfc4180Compliant = Rfc1480ComplianceOption.isEnabled();
        this.writeDmmFile(relations.plantGroups, PlantGroupsDmmOutputFileOption.getFilePath(inputSpecPath), rfc4180Compliant);
        if (this.isTerminationRequested()) {
            return 0;
        }
        this.writeDmmFile(relations.requirementGroups, RequirementGroupsDmmOutputFileOption.getFilePath(inputSpecPath), rfc4180Compliant);
        if (this.isTerminationRequested()) {
            return 0;
        }
        this.writeDmmFile(relations.relations, PlantGroupsRequirementGroupsDmmOutputFileOption.getFilePath(inputSpecPath), rfc4180Compliant);
        if (this.isTerminationRequested()) {
            return 0;
        }
        for (PositionObject posObj : relations.getUselessRequirements()) {
            if (posObj instanceof Automaton) {
                OutputProvider.warn((String)"Requirement automaton \"%s\" has no relation to any plant element and does not affect behavior.", (Object[])new Object[]{CifTextUtils.getAbsName((PositionObject)posObj, (boolean)false)});
                continue;
            }
            if (posObj instanceof Invariant) {
                Invariant inv = (Invariant)posObj;
                OutputProvider.warn((String)"Requirement invariant \"%s\" has no relation to any plant element and does not affect behavior.", (Object[])new Object[]{CifTextUtils.invToStr((Invariant)inv, (boolean)true)});
                continue;
            }
            throw new AssertionError((Object)("Unexpected kind of requirement found: \"" + String.valueOf(posObj) + "\"."));
        }
        return 0;
    }

    private void writeDmmFile(Dmm dmmData, String outputFilePath, boolean rfc4180Compliance) {
        if (outputFilePath == null) {
            return;
        }
        PathPair outputPair = new PathPair(outputFilePath, Paths.resolve((String)outputFilePath));
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileAppStream stream = new FileAppStream(outputPair);){
            stream.print(dmmData.toString(rfc4180Compliance));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected OptionCategory getAllOptions() {
        OptionCategory generalCat = CifRelationsApp.getGeneralOptionCategory();
        List appOpts = Lists.list();
        appOpts.add(Options.getInstance(InputFileOption.class));
        appOpts.add(Options.getInstance(PlantGroupsDmmOutputFileOption.class));
        appOpts.add(Options.getInstance(RequirementGroupsDmmOutputFileOption.class));
        appOpts.add(Options.getInstance(PlantGroupsRequirementGroupsDmmOutputFileOption.class));
        appOpts.add(Options.getInstance(Rfc1480ComplianceOption.class));
        List appSubCats = Lists.list();
        OptionCategory appCat = new OptionCategory("Collector", "Collector options.", appSubCats, appOpts);
        List cats = Lists.list((Object[])new OptionCategory[]{generalCat, appCat});
        return new OptionCategory("CIF Relations Collector Options", "All options for the CIF relations collector.", cats, Lists.list());
    }

    protected OutputProvider<IOutputComponent> createProvider() {
        return new OutputProvider();
    }

    public String getAppName() {
        return "CIF relations collector";
    }

    public String getAppDescription() {
        return "Collects relations between plants and requirements in a CIF specification.";
    }

    public String getAppToolDefLibName() {
        return "cif";
    }

    public String getAppToolDefToolName() {
        return "cifrelations";
    }
}

