/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.bdd.varorder.orderers;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.escet.cif.bdd.varorder.helper.VarOrdererData;
import org.eclipse.escet.cif.bdd.varorder.orderers.VarOrderer;
import org.eclipse.escet.common.java.Assert;

public class SequentialVarOrderer
extends VarOrderer {
    private final List<VarOrderer> orderers;

    public SequentialVarOrderer(List<VarOrderer> orderers) {
        this.orderers = orderers;
        Assert.check((orderers.size() >= 2 ? 1 : 0) != 0);
    }

    @Override
    public VarOrdererData order(VarOrdererData inputData, boolean dbgEnabled, int dbgLevel) {
        if (dbgEnabled) {
            inputData.helper.dbg(dbgLevel, "Applying %d orderers, sequentially:", this.orderers.size());
        }
        VarOrdererData resultData = inputData;
        int i = 0;
        while (i < this.orderers.size()) {
            if (i > 0 && dbgEnabled) {
                inputData.helper.dbg();
            }
            VarOrderer orderer = this.orderers.get(i);
            resultData = orderer.order(resultData, dbgEnabled, dbgLevel + 1);
            ++i;
        }
        return resultData;
    }

    public String toString() {
        return this.orderers.stream().map(Object::toString).collect(Collectors.joining(" -> "));
    }
}

