/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.multilevel.ciftodmm;

import java.util.BitSet;
import org.eclipse.escet.common.java.BitSets;

public class OwnedAndAccessedElements {
    public final BitSet groupElements;
    public final BitSet ownedElements;
    public final BitSet accessedElements;

    public OwnedAndAccessedElements(int elementIndex) {
        this(BitSets.makeBitset((int[])new int[]{elementIndex}), new BitSet(), new BitSet());
    }

    public OwnedAndAccessedElements(OwnedAndAccessedElements other) {
        this(BitSets.copy((BitSet)other.groupElements), BitSets.copy((BitSet)other.ownedElements), BitSets.copy((BitSet)other.accessedElements));
    }

    public OwnedAndAccessedElements(BitSet groupElements, BitSet ownedElements, BitSet accessedElements) {
        this.groupElements = groupElements;
        this.ownedElements = ownedElements;
        this.accessedElements = accessedElements;
    }

    public void setOwnedRelation(int elementIndex) {
        this.ownedElements.set(elementIndex);
    }

    public void setAccessedRelation(int elementIndex) {
        this.accessedElements.set(elementIndex);
    }

    public void merge(OwnedAndAccessedElements other) {
        this.groupElements.or(other.groupElements);
        this.ownedElements.or(other.ownedElements);
        this.accessedElements.or(other.accessedElements);
    }

    public BitSet getRelations() {
        BitSet relations = BitSets.copy((BitSet)this.ownedElements);
        relations.or(this.accessedElements);
        return relations;
    }
}

