/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.common.dsm.sequencing.graph;

import java.util.List;
import java.util.Map;
import org.eclipse.escet.common.dsm.sequencing.graph.Edge;
import org.eclipse.escet.common.dsm.sequencing.graph.GraphCreator;
import org.eclipse.escet.common.dsm.sequencing.graph.Vertex;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;

public class Graph
implements GraphCreator {
    public final List<Vertex> vertices = Lists.list();
    private Map<String, Integer> vertexNames;
    private Map<Integer, Map<Integer, Edge>> edgeMap;

    public GraphCreator getGraphCreator() {
        return this;
    }

    public String dumpGraph() {
        StringBuilder sb = new StringBuilder();
        sb.append("Graph with ");
        sb.append(this.vertices.size());
        sb.append(" vertices.\n");
        for (Vertex vertex : this.vertices) {
            sb.append("Vertex \"");
            sb.append(vertex.name);
            sb.append("\":");
            if (vertex.outputs.isEmpty()) {
                sb.append(" No outputs.\n");
                continue;
            }
            boolean first = true;
            for (Edge output : vertex.outputs) {
                if (first) {
                    first = false;
                } else {
                    sb.append(",");
                }
                if (output.teared) {
                    sb.append(" TEARED -> ");
                } else {
                    sb.append(" -> ");
                }
                sb.append("\"" + this.vertices.get((int)output.consumingVertex).name + "\"");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    @Override
    public void setupCreation() {
        this.vertexNames = Maps.map();
        this.edgeMap = Maps.map();
        this.vertices.clear();
    }

    @Override
    public void addEdge(String sourceVertexName, String targetVertexName) {
        Vertex sourceVertex = this.getVertexByName(sourceVertexName);
        Vertex targetVertex = this.getVertexByName(targetVertexName);
        Map targetMap = this.edgeMap.computeIfAbsent(sourceVertex.number, srcVertex -> Maps.map());
        Edge edge = targetMap.computeIfAbsent(targetVertex.number, destVertex -> new Edge(vertex.number, vertex2.number));
        sourceVertex.outputs.add(edge);
        targetVertex.inputs.add(edge);
    }

    @Override
    public void addVertex(String vertexName) {
        this.getVertexByName(vertexName);
    }

    private Vertex getVertexByName(String vertexName) {
        Integer vertNumber = this.vertexNames.get(vertexName);
        if (vertNumber != null) {
            return this.vertices.get(vertNumber);
        }
        int number = this.vertices.size();
        this.vertexNames.put(vertexName, number);
        Vertex vertex = new Vertex(number, vertexName, Lists.list(), Lists.list());
        this.vertices.add(vertex);
        return vertex;
    }

    @Override
    public void finishCreation() {
        this.vertexNames = null;
        this.edgeMap = null;
    }
}

