/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.checkers.checks;

import java.util.Set;
import org.eclipse.escet.cif.checkers.CifCheckNoCompDefInst;
import org.eclipse.escet.cif.checkers.CifCheckViolations;
import org.eclipse.escet.cif.common.CifEventUtils;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.SupKind;
import org.eclipse.escet.cif.metamodel.cif.automata.Automaton;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.position.metamodel.position.PositionObject;

public class EventOnlyReqSubsetPlantAlphabetCheck
extends CifCheckNoCompDefInst {
    private Set<Event> plantAlphabet = Sets.set();
    private Set<Event> requirementAlphabet = Sets.set();

    protected void preprocessAutomaton(Automaton aut, CifCheckViolations violations) {
        if (aut.getKind() == SupKind.PLANT) {
            this.plantAlphabet.addAll(CifEventUtils.getAlphabet((Automaton)aut));
        } else if (aut.getKind() == SupKind.REQUIREMENT) {
            this.requirementAlphabet.addAll(CifEventUtils.getAlphabet((Automaton)aut));
        }
    }

    protected void postprocessSpecification(Specification spec, CifCheckViolations violations) {
        Set violationEvents = Sets.difference(this.requirementAlphabet, this.plantAlphabet);
        for (Event evt : violationEvents) {
            violations.add((PositionObject)evt, "Event is in the requirement alphabet, but not in the plant alphabet", new Object[0]);
        }
    }
}

