/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.cdo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOObjectReference;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistry;
import org.eclipse.emf.cdo.common.model.CDOPackageRegistryPopulator;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDONet4jSessionConfiguration;
import org.eclipse.emf.cdo.net4j.CDONet4jUtil;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.InvalidURIException;
import org.eclipse.emf.cdo.view.CDOQuery;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.emf.AbstractReflectiveEmfModel;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IRelativePathResolver;
import org.eclipse.net4j.Net4jUtil;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;

public class CDOModel
extends AbstractReflectiveEmfModel {
    public static final String PROPERTY_CDO_URL = "cdo.url";
    public static final String PROPERTY_CDO_NAME = "cdo.repo";
    public static final String PROPERTY_CDO_PATH = "cdo.path";
    public static final String PROPERTY_CDO_BRANCH = "cdo.branch";
    public static final String PROPERTY_CDO_COLLECTION_INITIAL = "cdo.collection.initial";
    public static final String PROPERTY_CDO_COLLECTION_RCHUNK = "cdo.collection.rchunk";
    public static final String PROPERTY_CDO_REVPREFETCH = "cdo.revprefetch";
    public static final String PROPERTY_CDO_FEATANALYZER = "cdo.featureAnalyzer";
    public static final String PROPERTY_CDO_CREATE_MISSING = "cdo.createMissingResource";
    private String repositoryName;
    private String serverURL;
    private String modelPath;
    private String branchName;
    private int cdoCollectionInitial = 0;
    private int cdoCollectionRChunk = 300;
    private int cdoRevPrefetching = 100;
    private CDOTransaction cdoTransaction;
    private boolean useFeatureAnalyzer = false;
    private boolean createMissingResource = false;

    public void load(StringProperties properties, IRelativePathResolver resolver) throws EolModelLoadingException {
        super.load(properties, resolver);
        this.serverURL = (String)properties.get((Object)PROPERTY_CDO_URL);
        this.repositoryName = (String)properties.get((Object)PROPERTY_CDO_NAME);
        this.modelPath = (String)properties.get((Object)PROPERTY_CDO_PATH);
        this.branchName = properties.getProperty(PROPERTY_CDO_BRANCH);
        if (properties.hasProperty(PROPERTY_CDO_COLLECTION_INITIAL)) {
            this.cdoCollectionInitial = Integer.valueOf(properties.get((Object)PROPERTY_CDO_COLLECTION_INITIAL).toString());
        }
        if (properties.hasProperty(PROPERTY_CDO_COLLECTION_RCHUNK)) {
            this.cdoCollectionRChunk = Integer.valueOf(properties.get((Object)PROPERTY_CDO_COLLECTION_RCHUNK).toString());
        }
        if (properties.hasProperty(PROPERTY_CDO_REVPREFETCH)) {
            this.cdoRevPrefetching = Integer.valueOf(properties.get((Object)PROPERTY_CDO_REVPREFETCH).toString());
        }
        this.useFeatureAnalyzer = properties.hasProperty(PROPERTY_CDO_FEATANALYZER);
        this.createMissingResource = properties.hasProperty(PROPERTY_CDO_CREATE_MISSING);
        this.load();
    }

    protected void loadModel() throws EolModelLoadingException {
        try {
            IConnector connector = Net4jUtil.getConnector((IManagedContainer)IPluginContainer.INSTANCE, (String)this.serverURL);
            CDONet4jSessionConfiguration sessionConfig = CDONet4jUtil.createNet4jSessionConfiguration();
            sessionConfig.setConnector(connector);
            sessionConfig.setRepositoryName(this.repositoryName);
            if (this.useFeatureAnalyzer) {
                sessionConfig.setFetchRuleManager(CDOUtil.createThreadLocalFetchRuleManager());
            }
            CDONet4jSession cdoSession = sessionConfig.openNet4jSession();
            cdoSession.options().setCollectionLoadingPolicy(CDOUtil.createCollectionLoadingPolicy((int)this.cdoCollectionInitial, (int)this.cdoCollectionRChunk));
            CDOBranch branch = cdoSession.getBranchManager().getMainBranch();
            if (this.branchName != null && !"".equals(this.branchName.trim()) && (branch = cdoSession.getBranchManager().getBranch(this.branchName)) == null) {
                StringBuilder sb = new StringBuilder(String.format("Branch '%s' does not exist. Available branches:", this.branchName));
                this.appendBranches(cdoSession.getBranchManager().getMainBranch(), sb);
                throw new NoSuchElementException(sb.toString());
            }
            this.cdoTransaction = cdoSession.openTransaction(branch);
            this.cdoTransaction.options().setRevisionPrefetchingPolicy(CDOUtil.createRevisionPrefetchingPolicy((int)this.cdoRevPrefetching));
            if (this.useFeatureAnalyzer) {
                this.cdoTransaction.options().setFeatureAnalyzer(CDOUtil.createModelBasedFeatureAnalyzer());
            }
            try {
                this.modelImpl = this.cdoTransaction.getResource(this.modelPath);
            }
            catch (InvalidURIException ex) {
                if (this.createMissingResource) {
                    this.modelImpl = this.cdoTransaction.createResource(this.modelPath);
                }
                throw new NoSuchElementException(String.format("No resource exists with path %s, and automated resource creation was disabled", this.modelPath));
            }
            this.registry = this.cdoTransaction.getSession().getPackageRegistry();
        }
        catch (Exception ex) {
            throw new EolModelLoadingException(ex, (IModel)this);
        }
    }

    private void appendBranches(CDOBranch mainBranch, StringBuilder sb) {
        sb.append(String.format("\n- %s", mainBranch.getPathName()));
        CDOBranch[] cDOBranchArray = mainBranch.getBranches();
        int n = cDOBranchArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOBranch branch = cDOBranchArray[n2];
            this.appendBranches(branch, sb);
            ++n2;
        }
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public void setModelPath(String modelPath) {
        this.modelPath = modelPath;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public void setBranchName(String branchName) {
        this.branchName = branchName;
    }

    public boolean isCreateMissingResource() {
        return this.createMissingResource;
    }

    public void setCreateMissingResource(boolean createMissingResource) {
        this.createMissingResource = createMissingResource;
    }

    public void disposeModel() {
        super.disposeModel();
        if (this.cdoTransaction != null) {
            this.cdoTransaction.close();
            this.cdoTransaction.getSession().close();
            this.cdoTransaction = null;
        }
    }

    protected EClass classForName(String name, EPackage.Registry registry) {
        EClass localEClass;
        boolean absolute = name.indexOf("::") > -1;
        for (Object pkg : registry.values()) {
            EClass eClass;
            if (pkg instanceof EPackage.Descriptor) {
                pkg = ((EPackage.Descriptor)pkg).getEPackage();
            }
            if (!(pkg instanceof EPackage) || (eClass = this.classForName(name, absolute, (EPackage)pkg)) == null) continue;
            return eClass;
        }
        if (registry instanceof CDOPackageRegistry && registry != EPackage.Registry.INSTANCE && (localEClass = super.classForName(name, EPackage.Registry.INSTANCE)) != null) {
            String nsURI = localEClass.getEPackage().getNsURI();
            EPackageRegistryImpl temporaryRegistry = new EPackageRegistryImpl();
            temporaryRegistry.put((Object)nsURI, (Object)localEClass.getEPackage());
            CDOPackageRegistryPopulator.populate((EPackage.Registry)temporaryRegistry, (CDOPackageRegistry)((CDOPackageRegistry)registry));
            EPackage populatedPackage = registry.getEPackage(nsURI);
            return this.classForName(name, absolute, populatedPackage);
        }
        return null;
    }

    protected boolean deleteElementInModel(Object instance) throws EolRuntimeException {
        CDOObject eob = (CDOObject)instance;
        HashSet<CDOObject> toRemove = new HashSet<CDOObject>();
        toRemove.add(eob);
        TreeIterator it = eob.eAllContents();
        while (it.hasNext()) {
            toRemove.add((CDOObject)it.next());
        }
        List refs = this.cdoTransaction.queryXRefs(toRemove, new EReference[0]);
        for (CDOObjectReference ref : refs) {
            CDOObject src = (CDOObject)ref.getSourceObject();
            CDOObject target = (CDOObject)ref.getTargetObject();
            EReference feature = ref.getSourceReference();
            if (feature.isDerived() || !feature.isChangeable()) continue;
            EcoreUtil.remove((EObject)src, (EStructuralFeature)feature, (Object)target);
        }
        for (CDOObject cdoObject : toRemove) {
            EcoreUtil.remove((EObject)cdoObject);
        }
        return true;
    }

    protected Collection<EObject> getAllOfTypeFromModel(String type) throws EolModelElementTypeNotFoundException {
        EClass eClass = this.classForName(type);
        CDOView cdoView = this.getCDOResource().cdoView();
        CDOQuery query = cdoView.createQuery("instances", null);
        query.setParameter("type", (Object)eClass);
        query.setParameter("exact", (Object)true);
        List allInstances = query.getResult();
        return this.filterByResource(allInstances);
    }

    protected Collection<EObject> getAllOfKindFromModel(String kind) throws EolModelElementTypeNotFoundException {
        EClass eClass = this.classForName(kind);
        List allInstances = this.getCDOResource().cdoView().queryInstances(eClass);
        return this.filterByResource(allInstances);
    }

    protected Collection<EObject> filterByResource(List<EObject> allInstances) {
        ArrayList<EObject> filtered = new ArrayList<EObject>();
        for (EObject eob : allInstances) {
            if (eob.eResource() != this.modelImpl) continue;
            filtered.add(eob);
        }
        return filtered;
    }

    protected Collection<EObject> allContentsFromModel() {
        if (this.getCDOResource().isExisting()) {
            this.getCDOResource().cdoPrefetch(-1);
        }
        return super.allContentsFromModel();
    }

    protected CDOResource getCDOResource() {
        return (CDOResource)this.modelImpl;
    }

    public boolean store() {
        if (this.modelImpl == null) {
            return false;
        }
        try {
            this.modelImpl.save(null);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

