/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecore.delegates.validation;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epsilon.ecore.delegates.DelegateContext;
import org.eclipse.epsilon.ecore.delegates.DelegateLabelProvider;
import org.eclipse.epsilon.ecore.delegates.EvlDelegateContext;
import org.eclipse.epsilon.ecore.delegates.EvlDelegateContextFactory;
import org.eclipse.epsilon.ecore.delegates.ExeedLabelProvider;
import org.eclipse.epsilon.ecore.delegates.notify.Adapters;
import org.eclipse.epsilon.ecore.delegates.notify.EpsilonDelegatesAdapter;
import org.eclipse.epsilon.ecore.delegates.notify.EvlAdapters;
import org.eclipse.epsilon.ecore.delegates.validation.EpsilonValidationDelegate;
import org.eclipse.epsilon.ecore.delegates.validation.EvlValidationDelegate;
import org.eclipse.epsilon.ecore.delegates.validation.ValidationDelegates;
import org.eclipse.epsilon.ecore.delegates.validation.ValidationUri;

public class DelegateFactory
implements EpsilonValidationDelegate.Factory,
EValidator.ValidationDelegate {
    private final ValidationUri delegateUri;
    private final Adapters adapters;
    private final DelegateLabelProvider labelProvider;
    private final EpsilonValidationDelegate.Factory.Registry delegateRegistry;
    private final ValidationDelegates delegates;

    public DelegateFactory() {
        this(new ValidationUri(), new DelegateContext.ContextFactory.Registry.Fast(), new EpsilonValidationDelegate.Factory.Registry.Smart());
    }

    public DelegateFactory(ValidationUri delegateUri, DelegateContext.ContextFactory.Registry domainRegistry, EpsilonValidationDelegate.Factory.Registry delegateRegistry) {
        this.delegateUri = delegateUri;
        this.delegateRegistry = delegateRegistry;
        this.adapters = new EvlAdapters(this.delegateUri, new EvlDelegateContextFactory(), domainRegistry, delegateRegistry, this);
        this.labelProvider = new ExeedLabelProvider();
        this.delegates = new ValidationDelegates(this.delegateUri, this.delegateRegistry, this.adapters);
    }

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> context, EOperation invariant, String expression) {
        if (this.delegateUri.isUsedBy((EModelElement)eClass)) {
            EpsilonValidationDelegate validationDelegate = this.validationDelegate((EClassifier)eClass);
            return validationDelegate.validate(eClass, eObject, context, invariant, expression);
        }
        return true;
    }

    public boolean validate(EClass eClass, EObject eObject, Map<Object, Object> context, String constraint, String expression) {
        if (this.delegateUri.isUsedBy((EModelElement)eClass)) {
            EpsilonValidationDelegate validationDelegate = this.validationDelegate((EClassifier)eClass);
            return validationDelegate.validate(eClass, eObject, context, constraint, expression);
        }
        return true;
    }

    public boolean validate(EDataType eDataType, Object value, Map<Object, Object> context, String constraint, String expression) {
        if (this.delegateUri.isUsedBy((EModelElement)eDataType)) {
            EpsilonValidationDelegate validationDelegate = this.validationDelegate((EClassifier)eDataType);
            return validationDelegate.validate(eDataType, value, context, constraint, expression);
        }
        return true;
    }

    @Override
    public EpsilonValidationDelegate createValidationDelegate(EClassifier classifier) {
        return new EvlValidationDelegate(this.delegateContext(classifier.getEPackage()), this.labelProvider);
    }

    private EvlDelegateContext delegateContext(EPackage ePackage) {
        return (EvlDelegateContext)this.delegateUri.context(this.adapters.getAdapter(ePackage));
    }

    private EpsilonValidationDelegate validationDelegate(EClassifier eClassifier) {
        return this.findAdapter(eClassifier).validationDelegate();
    }

    private EpsilonDelegatesAdapter findAdapter(EClassifier eClassifier) {
        EpsilonDelegatesAdapter adapter = (EpsilonDelegatesAdapter)EcoreUtil.getAdapter((List)eClassifier.eAdapters(), EpsilonDelegatesAdapter.class);
        if (adapter == null) {
            adapter = new EpsilonDelegatesAdapter();
            eClassifier.eAdapters().add((Object)adapter);
        }
        if (!adapter.hasValidationDelegate()) {
            adapter.useValidationDelegate(this.delegates.create(eClassifier));
        }
        return adapter;
    }
}

