/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.connectionmanager.xmlrpc;

import java.util.List;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.AbstractConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ConnectionManager;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.xmlrpc.XmlRpcClientManager;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreClientUtil;
import org.eclipse.emf.emfstore.internal.common.model.EMFStoreProperty;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.server.exceptions.InvalidVersionSpecException;
import org.eclipse.emf.emfstore.internal.server.filetransfer.FileChunk;
import org.eclipse.emf.emfstore.internal.server.filetransfer.FileTransferInformation;
import org.eclipse.emf.emfstore.internal.server.model.AuthenticationInformation;
import org.eclipse.emf.emfstore.internal.server.model.ClientVersionInfo;
import org.eclipse.emf.emfstore.internal.server.model.ModelFactory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectHistory;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.ProjectInfo;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACOrgUnitId;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.ACUser;
import org.eclipse.emf.emfstore.internal.server.model.accesscontrol.OrgUnitProperty;
import org.eclipse.emf.emfstore.internal.server.model.versioning.AbstractChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.BranchVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackageEnvelope;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryInfo;
import org.eclipse.emf.emfstore.internal.server.model.versioning.HistoryQuery;
import org.eclipse.emf.emfstore.internal.server.model.versioning.LogMessage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.TagVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlRpcConnectionManager
extends AbstractConnectionManager<XmlRpcClientManager>
implements ConnectionManager {
    private static final String LOGGING_PREFIX = "XMLRPC-Client";

    @Override
    public AuthenticationInformation logIn(String username, String password, ServerInfo serverInfo, ClientVersionInfo clientVersionInfo) throws ESException {
        XmlRpcClientManager clientManager = new XmlRpcClientManager("EmfStore");
        clientManager.initConnection(serverInfo);
        AuthenticationInformation authenticationInformation = clientManager.callWithResult("logIn", AuthenticationInformation.class, username, password, clientVersionInfo);
        this.addConnectionProxy(authenticationInformation.getSessionId(), clientManager);
        return authenticationInformation;
    }

    @Override
    public void logout(SessionId sessionId) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("logout", sessionId);
        this.removeConnectionProxy(sessionId);
    }

    public void addTag(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("addTag", sessionId, projectId, versionSpec, tag);
    }

    public ProjectInfo createEmptyProject(SessionId sessionId, String name, String description, LogMessage logMessage) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("createEmptyProject", ProjectInfo.class, sessionId, name, description, logMessage);
    }

    public ProjectInfo createProject(SessionId sessionId, String name, String description, LogMessage logMessage, Project project) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("createProject", ProjectInfo.class, sessionId, name, description, logMessage, project);
    }

    public PrimaryVersionSpec createVersion(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec baseVersionSpec, AbstractChangePackage changePackage, BranchVersionSpec targetBranch, PrimaryVersionSpec sourceVersion, LogMessage logMessage) throws ESException, InvalidVersionSpecException {
        EMFStoreClientUtil.logProjectDetails(LOGGING_PREFIX, "Server call to create version", projectId, targetBranch);
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("createVersion", PrimaryVersionSpec.class, sessionId, projectId, baseVersionSpec, changePackage, targetBranch, sourceVersion, logMessage);
    }

    public void deleteProject(SessionId sessionId, ProjectId projectId, boolean deleteFiles) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("deleteProject", sessionId, projectId, deleteFiles);
    }

    public FileChunk downloadFileChunk(SessionId sessionId, ProjectId projectId, FileTransferInformation fileInformation) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("downloadFileChunk", FileChunk.class, sessionId, projectId, fileInformation);
    }

    public ProjectHistory exportProjectHistoryFromServer(SessionId sessionId, ProjectId projectId) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("exportProjectHistoryFromServer", ProjectHistory.class, sessionId, projectId);
    }

    public List<AbstractChangePackage> getChanges(SessionId sessionId, ProjectId projectId, VersionSpec source, VersionSpec target) throws InvalidVersionSpecException, ESException {
        EMFStoreClientUtil.logProjectDetails(LOGGING_PREFIX, "Server call to get changes", projectId, source == null ? null : source.getBranch());
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult("getChanges", AbstractChangePackage.class, sessionId, projectId, source, target);
    }

    public List<BranchInfo> getBranches(SessionId sessionId, ProjectId projectId) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult("getBranches", BranchInfo.class, sessionId, projectId);
    }

    public List<HistoryInfo> getHistoryInfo(SessionId sessionId, ProjectId projectId, HistoryQuery<?> historyQuery) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult("getHistoryInfo", HistoryInfo.class, sessionId, projectId, historyQuery);
    }

    public Project getProject(SessionId sessionId, ProjectId projectId, VersionSpec versionSpec) throws InvalidVersionSpecException, ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("getProject", Project.class, sessionId, projectId, versionSpec);
    }

    public List<ProjectInfo> getProjectList(SessionId sessionId) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult("getProjectList", ProjectInfo.class, sessionId);
    }

    public ProjectId importProjectHistoryToServer(SessionId sessionId, ProjectHistory projectHistory) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("importProjectHistoryToServer", ProjectId.class, sessionId, projectHistory);
    }

    public void removeTag(SessionId sessionId, ProjectId projectId, PrimaryVersionSpec versionSpec, TagVersionSpec tag) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("removeTag", sessionId, projectId, versionSpec, tag);
    }

    public ACUser resolveUser(SessionId sessionId, ACOrgUnitId id) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("resolveUser", ACUser.class, sessionId, id);
    }

    public PrimaryVersionSpec resolveVersionSpec(SessionId sessionId, ProjectId projectId, VersionSpec versionSpec) throws InvalidVersionSpecException, ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("resolveVersionSpec", PrimaryVersionSpec.class, sessionId, projectId, versionSpec);
    }

    public void transmitProperty(SessionId sessionId, OrgUnitProperty changedProperty, ACUser tmpUser, ProjectId projectId) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("transmitProperty", sessionId, changedProperty, tmpUser, projectId);
    }

    public FileTransferInformation uploadFileChunk(SessionId sessionId, ProjectId projectId, FileChunk fileChunk) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("uploadFileChunk", FileTransferInformation.class, sessionId, projectId, fileChunk);
    }

    public List<EMFStoreProperty> setEMFProperties(SessionId sessionId, List<EMFStoreProperty> properties, ProjectId projectId) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult("setEMFProperties", EMFStoreProperty.class, sessionId, properties, projectId);
    }

    public List<EMFStoreProperty> getEMFProperties(SessionId sessionId, ProjectId projectId) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithListResult("getEMFProperties", EMFStoreProperty.class, sessionId, projectId);
    }

    @Override
    public boolean isLoggedIn(SessionId id) {
        return this.hasConnectionProxy(id);
    }

    public void registerEPackage(SessionId sessionId, EPackage pkg) throws ESException {
        ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).call("registerEPackage", sessionId, pkg);
    }

    @Override
    public String getVersion(ServerInfo serverInfo) throws ESException {
        SessionId sessionId = this.createFakeSessionId(serverInfo);
        if (!this.getConnectionProxyMap().containsKey(sessionId)) {
            XmlRpcClientManager clientManager = new XmlRpcClientManager("EmfStore");
            clientManager.initConnection(serverInfo);
            this.addConnectionProxy(sessionId, clientManager);
        }
        return this.getVersion(sessionId);
    }

    private SessionId createFakeSessionId(ServerInfo serverInfo) {
        SessionId sessionId = ModelFactory.eINSTANCE.createSessionId();
        sessionId.setId(String.valueOf(serverInfo.getUrl().toString()) + "/defaultSession");
        return sessionId;
    }

    public String getVersion(SessionId sessionId) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("getVersion", String.class, sessionId);
    }

    public String uploadChangePackageFragment(SessionId sessionId, ProjectId projectId, ChangePackageEnvelope envelope) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("uploadChangePackageFragment", String.class, sessionId, projectId, envelope);
    }

    public ChangePackageEnvelope downloadChangePackageFragment(SessionId sessionId, ProjectId projectId, String proxyId, int fragmentIndex) throws ESException {
        return ((XmlRpcClientManager)this.getConnectionProxy(sessionId)).callWithResult("downloadChangePackageFragment", ChangePackageEnvelope.class, sessionId, projectId, proxyId, fragmentIndex);
    }
}

