/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.impl;

import java.util.Collections;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.client.model.impl.ProjectSpaceBase;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommand;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.common.model.IdEObjectCollection;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplyOperationsRunnable
implements Runnable {
    private final ProjectSpaceBase projectSpace;
    private final Iterable<AbstractOperation> operations;
    private final boolean addOperations;

    public ApplyOperationsRunnable(ProjectSpaceBase projectSpaceBase, Iterable<AbstractOperation> operations, boolean addOperations) {
        this.projectSpace = projectSpaceBase;
        this.operations = operations;
        this.addOperations = addOperations;
    }

    @Override
    public void run() {
        new EMFStoreCommand(){

            protected void doRun() {
                ApplyOperationsRunnable.this.projectSpace.stopChangeRecording();
                try {
                    for (AbstractOperation operation : ApplyOperationsRunnable.this.operations) {
                        try {
                            operation.apply((IdEObjectCollection)ApplyOperationsRunnable.this.projectSpace.getProject());
                        }
                        catch (RuntimeException e) {
                            WorkspaceUtil.handleException(e);
                        }
                        if (!ApplyOperationsRunnable.this.addOperations) continue;
                        ApplyOperationsRunnable.this.projectSpace.addOperations(Collections.singletonList((AbstractOperation)ModelUtil.clone((EObject)operation)));
                    }
                }
                finally {
                    if (ApplyOperationsRunnable.this.projectSpace.getOperationManager() != null) {
                        ApplyOperationsRunnable.this.projectSpace.startChangeRecording();
                    }
                }
            }
        }.run(false);
    }
}

