/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.startup;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.eclipse.emf.emfstore.internal.common.model.util.FileUtil;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.ServerConfiguration;
import org.eclipse.emf.emfstore.internal.server.startup.Messages;
import org.eclipse.emf.emfstore.internal.server.startup.ServerSpaceRule;
import org.eclipse.emf.emfstore.internal.server.startup.UpdateXMIAttributeRule;
import org.eclipse.emf.emfstore.internal.server.startup.VersionMultiRule;
import org.eclipse.emf.emfstore.internal.server.startup.VersionRule;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerHrefMigrator {
    private static final String STORAGE_USS = "storage.uss";
    private static final String PROJECT_PREFIX = "project-";
    private File backup;
    private List<String> corruptProjectIds = new ArrayList<String>();

    public boolean migrate() {
        String serverHome = ServerConfiguration.getServerHome();
        if (this.isMigrationNeeded(String.valueOf(serverHome) + STORAGE_USS)) {
            if (this.backup != null) {
                return false;
            }
            try {
                this.backup = this.createBackup(ServerConfiguration.getServerHome(), String.valueOf(ServerConfiguration.getServerHome()) + "../backup" + System.currentTimeMillis());
            }
            catch (IOException ex) {
                ModelUtil.logException((String)Messages.ServerHrefMigrator_ErrorDuringBackup, (Throwable)ex);
                return false;
            }
            try {
                this.corruptProjectIds = this.doMigrate(serverHome);
                return true;
            }
            catch (InvocationTargetException ex) {
                ModelUtil.logException((String)Messages.ServerHrefMigrator_ErrorDuringMigration, (Throwable)ex);
                return false;
            }
        }
        return true;
    }

    private boolean isMigrationNeeded(String pathToServerSpace) {
        String toMatch;
        block7: {
            toMatch = this.getProjectAttribute(pathToServerSpace);
            if (toMatch != null) break block7;
            return false;
        }
        try {
            return toMatch.contains("projectHistory.uph");
        }
        catch (ParserConfigurationException ex) {
            ModelUtil.logException((String)Messages.ServerHrefMigrator_SkipMigration, (Throwable)ex);
        }
        catch (SAXException ex) {
            ModelUtil.logException((String)Messages.ServerHrefMigrator_SkipMigration, (Throwable)ex);
        }
        catch (IOException ex) {
            ModelUtil.logException((String)Messages.ServerHrefMigrator_SkipMigration, (Throwable)ex);
        }
        try {
            this.backup = this.createBackup(ServerConfiguration.getServerHome(), String.valueOf(ServerConfiguration.getServerHome()) + "../backup" + System.currentTimeMillis());
        }
        catch (IOException ex) {
            this.backup = new File("");
            ModelUtil.logException((String)Messages.ServerHrefMigrator_BackupFailed, (Throwable)ex);
        }
        return true;
    }

    protected File createBackup(String from, String to) throws IOException {
        File sourceFile = new File(from);
        File backupFile = new File(to);
        FileUtil.copyDirectory((File)sourceFile, (File)backupFile);
        return backupFile;
    }

    private List<String> doMigrate(String serverHome) throws InvocationTargetException {
        this.migrateNonContainment(String.valueOf(serverHome) + STORAGE_USS, "projects", new ServerSpaceRule());
        File serverHomeFile = new File(serverHome);
        File[] projectFiles = serverHomeFile.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.startsWith(ServerHrefMigrator.PROJECT_PREFIX);
            }
        });
        ArrayList<String> corruptProjectIds = new ArrayList<String>();
        File[] fileArray = projectFiles;
        int n = projectFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            try {
                String projectHistoryPath = String.valueOf(f.getAbsolutePath()) + "/projectHistory.uph";
                if (!new File(projectHistoryPath).exists()) {
                    ModelUtil.logWarning((String)MessageFormat.format(Messages.ServerHrefMigrator_HistoryFileDoeNotExists, projectHistoryPath));
                    this.removeReferencesToCorruptProject(String.valueOf(serverHome) + STORAGE_USS, f.getName().substring(PROJECT_PREFIX.length()));
                } else {
                    File[] versions;
                    this.migrateContainmentHRefs(projectHistoryPath, "versions", new VersionRule());
                    File[] fileArray2 = versions = f.listFiles(new FilenameFilter(){

                        public boolean accept(File dir, String name) {
                            return name.startsWith("version-");
                        }
                    });
                    int n3 = versions.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File version = fileArray2[n4];
                        String versionPath = version.getAbsolutePath();
                        this.migrateNonContainment(versionPath, "nextVersion", new VersionMultiRule());
                        this.migrateNonContainment(versionPath, "previousVersion", new VersionMultiRule());
                        this.migrateNonContainment(versionPath, "ancestorVersion", new VersionMultiRule());
                        this.migrateNonContainment(versionPath, "branchedVersions", new VersionMultiRule());
                        this.migrateNonContainment(versionPath, "mergedToVersion", new VersionMultiRule());
                        this.migrateNonContainment(versionPath, "mergedFromVersion", new VersionMultiRule());
                        ++n4;
                    }
                }
            }
            catch (InvocationTargetException exception) {
                ModelUtil.logException((String)MessageFormat.format(Messages.ServerHrefMigrator_MigrationFailed, f.getAbsolutePath()), (Throwable)exception);
                corruptProjectIds.add(f.getName().substring(PROJECT_PREFIX.length()));
            }
            ++n2;
        }
        return corruptProjectIds;
    }

    private String getProjectAttribute(String pathToFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.parse(pathToFile);
        Node serverSpace = doc.getFirstChild();
        NamedNodeMap attr = serverSpace.getAttributes();
        Node nodeAttr = attr.getNamedItem("projects");
        if (nodeAttr == null) {
            return null;
        }
        String projectsOld = nodeAttr.getTextContent();
        String[] projects = projectsOld.split(" ");
        if (projects.length < 1) {
            return null;
        }
        return projects[0];
    }

    protected void migrateContainmentHRefs(String pathToFile, String tagName, UpdateXMIAttributeRule rule) throws InvocationTargetException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(pathToFile);
            NodeList tagElements = doc.getElementsByTagName(tagName);
            int i = 0;
            while (i < tagElements.getLength()) {
                Node pS = tagElements.item(i);
                NamedNodeMap attr = pS.getAttributes();
                Node nodeAttr = attr.getNamedItem("href");
                String hrefOld = nodeAttr.getTextContent();
                String hrefNew = rule.getNewAttribute(hrefOld);
                nodeAttr.setTextContent(hrefNew);
                ++i;
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(pathToFile));
            transformer.transform(source, result);
        }
        catch (DOMException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (TransformerConfigurationException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (SAXException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (IOException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (TransformerFactoryConfigurationError ex) {
            throw new InvocationTargetException(ex);
        }
        catch (TransformerException ex) {
            throw new InvocationTargetException(ex);
        }
    }

    private void removeReferencesToCorruptProject(String serverHome, String projectId) throws InvocationTargetException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(serverHome);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("//projects[@id=\"" + projectId + "\"]");
            NodeList nl = (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
            int i = 0;
            while (i < nl.getLength()) {
                nl.item(i).getParentNode().removeChild(nl.item(i));
                ++i;
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(serverHome));
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (SAXException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (IOException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (XPathExpressionException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (TransformerConfigurationException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (TransformerException ex) {
            throw new InvocationTargetException(ex);
        }
    }

    protected void migrateNonContainment(String pathToFile, String tagName, UpdateXMIAttributeRule rule) throws InvocationTargetException {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.parse(pathToFile);
            Node serverSpace = doc.getFirstChild();
            NamedNodeMap attr = serverSpace.getAttributes();
            Node nodeAttr = attr.getNamedItem(tagName);
            if (nodeAttr == null) {
                return;
            }
            String attributeOld = nodeAttr.getTextContent();
            String attributeNew = rule.getNewAttribute(attributeOld);
            nodeAttr.setTextContent(attributeNew);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(new File(pathToFile));
            transformer.transform(source, result);
        }
        catch (DOMException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (TransformerConfigurationException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (ParserConfigurationException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (SAXException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (IOException ex) {
            throw new InvocationTargetException(ex);
        }
        catch (TransformerFactoryConfigurationError ex) {
            throw new InvocationTargetException(ex);
        }
        catch (TransformerException ex) {
            throw new InvocationTargetException(ex);
        }
    }

    public List<String> getCorruptProjectIds() {
        return this.corruptProjectIds;
    }
}

