/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.fuzzy.emf.test;

import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.test.common.cases.ESTestWithLoggedInUser;
import org.eclipse.emf.emfstore.client.test.common.util.ProjectUtil;
import org.eclipse.emf.emfstore.client.util.ESVoidCallable;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.fuzzy.Annotations;
import org.eclipse.emf.emfstore.fuzzy.FuzzyRunner;
import org.eclipse.emf.emfstore.fuzzy.emf.EMFDataProvider;
import org.eclipse.emf.emfstore.fuzzy.emf.MutateUtil;
import org.eclipse.emf.emfstore.fuzzy.emf.test.FuzzyProjectTest;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.modelmutator.api.ModelMutatorConfiguration;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=FuzzyRunner.class)
@Annotations.DataProvider(value=EMFDataProvider.class)
public class ServerTest
extends ESTestWithLoggedInUser {
    @Annotations.Data
    private Project project;
    @Annotations.Util
    private MutateUtil util;

    @Before
    public void setupProjectSpace() {
        super.before();
        this.project = this.getProject();
    }

    @Test
    public void shareCheckoutCommitUpdate() throws ESException {
        ProjectUtil.share((ESUsersession)this.getUsersession(), (ESLocalProject)this.getLocalProject());
        this.getProjectSpace().getBaseVersion();
        final ESLocalProjectImpl checkout = (ESLocalProjectImpl)ProjectUtil.checkout((ESLocalProject)this.getLocalProject());
        FuzzyProjectTest.compareIgnoreOrder(this.getProject(), ((ProjectSpace)checkout.toInternalAPI()).getProject(), this.util);
        final ModelMutatorConfiguration mmc = FuzzyProjectTest.getModelMutatorConfiguration(this.getProject(), this.util);
        RunESCommand.run((Callable)new ESVoidCallable(){

            public void run() {
                ServerTest.this.util.mutate(mmc);
            }
        });
        ProjectUtil.commit((ESLocalProject)this.getLocalProject());
        RunESCommand.run((Callable)new ESVoidCallable(){

            public void run() {
                try {
                    checkout.update((IProgressMonitor)new NullProgressMonitor());
                }
                catch (ESException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        FuzzyProjectTest.compareIgnoreOrder(this.getProject(), ((ProjectSpace)checkout.toInternalAPI()).getProject(), this.util);
    }
}

