/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.ESPagedUpdateConfig;
import org.eclipse.emf.emfstore.client.callbacks.ESUpdateCallback;
import org.eclipse.emf.emfstore.common.model.ESModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.ui.common.RunInUI;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.UpdateDialog;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.merge.MergeProjectHandler;
import org.eclipse.emf.emfstore.internal.common.APIUtil;
import org.eclipse.emf.emfstore.internal.common.ExtensionRegistry;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementIdToEObjectMapping;
import org.eclipse.emf.emfstore.internal.common.model.impl.ESModelElementIdToEObjectMappingImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.conflictDetection.ChangeConflictSet;
import org.eclipse.emf.emfstore.internal.server.impl.api.ESConflictSetImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.versionspec.ESPrimaryVersionSpecImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.ESConflictSet;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.ESChangePackage;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;
import org.eclipse.emf.emfstore.server.model.versionspec.ESVersionSpec;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIUpdateProjectController
extends AbstractEMFStoreUIController<ESPrimaryVersionSpec>
implements ESUpdateCallback {
    protected static final int ALL_CHANGES = -1;
    private static boolean doNotUsePagedUpdate = true;
    private final ESLocalProject localProject;
    private ESVersionSpec version;
    private int maxChanges;
    private ESPrimaryVersionSpec resolvedVersion;

    public UIUpdateProjectController(Shell shell, ESLocalProject localProject) {
        super(shell, true, true);
        this.localProject = localProject;
        this.maxChanges = -1;
        this.initPagedUpdateSize();
    }

    public UIUpdateProjectController(Shell shell, ESLocalProject localProject, ESVersionSpec versionSpec) {
        super(shell, true, true);
        this.localProject = localProject;
        this.version = versionSpec;
        this.maxChanges = -1;
        this.initPagedUpdateSize();
    }

    public UIUpdateProjectController(Shell shell, ESLocalProject localProject, int maxChanges) {
        super(shell, true, true);
        this.localProject = localProject;
        this.maxChanges = maxChanges;
    }

    private void initPagedUpdateSize() {
        ESPagedUpdateConfig pagedUpdateConfig = (ESPagedUpdateConfig)ExtensionRegistry.INSTANCE.get("org.eclipse.emf.emfstore.client.pagedUpdate.config", ESPagedUpdateConfig.class);
        if (pagedUpdateConfig != null) {
            this.maxChanges = pagedUpdateConfig.getNumberOfAllowedChanges();
            doNotUsePagedUpdate = false;
        }
    }

    public void noChangesOnServer() {
        RunInUI.run(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MessageDialog.openInformation((Shell)UIUpdateProjectController.this.getShell(), (String)"No need to update", (String)"Your project is up to date, you do not need to update.");
                return null;
            }
        });
    }

    public boolean conflictOccurred(ESConflictSet changeConflict, IProgressMonitor monitor) {
        ProjectSpace internalProject = (ProjectSpace)((ESLocalProjectImpl)this.localProject).toInternalAPI();
        ChangeConflictSet internalChangeConflict = ((ESConflictSetImpl)changeConflict).toInternalAPI();
        return new MergeProjectHandler(false).resolveConflicts(internalProject.getProject(), internalChangeConflict);
    }

    public boolean inspectChanges(ESLocalProject localProject, List<ESChangePackage> changePackages, ESModelElementIdToEObjectMapping idToEObjectMapping) {
        List internal = APIUtil.toInternal(ChangePackage.class, changePackages);
        final UpdateDialog updateDialog = new UpdateDialog(this.getShell(), localProject, internal, (ModelElementIdToEObjectMapping)((ESModelElementIdToEObjectMappingImpl)idToEObjectMapping).toInternalAPI());
        return RunInUI.runWithResult(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (updateDialog.open() == 0) {
                    return true;
                }
                return false;
            }
        });
    }

    @Override
    public ESPrimaryVersionSpec doRun(final IProgressMonitor monitor) throws ESException {
        boolean yes;
        ESPrimaryVersionSpec oldBaseVersion = this.localProject.getBaseVersion();
        ESPrimaryVersionSpec headVersion = this.localProject.resolveVersionSpec((ESVersionSpec)ESVersionSpec.FACTORY.createHEAD(oldBaseVersion.getBranch()), monitor);
        if (doNotUsePagedUpdate) {
            this.resolvedVersion = headVersion;
        } else {
            ESPrimaryVersionSpecImpl oldBaseVersionImpl = (ESPrimaryVersionSpecImpl)oldBaseVersion;
            this.resolvedVersion = this.resolveVersionByChanges(this.maxChanges, (ESPrimaryVersionSpec)((PrimaryVersionSpec)ModelUtil.clone((EObject)((PrimaryVersionSpec)oldBaseVersionImpl.toInternalAPI()))).toAPI(), monitor);
        }
        if (oldBaseVersion.equals(this.resolvedVersion)) {
            this.noChangesOnServer();
            return oldBaseVersion;
        }
        ESPrimaryVersionSpec newBaseVersion = this.version != null ? this.localProject.update(this.version, (ESUpdateCallback)this, monitor) : this.localProject.update((ESVersionSpec)this.resolvedVersion, (ESUpdateCallback)this, monitor);
        if (!doNotUsePagedUpdate && !newBaseVersion.equals(headVersion) && !newBaseVersion.equals(oldBaseVersion) && (yes = RunInUI.runWithResult(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return MessageDialog.openConfirm((Shell)UIUpdateProjectController.this.getShell(), (String)"More updates available", (String)"There are more updates available on the server.  Do you want to fetch and apply them now?");
            }
        }).booleanValue())) {
            return RunInUI.WithException.runWithResult(new Callable<ESPrimaryVersionSpec>(){

                @Override
                public ESPrimaryVersionSpec call() throws Exception {
                    return (ESPrimaryVersionSpec)new UIUpdateProjectController(UIUpdateProjectController.this.getShell(), UIUpdateProjectController.this.localProject, UIUpdateProjectController.this.maxChanges).executeSub(monitor);
                }
            });
        }
        return newBaseVersion;
    }

    private ESPrimaryVersionSpec resolveVersionByChanges(int maxChanges, ESPrimaryVersionSpec baseVersion, IProgressMonitor monitor) throws ESException {
        return this.localProject.resolveVersionSpec((ESVersionSpec)ESVersionSpec.FACTORY.createPAGEDUPDATE(baseVersion, maxChanges), monitor);
    }
}

