/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.controller;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.client.ESUsersession;
import org.eclipse.emf.emfstore.client.util.RunESCommand;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.connectionmanager.ServerCall;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ChangePackage;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.Versions;
import org.eclipse.emf.emfstore.server.exceptions.ESException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RevertCommitController
extends ServerCall<Void> {
    private PrimaryVersionSpec versionSpec;
    private final boolean headRevert;
    private String checkedoutCopyName;

    public RevertCommitController(ProjectSpace projectSpace, PrimaryVersionSpec versionSpec, boolean headRevert, String checkedoutCopyName) {
        super(projectSpace);
        this.versionSpec = versionSpec;
        this.headRevert = headRevert;
        this.checkedoutCopyName = checkedoutCopyName;
    }

    private void checkoutHeadAndReverseCommit(ProjectSpace projectSpace, PrimaryVersionSpec baseVersion, boolean headRevert) throws ESException {
        PrimaryVersionSpec localHead = this.getConnectionManager().resolveVersionSpec(projectSpace.getUsersession().getSessionId(), projectSpace.getProjectId(), (VersionSpec)Versions.createHEAD((VersionSpec)baseVersion));
        ESLocalProjectImpl revertSpace = ((ESLocalProjectImpl)projectSpace.toAPI()).getRemoteProject().checkout(this.checkedoutCopyName, (ESUsersession)projectSpace.getUsersession().toAPI(), this.getProgressMonitor());
        List<ChangePackage> changes = ((ProjectSpace)revertSpace.toInternalAPI()).getChanges((VersionSpec)baseVersion, (VersionSpec)(headRevert ? localHead : (PrimaryVersionSpec)ModelUtil.clone((EObject)baseVersion)));
        Collections.reverse(changes);
        for (ChangePackage changePackage : changes) {
            changePackage.reverse().apply(((ProjectSpace)revertSpace.toInternalAPI()).getProject(), true);
        }
    }

    @Override
    protected Void run() throws ESException {
        return RunESCommand.WithException.runWithResult(ESException.class, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                RevertCommitController.this.checkoutHeadAndReverseCommit(RevertCommitController.this.getProjectSpace(), RevertCommitController.this.versionSpec, RevertCommitController.this.headRevert);
                return null;
            }
        });
    }
}

