/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.client.util;

import java.util.concurrent.Callable;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommand;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommandWithException;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommandWithResult;
import org.eclipse.emf.emfstore.internal.client.model.util.EMFStoreCommandWithResultAndException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RunESCommand {
    private RunESCommand() {
    }

    public static void run(final Callable<Void> callable) {
        new EMFStoreCommand(){

            protected void doRun() {
                try {
                    callable.call();
                }
                catch (Exception exception) {}
            }
        }.run(false);
    }

    public static <T> T runWithResult(final Callable<T> callable) {
        return new EMFStoreCommandWithResult<T>(){

            @Override
            protected T doRun() {
                try {
                    return callable.call();
                }
                catch (Exception exception) {
                    return null;
                }
            }
        }.run(false);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WithException {
        public static <T, E extends Exception> T runWithResult(final Class<E> exceptionType, final Callable<T> callable) throws E {
            EMFStoreCommandWithResultAndException cmd = new EMFStoreCommandWithResultAndException<T, E>(){

                @Override
                protected T doRun() {
                    try {
                        return callable.call();
                    }
                    catch (Exception e) {
                        if (!exceptionType.isInstance(e)) {
                            if (e instanceof RuntimeException) {
                                throw (RuntimeException)e;
                            }
                            throw new RuntimeException(e);
                        }
                        this.setException((Exception)exceptionType.cast(e));
                        return null;
                    }
                }
            };
            Object result = cmd.run(false);
            if (cmd.hasException()) {
                throw (Exception)cmd.getExcpetion();
            }
            return result;
        }

        public static <T extends Exception> void run(final Class<T> exceptionType, final Callable<Void> callable) throws T {
            EMFStoreCommandWithException cmd = new EMFStoreCommandWithException<T>(){

                @Override
                protected void doRun() {
                    try {
                        callable.call();
                    }
                    catch (Exception e) {
                        if (exceptionType.isInstance(e)) {
                            this.setException((Exception)exceptionType.cast(e));
                        }
                        if (e instanceof RuntimeException) {
                            throw (RuntimeException)e;
                        }
                        throw new RuntimeException(e);
                    }
                }
            };
            cmd.run(false);
            if (cmd.hasException()) {
                throw (Exception)cmd.getException();
            }
        }
    }
}

