/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.versioning.util;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.emfstore.internal.common.model.ModelElementId;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.ModelElementQuery;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PathQuery;
import org.eclipse.emf.emfstore.internal.server.model.versioning.PrimaryVersionSpec;
import org.eclipse.emf.emfstore.internal.server.model.versioning.RangeQuery;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersioningFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HistoryQueryBuilder {
    private HistoryQueryBuilder() {
    }

    public static RangeQuery rangeQuery(PrimaryVersionSpec source, int upper, int lower, boolean allVersions, boolean incoming, boolean outgoing, boolean includeCp) {
        RangeQuery query = VersioningFactory.eINSTANCE.createRangeQuery();
        query.setSource((PrimaryVersionSpec)ModelUtil.clone((EObject)source));
        query.setUpperLimit(upper);
        query.setLowerLimit(lower);
        query.setIncludeAllVersions(allVersions);
        query.setIncludeIncoming(incoming);
        query.setIncludeOutgoing(outgoing);
        query.setIncludeChangePackages(includeCp);
        return query;
    }

    public static PathQuery pathQuery(PrimaryVersionSpec source, PrimaryVersionSpec target, boolean allVersions, boolean includeCp) {
        PathQuery query = VersioningFactory.eINSTANCE.createPathQuery();
        query.setSource((PrimaryVersionSpec)ModelUtil.clone((EObject)source));
        query.setTarget((PrimaryVersionSpec)ModelUtil.clone((EObject)target));
        query.setIncludeAllVersions(allVersions);
        query.setIncludeChangePackages(includeCp);
        return query;
    }

    public static ModelElementQuery modelelementQuery(PrimaryVersionSpec source, List<ModelElementId> modelElements, int upper, int lower, boolean allVersions, boolean includeCp) {
        ModelElementQuery query = VersioningFactory.eINSTANCE.createModelElementQuery();
        query.setSource((PrimaryVersionSpec)ModelUtil.clone((EObject)source));
        query.getModelElements().addAll(modelElements);
        query.setUpperLimit(upper);
        query.setLowerLimit(lower);
        query.setIncludeAllVersions(allVersions);
        query.setIncludeChangePackages(includeCp);
        query.setIncludeIncoming(false);
        query.setIncludeOutgoing(false);
        return query;
    }

    public static ModelElementQuery modelelementQuery(PrimaryVersionSpec source, ModelElementId id, int upper, int lower, boolean allVersions, boolean includeCp) {
        return HistoryQueryBuilder.modelelementQuery(source, Arrays.asList(id), upper, lower, allVersions, includeCp);
    }
}

