/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.embedcdt.managedbuild.cross.core;

import org.eclipse.cdt.core.cdtvariables.CdtVariableException;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IOptionCommandGenerator;
import org.eclipse.cdt.utils.cdtvariables.CdtVariableResolver;
import org.eclipse.cdt.utils.cdtvariables.IVariableSubstitutor;
import org.eclipse.embedcdt.internal.managedbuild.cross.core.Activator;
import org.eclipse.embedcdt.managedbuild.cross.core.Utils;

public class LinkerScriptCommandGenerator
implements IOptionCommandGenerator {
    public String generateCommand(IOption option, IVariableSubstitutor macroSubstitutor) {
        StringBuffer command = new StringBuffer();
        try {
            int valueType = option.getValueType();
            if (valueType == 2) {
                String value = option.getStringValue();
                value = CdtVariableResolver.resolveToString((String)value, (IVariableSubstitutor)macroSubstitutor);
                command.append("-T ");
                command.append(Utils.quoteWhitespaces(value));
            } else if (valueType == 3) {
                String[] stringArray = option.getStringListValue();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String value = stringArray[n2];
                    if (value != null) {
                        value = value.trim();
                    }
                    if (value.length() > 0) {
                        value = CdtVariableResolver.resolveToString((String)value, (IVariableSubstitutor)macroSubstitutor);
                        command.append("-T ");
                        command.append(Utils.quoteWhitespaces(value));
                        command.append(" ");
                    }
                    ++n2;
                }
            }
        }
        catch (BuildException e) {
            Activator.log((Throwable)e);
        }
        catch (CdtVariableException e) {
            Activator.log((Throwable)e);
        }
        return command.toString().trim();
    }
}

