/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import java.util.List;
import org.eclipse.elk.alg.common.nodespacing.NodeDimensionCalculation;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LGraphAdapters;
import org.eclipse.elk.alg.layered.graph.LMargin;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNode;
import org.eclipse.elk.alg.layered.p5edges.loops.SelfLoopNodeSide;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.math.ElkMargin;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.adapters.GraphAdapters;

public final class NodeMarginCalculator
implements ILayoutProcessor<LGraph> {
    private static final double SELF_LOOP_EDGE_DISTANCE = 10.0;

    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Node margin calculation", 1.0f);
        NodeDimensionCalculation.getNodeMarginCalculator((GraphAdapters.GraphAdapter)LGraphAdapters.adapt(layeredGraph, false)).excludeEdgeHeadTailLabels().process();
        double nodeNodeSpacing = (Double)layeredGraph.getProperty(LayeredOptions.SPACING_NODE_NODE);
        for (Layer layer : layeredGraph) {
            for (LNode node : layer) {
                this.processSelfLoops(node);
                this.processComments(node, nodeNodeSpacing);
            }
        }
        monitor.done();
    }

    private void processComments(LNode node, double spacing) {
        double maxCommentWidth;
        LMargin margin = node.getMargin();
        List topBoxes = (List)node.getProperty(InternalProperties.TOP_COMMENTS);
        double topWidth = 0.0;
        if (topBoxes != null) {
            double maxHeight = 0.0;
            for (LNode commentBox : topBoxes) {
                maxHeight = Math.max(maxHeight, commentBox.getSize().y);
                topWidth += commentBox.getSize().x;
            }
            topWidth += spacing / 2.0 * (double)(topBoxes.size() - 1);
            margin.top += maxHeight + spacing;
        }
        List bottomBoxes = (List)node.getProperty(InternalProperties.BOTTOM_COMMENTS);
        double bottomWidth = 0.0;
        if (bottomBoxes != null) {
            double maxHeight = 0.0;
            for (LNode commentBox : bottomBoxes) {
                maxHeight = Math.max(maxHeight, commentBox.getSize().y);
                bottomWidth += commentBox.getSize().x;
            }
            bottomWidth += spacing / 2.0 * (double)(bottomBoxes.size() - 1);
            margin.bottom += maxHeight + spacing;
        }
        if ((maxCommentWidth = Math.max(topWidth, bottomWidth)) > node.getSize().x) {
            double protrusion = (maxCommentWidth - node.getSize().x) / 2.0;
            margin.left = Math.max(margin.left, protrusion);
            margin.right = Math.max(margin.right, protrusion);
        }
    }

    private void processSelfLoops(LNode node) {
        LMargin nodeMargin = node.getMargin();
        ElkMargin selfLoopMargin = new ElkMargin();
        SelfLoopNode nodeRep = (SelfLoopNode)node.getProperty(InternalProperties.SELFLOOP_NODE_REPRESENTATION);
        if (nodeRep != null) {
            for (SelfLoopNodeSide side : nodeRep.getSides()) {
                int maximumPortLevelOfNode = side.getMaximumPortLevel() + side.getMaximumSegmentLevel();
                double maximumOffsetOfNode = side.getMaximumLabelOffset();
                double margin = (double)maximumPortLevelOfNode * 10.0 + maximumOffsetOfNode;
                switch (side.getSide()) {
                    case NORTH: {
                        selfLoopMargin.top = margin;
                        break;
                    }
                    case EAST: {
                        selfLoopMargin.right = margin;
                        break;
                    }
                    case SOUTH: {
                        selfLoopMargin.bottom = margin;
                        break;
                    }
                    case WEST: {
                        selfLoopMargin.left = margin;
                    }
                }
            }
            nodeMargin.left = Math.max(nodeMargin.left, selfLoopMargin.left);
            nodeMargin.right = Math.max(nodeMargin.right, selfLoopMargin.right);
            nodeMargin.bottom = Math.max(nodeMargin.bottom, selfLoopMargin.bottom);
            nodeMargin.top = Math.max(nodeMargin.top, selfLoopMargin.top);
        }
    }
}

