/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order.counting;

import java.util.List;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.p3order.counting.CrossMinUtil;
import org.eclipse.elk.core.options.PortSide;

public class NorthSouthEdgeAllCrossingsCounter {
    private int[] nodePositions;
    private final int[] portPositions;
    private int[] northCardinalities;
    private int[] southCardinalities;
    private LNode[] layer;
    private LNode currentOriginNode;
    private int numberOfNorthSouthEdges;
    private int numberOfLongEdgeDummies;
    private boolean northOfCurrentOriginNode = true;

    public NorthSouthEdgeAllCrossingsCounter(int[] portPositions) {
        this.portPositions = portPositions;
    }

    public int countCrossings(LNode[] nodes) {
        this.initialize(nodes);
        int crossings = 0;
        LNode[] lNodeArray = this.layer;
        int n = this.layer.length;
        int n2 = 0;
        while (n2 < n) {
            LNode node = lNodeArray[n2];
            crossings += this.getLongEdgeDummyCrossings(node);
            if (this.hasPortOnSide(node, PortSide.NORTH)) {
                crossings += this.getCrossingsOnSide(node, PortSide.NORTH);
            }
            if (this.hasPortOnSide(node, PortSide.SOUTH)) {
                crossings += this.getCrossingsOnSide(node, PortSide.SOUTH);
            }
            ++n2;
        }
        return crossings;
    }

    private void initialize(LNode[] nodes) {
        this.layer = nodes;
        this.nodePositions = new int[this.layer.length];
        this.northCardinalities = new int[this.layer.length];
        this.southCardinalities = new int[this.layer.length];
        this.initPositionsAndCardinalities();
    }

    private void initPositionsAndCardinalities() {
        int nodeId = 0;
        LNode[] lNodeArray = this.layer;
        int n = this.layer.length;
        int n2 = 0;
        while (n2 < n) {
            LNode element = lNodeArray[n2];
            LNode node = element;
            if (!this.isLongEdgeDummy(node)) {
                this.nodePositions[node.id] = nodeId++;
            }
            this.setPortPositionsAndCardinalitiesFor(node, this.northCardinalities, PortSide.NORTH);
            this.setPortPositionsAndCardinalitiesFor(node, this.southCardinalities, PortSide.SOUTH);
            ++n2;
        }
    }

    private void setPortPositionsAndCardinalitiesFor(LNode node, int[] cardinalities, PortSide side) {
        Iterable<LPort> ports = CrossMinUtil.inNorthSouthEastWestOrder(node, side);
        int portId = 0;
        for (LPort port : ports) {
            this.portPositions[port.id] = portId++;
        }
        cardinalities[node.id] = portId;
    }

    private int getLongEdgeDummyCrossings(LNode node) {
        int crossings = 0;
        if (this.isNorthSouth(node)) {
            if (this.originIsNotCurrentOrigin(node)) {
                this.resetDummyCountAndSetCurrentOriginNodeTo(this.originPortOf(node).getNode());
                this.northOfCurrentOriginNode = true;
            }
            if (this.northOfCurrentOriginNode) {
                ++this.numberOfNorthSouthEdges;
            } else {
                crossings += this.numberOfLongEdgeDummies;
            }
        } else if (this.isLongEdgeDummy(node)) {
            if (this.northOfCurrentOriginNode) {
                crossings += this.numberOfNorthSouthEdges;
            } else {
                ++this.numberOfLongEdgeDummies;
            }
        } else if (this.isNormal(node)) {
            this.resetDummyCountAndSetCurrentOriginNodeTo(node);
            this.northOfCurrentOriginNode = false;
        }
        return crossings;
    }

    private boolean originIsNotCurrentOrigin(LNode node) {
        return !((Object)((Object)this.originPortOf(node).getNode())).equals((Object)this.currentOriginNode);
    }

    private void resetDummyCountAndSetCurrentOriginNodeTo(LNode node) {
        this.currentOriginNode = node;
        this.numberOfNorthSouthEdges = 0;
        this.numberOfLongEdgeDummies = 0;
    }

    private boolean isNormal(LNode node) {
        return node.getType() == LNode.NodeType.NORMAL;
    }

    private boolean isLongEdgeDummy(LNode node) {
        return node.getType() == LNode.NodeType.LONG_EDGE;
    }

    private boolean isNorthSouth(LNode node) {
        return node.getType() == LNode.NodeType.NORTH_SOUTH_PORT;
    }

    private int getCrossingsOnSide(LNode node, PortSide side) {
        int crossings = 0;
        List<LPort> ports = node.getPortSideView(side);
        for (LPort port : ports) {
            if (!this.hasConnectedEdge(port)) continue;
            LNode northSouthDummy = this.getConnectedNorthSouthDummy(port);
            if (this.hasPortOnSide(northSouthDummy, PortSide.EAST)) {
                crossings += this.numberOfEasternCrossings(node, port, northSouthDummy, side);
            }
            if (!this.hasPortOnSide(northSouthDummy, PortSide.WEST)) continue;
            crossings += this.numberOfWesternCrossings(node, port, northSouthDummy, side);
        }
        return crossings;
    }

    private boolean hasConnectedEdge(LPort port) {
        return this.getConnectedNorthSouthDummy(port) != null;
    }

    private int numberOfWesternCrossings(LNode node, LPort port, LNode northSouthDummy, PortSide side) {
        int factor = northSouthDummy.getPortSideView(PortSide.WEST).get(0).getDegree();
        return factor * Math.min(this.positionOf(port), this.nearnessBetween(node, northSouthDummy));
    }

    private int numberOfEasternCrossings(LNode node, LPort port, LNode northSouthDummy, PortSide side) {
        int factor = northSouthDummy.getPortSideView(PortSide.EAST).get(0).getDegree();
        return factor * Math.min(this.cardinalityOnSide(node, side) - 1 - this.positionOf(port), this.nearnessBetween(node, northSouthDummy));
    }

    private boolean hasPortOnSide(LNode node, PortSide side) {
        return node.getPortSideView(side).iterator().hasNext();
    }

    private LNode getConnectedNorthSouthDummy(LPort port) {
        return (LNode)((Object)port.getProperty(InternalProperties.PORT_DUMMY));
    }

    private int nearnessBetween(LNode node, LNode northSouthDummy) {
        PortSide dummySide = this.getSideOf(northSouthDummy);
        int cardinality = this.cardinalityOnSide(node, dummySide);
        return cardinality - Math.abs(this.positionOf(node) - this.positionOf(northSouthDummy));
    }

    private Integer cardinalityOnSide(LNode node, PortSide side) {
        switch (side) {
            case NORTH: {
                return this.northCardinalities[node.id];
            }
            case SOUTH: {
                return this.southCardinalities[node.id];
            }
        }
        assert (false) : "Cardinality for port side " + side + " has not been collected!";
        return 0;
    }

    private int positionOf(LNode node) {
        return this.nodePositions[node.id];
    }

    private int positionOf(LPort port) {
        return this.portPositions[port.id];
    }

    private PortSide getSideOf(LNode northSouthDummy) {
        return this.originPortOf(northSouthDummy).getSide();
    }

    private LPort originPortOf(LNode node) {
        LPort port = node.getPorts().get(0);
        LPort origin = (LPort)((Object)port.getProperty(InternalProperties.ORIGIN));
        return origin;
    }
}

