/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.elk.alg.layered.LayeredPhases;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.IntermediateProcessorStrategy;
import org.eclipse.elk.alg.layered.options.GraphProperties;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.p3order.NodeRelativePortDistributor;
import org.eclipse.elk.alg.layered.p3order.counting.IInitializable;
import org.eclipse.elk.core.alg.ILayoutPhase;
import org.eclipse.elk.core.alg.ILayoutProcessorFactory;
import org.eclipse.elk.core.alg.LayoutProcessorConfiguration;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.math.KVectorChain;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public final class InteractiveCrossingMinimizer
implements ILayoutPhase<LayeredPhases, LGraph> {
    private static final LayoutProcessorConfiguration<LayeredPhases, LGraph> INTERMEDIATE_PROCESSING_CONFIGURATION = LayoutProcessorConfiguration.create().addBefore((Enum)LayeredPhases.P3_NODE_ORDERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.LONG_EDGE_SPLITTER).addBefore((Enum)LayeredPhases.P4_NODE_PLACEMENT, (ILayoutProcessorFactory)IntermediateProcessorStrategy.IN_LAYER_CONSTRAINT_PROCESSOR).addAfter((Enum)LayeredPhases.P5_EDGE_ROUTING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.LONG_EDGE_JOINER);

    public LayoutProcessorConfiguration<LayeredPhases, LGraph> getLayoutProcessorConfiguration(LGraph graph) {
        LayoutProcessorConfiguration configuration = LayoutProcessorConfiguration.createFrom(INTERMEDIATE_PROCESSING_CONFIGURATION);
        if (((Set)graph.getProperty(InternalProperties.GRAPH_PROPERTIES)).contains((Object)GraphProperties.NON_FREE_PORTS)) {
            configuration.addBefore((Enum)LayeredPhases.P3_NODE_ORDERING, (ILayoutProcessorFactory)IntermediateProcessorStrategy.PORT_LIST_SORTER);
        }
        return configuration;
    }

    public void process(LGraph layeredGraph, IElkProgressMonitor monitor) {
        monitor.begin("Interactive crossing minimization", 1.0f);
        int layerIndex = 0;
        for (Layer layer : layeredGraph.getLayers()) {
            layer.id = layerIndex++;
        }
        LNode[][] nodeOrder = layeredGraph.toNodeArray();
        NodeRelativePortDistributor portDistributor = new NodeRelativePortDistributor(nodeOrder.length);
        IInitializable.init(Arrays.asList(portDistributor), nodeOrder);
        int portCount = 0;
        layerIndex = 0;
        for (Layer layer : layeredGraph) {
            double horizPos = 0.0;
            int nodeCount = 0;
            for (LNode node : layer.getNodes()) {
                if (node.getPosition().x > 0.0) {
                    horizPos += node.getPosition().x + node.getSize().x / 2.0;
                    ++nodeCount;
                }
                for (LPort port : node.getPorts()) {
                    port.id = portCount++;
                }
            }
            horizPos /= (double)nodeCount;
            final double[] pos = new double[layer.getNodes().size()];
            int nextIndex = 0;
            for (LNode node : layer) {
                node.id = nextIndex++;
                pos[node.id] = this.getPos(node, horizPos);
                if (node.getType() != LNode.NodeType.LONG_EDGE) continue;
                node.setProperty(InternalProperties.ORIGINAL_DUMMY_NODE_POSITION, pos[node.id]);
            }
            Collections.sort(layer.getNodes(), new Comparator<LNode>(){

                @Override
                public int compare(LNode node1, LNode node2) {
                    int compare = Double.compare(pos[node1.id], pos[node2.id]);
                    if (compare == 0) {
                        List node1Successors = (List)node1.getProperty(InternalProperties.IN_LAYER_SUCCESSOR_CONSTRAINTS);
                        List node2Successors = (List)node2.getProperty(InternalProperties.IN_LAYER_SUCCESSOR_CONSTRAINTS);
                        if (node1Successors.contains((Object)node2)) {
                            return -1;
                        }
                        if (node2Successors.contains((Object)node1)) {
                            return 1;
                        }
                    }
                    return compare;
                }
            });
            portDistributor.distributePortsWhileSweeping(nodeOrder, layerIndex, true);
            ++layerIndex;
        }
        monitor.done();
    }

    private double getPos(LNode node, double horizPos) {
        switch (node.getType()) {
            case LONG_EDGE: {
                LPort target;
                LEdge edge = (LEdge)((Object)node.getProperty(InternalProperties.ORIGIN));
                KVectorChain bendpoints = (KVectorChain)edge.getProperty(InternalProperties.ORIGINAL_BENDPOINTS);
                if (bendpoints == null) {
                    bendpoints = new KVectorChain();
                } else if (((Boolean)edge.getProperty(InternalProperties.REVERSED)).booleanValue()) {
                    bendpoints = KVectorChain.reverse((KVectorChain)bendpoints);
                }
                LPort source = (LPort)((Object)node.getProperty(InternalProperties.LONG_EDGE_SOURCE));
                if (source != null) {
                    KVector sourcePoint = source.getAbsoluteAnchor();
                    if (horizPos <= sourcePoint.x) {
                        return sourcePoint.y;
                    }
                    bendpoints.addFirst((Object)sourcePoint);
                }
                if ((target = (LPort)((Object)node.getProperty(InternalProperties.LONG_EDGE_TARGET))) != null) {
                    KVector targetPoint = target.getAbsoluteAnchor();
                    if (targetPoint.x <= horizPos) {
                        return targetPoint.y;
                    }
                    bendpoints.addLast((Object)targetPoint);
                }
                if (bendpoints.size() < 2) break;
                Iterator pointIter = bendpoints.iterator();
                KVector point1 = (KVector)pointIter.next();
                KVector point2 = (KVector)pointIter.next();
                while (point2.x < horizPos && pointIter.hasNext()) {
                    point1 = point2;
                    point2 = (KVector)pointIter.next();
                }
                return point1.y + (horizPos - point1.x) / (point2.x - point1.x) * (point2.y - point1.y);
            }
            case NORTH_SOUTH_PORT: {
                LPort originPort = (LPort)((Object)node.getPorts().get(0).getProperty(InternalProperties.ORIGIN));
                LNode originNode = originPort.getNode();
                switch (originPort.getSide()) {
                    case NORTH: {
                        return originNode.getPosition().y;
                    }
                    case SOUTH: {
                        return originNode.getPosition().y + originNode.getSize().y;
                    }
                }
            }
        }
        return node.getInteractiveReferencePoint().y;
    }
}

