/**
 * Copyright (c) 2016 Kiel University and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    Kiel University - initial API and implementation
 */
package org.eclipse.elk.alg.force.properties;

import java.util.EnumSet;
import org.eclipse.elk.alg.force.stress.StressMajorization;
import org.eclipse.elk.core.data.ILayoutMetaDataProvider;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.Property;

/**
 * Declarations for the ELK Stress layout algorithm.
 */
@SuppressWarnings("all")
public class StressMetaDataProvider implements ILayoutMetaDataProvider {
  /**
   * Default value for {@link #FIXED}.
   */
  private final static boolean FIXED_DEFAULT = false;
  
  /**
   * Prevent that the node is moved by the layout algorithm.
   */
  public final static IProperty<Boolean> FIXED = new Property<Boolean>(
            "org.eclipse.elk.stress.fixed",
            FIXED_DEFAULT,
            null,
            null);
  
  /**
   * Default value for {@link #DESIRED_EDGE_LENGTH}.
   */
  private final static float DESIRED_EDGE_LENGTH_DEFAULT = 100f;
  
  /**
   * Either specified for parent nodes or for individual edges,
   * where the latter takes higher precedence.
   */
  public final static IProperty<Float> DESIRED_EDGE_LENGTH = new Property<Float>(
            "org.eclipse.elk.stress.desiredEdgeLength",
            DESIRED_EDGE_LENGTH_DEFAULT,
            null,
            null);
  
  /**
   * Default value for {@link #DIMENSION}.
   */
  private final static StressMajorization.Dimension DIMENSION_DEFAULT = StressMajorization.Dimension.XY;
  
  /**
   * Dimensions that are permitted to be altered during layout.
   */
  public final static IProperty<StressMajorization.Dimension> DIMENSION = new Property<StressMajorization.Dimension>(
            "org.eclipse.elk.stress.dimension",
            DIMENSION_DEFAULT,
            null,
            null);
  
  /**
   * Default value for {@link #EPSILON}.
   */
  private final static float EPSILON_DEFAULT = 10e-4f;
  
  /**
   * Termination criterion for the iterative process.
   */
  public final static IProperty<Float> EPSILON = new Property<Float>(
            "org.eclipse.elk.stress.epsilon",
            EPSILON_DEFAULT,
            null,
            null);
  
  /**
   * Default value for {@link #ITERATION_LIMIT}.
   */
  private final static int ITERATION_LIMIT_DEFAULT = Integer.MAX_VALUE;
  
  /**
   * Maximum number of performed iterations. Takes higher
   * precedence than 'epsilon'.
   */
  public final static IProperty<Integer> ITERATION_LIMIT = new Property<Integer>(
            "org.eclipse.elk.stress.iterationLimit",
            ITERATION_LIMIT_DEFAULT,
            null,
            null);
  
  public void apply(final org.eclipse.elk.core.data.ILayoutMetaDataProvider.Registry registry) {
    registry.register(new org.eclipse.elk.core.data.LayoutOptionData(
        "org.eclipse.elk.stress.fixed",
        "",
        "Fixed Position",
        "Prevent that the node is moved by the layout algorithm.",
        FIXED_DEFAULT,
        null,
        null,
        org.eclipse.elk.core.data.LayoutOptionData.Type.BOOLEAN,
        Boolean.class,
        EnumSet.of(org.eclipse.elk.core.data.LayoutOptionData.Target.NODES),
        org.eclipse.elk.core.data.LayoutOptionData.Visibility.VISIBLE
    ));
    registry.register(new org.eclipse.elk.core.data.LayoutOptionData(
        "org.eclipse.elk.stress.desiredEdgeLength",
        "",
        "Desired Edge Length",
        "Either specified for parent nodes or for individual edges, where the latter takes higher precedence.",
        DESIRED_EDGE_LENGTH_DEFAULT,
        null,
        null,
        org.eclipse.elk.core.data.LayoutOptionData.Type.DOUBLE,
        Double.class,
        EnumSet.of(org.eclipse.elk.core.data.LayoutOptionData.Target.PARENTS, org.eclipse.elk.core.data.LayoutOptionData.Target.EDGES),
        org.eclipse.elk.core.data.LayoutOptionData.Visibility.VISIBLE
    ));
    registry.register(new org.eclipse.elk.core.data.LayoutOptionData(
        "org.eclipse.elk.stress.dimension",
        "",
        "Layout Dimension",
        "Dimensions that are permitted to be altered during layout.",
        DIMENSION_DEFAULT,
        null,
        null,
        org.eclipse.elk.core.data.LayoutOptionData.Type.ENUM,
        StressMajorization.Dimension.class,
        EnumSet.of(org.eclipse.elk.core.data.LayoutOptionData.Target.PARENTS),
        org.eclipse.elk.core.data.LayoutOptionData.Visibility.VISIBLE
    ));
    registry.register(new org.eclipse.elk.core.data.LayoutOptionData(
        "org.eclipse.elk.stress.epsilon",
        "",
        "Stress Epsilon",
        "Termination criterion for the iterative process.",
        EPSILON_DEFAULT,
        null,
        null,
        org.eclipse.elk.core.data.LayoutOptionData.Type.DOUBLE,
        Double.class,
        EnumSet.of(org.eclipse.elk.core.data.LayoutOptionData.Target.PARENTS),
        org.eclipse.elk.core.data.LayoutOptionData.Visibility.VISIBLE
    ));
    registry.register(new org.eclipse.elk.core.data.LayoutOptionData(
        "org.eclipse.elk.stress.iterationLimit",
        "",
        "Iteration Limit",
        "Maximum number of performed iterations. Takes higher precedence than \'epsilon\'.",
        ITERATION_LIMIT_DEFAULT,
        null,
        null,
        org.eclipse.elk.core.data.LayoutOptionData.Type.INT,
        Integer.class,
        EnumSet.of(org.eclipse.elk.core.data.LayoutOptionData.Target.PARENTS),
        org.eclipse.elk.core.data.LayoutOptionData.Visibility.VISIBLE
    ));
    new org.eclipse.elk.alg.force.properties.StressOptions().apply(registry);
  }
}
