/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order;

import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.p3order.AbstractBarycenterPortDistributor;
import org.eclipse.elk.alg.layered.properties.PortType;
import org.eclipse.elk.core.options.PortSide;

public final class NodeRelativePortDistributor
extends AbstractBarycenterPortDistributor {
    public NodeRelativePortDistributor(int numLayers) {
        super(numLayers);
    }

    @Override
    protected float calculatePortRanks(LNode node, float rankSum, PortType type) {
        float[] portRanks = this.getPortRanks();
        switch (type) {
            case INPUT: {
                int inputCount = 0;
                int northInputCount = 0;
                for (LPort port : node.getPorts()) {
                    if (port.getIncomingEdges().isEmpty()) continue;
                    ++inputCount;
                    if (port.getSide() != PortSide.NORTH) continue;
                    ++northInputCount;
                }
                float incr = 1.0f / (float)(inputCount + 1);
                float northPos = rankSum + (float)northInputCount * incr;
                float restPos = rankSum + 1.0f - incr;
                for (LPort port : node.getPorts(PortType.INPUT)) {
                    if (port.getSide() == PortSide.NORTH) {
                        portRanks[port.id] = northPos;
                        northPos -= incr;
                        continue;
                    }
                    portRanks[port.id] = restPos;
                    restPos -= incr;
                }
                break;
            }
            case OUTPUT: {
                int outputCount = 0;
                for (LPort port : node.getPorts()) {
                    if (port.getOutgoingEdges().isEmpty()) continue;
                    ++outputCount;
                }
                float incr = 1.0f / (float)(outputCount + 1);
                float pos = rankSum + incr;
                for (LPort port : node.getPorts(PortType.OUTPUT)) {
                    portRanks[port.id] = pos;
                    pos += incr;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Port type is undefined");
            }
        }
        return 1.0f;
    }
}

