/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.errors.GitAPIException;

public class AddToIndexOperation
implements IEGitOperation {
    private final Collection<? extends IResource> rsrcList;

    public AddToIndexOperation(Collection<? extends IResource> rsrcs) {
        this.rsrcList = rsrcs;
    }

    public AddToIndexOperation(IResource[] resources) {
        this.rsrcList = Arrays.asList(resources);
    }

    @Override
    public void execute(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.rsrcList.size() * 2));
        HashMap<RepositoryMapping, AddCommand> addCommands = new HashMap<RepositoryMapping, AddCommand>();
        try {
            for (IResource iResource : this.rsrcList) {
                this.addToCommand(iResource, addCommands);
                progress.worked(1);
            }
            progress.setWorkRemaining(addCommands.size());
            for (AddCommand addCommand : addCommands.values()) {
                addCommand.call();
                progress.worked(1);
            }
        }
        catch (RuntimeException | GitAPIException throwable) {
            throw new CoreException(Activator.error(CoreText.AddToIndexOperation_failed, throwable));
        }
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRuleForRepositories(this.rsrcList.toArray(new IResource[0]));
    }

    private void addToCommand(IResource resource, Map<RepositoryMapping, AddCommand> addCommands) {
        RepositoryMapping mapping = RepositoryMapping.getMapping(resource);
        if (mapping == null) {
            return;
        }
        AddCommand command = addCommands.computeIfAbsent(mapping, m -> new AddCommand(m.getRepository()));
        String filepattern = mapping.getRepoRelativePath(resource);
        if (filepattern == null || filepattern.isEmpty()) {
            filepattern = ".";
        }
        command.addFilepattern(filepattern);
    }
}

