/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.Query;
import org.eclipse.egf.pattern.query.IQuery;
import org.eclipse.egf.pattern.query.QueryKind;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.PatternUIHelper;
import org.eclipse.egf.pattern.ui.editors.dialogs.VariablesEditDialog;
import org.eclipse.egf.pattern.ui.editors.models.QueryContent;
import org.eclipse.egf.pattern.ui.editors.modifiers.QueryContentTableCellModifier;
import org.eclipse.egf.pattern.ui.editors.providers.CommonListContentProvider;
import org.eclipse.egf.pattern.ui.editors.providers.QueryContentTableLabelProvider;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersEditDialog
extends VariablesEditDialog {
    private Combo queryCombo;
    private String query;
    private Query itemQuery;
    private TableViewer tableViewer;
    private Button add;
    private Button remove;
    public static final String KEY_ID = "key";
    public static final String VALUE_ID = "value";
    private List<QueryContent> queryContents;

    public ParametersEditDialog(Shell shell, PatternParameter selectItem) {
        super(shell, selectItem);
        this.setDefaultQuery(selectItem);
    }

    private void setDefaultQuery(PatternParameter selectItem) {
        if (selectItem != null) {
            this.itemQuery = selectItem.getQuery();
            this.query = this.itemQuery == null ? "" : this.itemQuery.getExtensionId();
            QueryKind queryKind = IQuery.INSTANCE.getQueryKind(this.query);
            if (queryKind != null) {
                this.query = queryKind.getName();
            }
        }
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        ParametersEditDialog.createLabel(composite, Messages.ParametersEditDialog_Query);
        this.queryCombo = new Combo(composite, 8);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.queryCombo.setLayoutData((Object)gd);
        this.queryCombo.add(this.query);
        this.setQueryComboList(this.queryCombo, this.query);
        this.queryCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParametersEditDialog.this.query = ParametersEditDialog.this.queryCombo.getText();
            }
        });
        this.queryCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditDialog.this.setQueryContentAreaStatus();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.queryCombo.select(0);
        this.setQueryContentArea(composite);
        this.setQueryContentAreaStatus();
        this.setButtonsStatus();
        return this.dialogArea;
    }

    private void createQueryContentTable(Composite parent) {
        Composite tableComp = new Composite(parent, 0);
        TableColumnLayout layout = new TableColumnLayout();
        tableComp.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        gd.heightHint = 100;
        gd.widthHint = 400;
        tableComp.setLayoutData((Object)gd);
        Table table = new Table(tableComp, 68352);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        gd = new GridData(1808);
        gd.verticalIndent = 10;
        gd.horizontalIndent = 10;
        gd.widthHint = 130;
        table.setLayoutData((Object)gd);
        this.tableViewer = new TableViewer(table);
        int[] colWidths = new int[]{110, 200};
        String[] colNames = new String[]{Messages.ParametersEditDialog_Key_title, Messages.ParametersEditDialog_Value_title};
        int i = 0;
        while (i < colWidths.length) {
            TableColumn tableColumn = new TableColumn(table, 0);
            tableColumn.setWidth(colWidths[i]);
            tableColumn.setText(colNames[i]);
            layout.setColumnData((Widget)tableColumn, (ColumnLayoutData)new ColumnWeightData(colWidths[i], true));
            ++i;
        }
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ParametersEditDialog.this.checkKeyDuplicate();
                ParametersEditDialog.this.setButtonsStatus();
            }
        });
        this.initTableEditor();
        this.tableViewer.setContentProvider((IContentProvider)new CommonListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new QueryContentTableLabelProvider());
        this.getInitTableInput();
        this.tableViewer.setInput(this.queryContents);
    }

    private void initTableEditor() {
        this.tableViewer.setColumnProperties(new String[]{KEY_ID, VALUE_ID});
        TextCellEditor stringEditor = new TextCellEditor((Composite)this.tableViewer.getTable());
        this.tableViewer.setCellEditors(new CellEditor[]{stringEditor, stringEditor});
        QueryContentTableCellModifier modifier = new QueryContentTableCellModifier(this.tableViewer);
        this.tableViewer.setCellModifier((ICellModifier)modifier);
    }

    private void setQueryContentArea(Composite parent) {
        Label queryContextLabel = ParametersEditDialog.createLabel(parent, Messages.ParametersEditDialog_query_context_label);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        queryContextLabel.setLayoutData((Object)gd);
        this.createQueryContentTable(parent);
        this.createQueryContentButtons(parent);
    }

    private void createQueryContentButtons(Composite parent) {
        Composite buttons = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        buttons.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.widthHint = 40;
        this.add = new Button(buttons, 8);
        this.add.setImage(Activator.getDefault().getImage("obj16/add.gif"));
        this.add.setToolTipText(Messages.SpecificationPage_button_add);
        this.add.setLayoutData((Object)gd);
        this.add.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditDialog.this.executeAdd();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.remove = new Button(buttons, 8);
        this.remove.setImage(Activator.getDefault().getImage("obj16/delete.gif"));
        this.remove.setToolTipText(Messages.SpecificationPage_button_remove);
        this.remove.setLayoutData((Object)gd);
        this.remove.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ParametersEditDialog.this.executeRemove();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void executeAdd() {
        String key = KEY_ID;
        String value = VALUE_ID;
        QueryContent newContent = new QueryContent(key, value);
        if (this.queryContents == null) {
            this.queryContents = new ArrayList<QueryContent>();
        }
        this.queryContents.add(newContent);
        this.tableViewer.setInput(this.queryContents);
        this.tableViewer.getTable().setSelection(this.tableViewer.getTable().getItemCount() - 1);
        this.checkKeyDuplicate();
        this.setButtonsStatus();
    }

    private void executeRemove() {
        int selectionIndex = this.tableViewer.getTable().getSelectionIndex();
        QueryContent selectItem = this.getSelectItem();
        if (this.queryContents != null) {
            this.queryContents.remove(selectItem);
        }
        this.tableViewer.setInput(this.queryContents);
        int itemCount = this.tableViewer.getTable().getItemCount();
        if (selectionIndex < itemCount) {
            this.tableViewer.getTable().setSelection(selectionIndex);
        } else {
            this.tableViewer.getTable().setSelection(selectionIndex - 1);
        }
        this.setButtonsStatus();
    }

    private QueryContent getSelectItem() {
        int selectionIndex = this.tableViewer.getTable().getSelectionIndex();
        Object element = this.tableViewer.getElementAt(selectionIndex);
        if (element instanceof QueryContent) {
            return (QueryContent)element;
        }
        return null;
    }

    private void setButtonsStatus() {
        if (this.getSelectItem() == null) {
            this.remove.setEnabled(false);
        } else {
            this.remove.setEnabled(true);
        }
    }

    private void getInitTableInput() {
        this.queryContents = new ArrayList<QueryContent>();
        if (this.itemQuery != null) {
            EMap queryContext = this.itemQuery.getQueryContext();
            Set keySet = queryContext.keySet();
            for (String key : keySet) {
                String value = (String)queryContext.get((Object)key);
                QueryContent content = new QueryContent(key, value);
                this.queryContents.add(content);
            }
        }
    }

    private void setQueryComboList(Combo combo, String query) {
        List availableQueries = IQuery.INSTANCE.getAvailableQueries();
        for (QueryKind kind : availableQueries) {
            String name = kind.getName();
            if (name.equals(query)) continue;
            combo.add(name);
        }
        if (query != null && !"".equals(query)) {
            combo.add("");
        }
    }

    private void checkKeyDuplicate() {
        Status fLastStatusErr = new Status(4, "org.eclipse.jdt.core", -1, Messages.ParametersEditDialog_duplicate_key_error_message, null);
        Status fLastStatusOk = new Status(0, "org.eclipse.jface", 0, "", null);
        if (PatternUIHelper.hasDuplicateKey(this.queryContents)) {
            this.updateStatus((IStatus)fLastStatusErr);
        } else {
            this.updateStatus((IStatus)fLastStatusOk);
        }
    }

    private void setQueryContentAreaStatus() {
        String innerQuery = this.getQuery();
        if (innerQuery != null && !"".equals(innerQuery)) {
            this.setQueryContentAreaEnable(true);
        } else {
            this.setQueryContentAreaEnable(false);
            this.queryContents = new ArrayList<QueryContent>();
            this.tableViewer.setInput(this.queryContents);
        }
    }

    private void setQueryContentAreaEnable(boolean isEnable) {
        this.add.setEnabled(isEnable);
        this.remove.setEnabled(isEnable);
        this.tableViewer.getTable().setEnabled(isEnable);
    }

    public List<QueryContent> getQueryContents() {
        return this.queryContents;
    }

    public String getQuery() {
        return this.query;
    }
}

