/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.common.helper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.EGFCommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class FileHelper {
    private FileHelper() {
    }

    public static void safeClose(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void safeClose(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void createContainers(IProgressMonitor monitor, IResource resource) throws CoreException {
        IFolder parent;
        IContainer container = resource.getParent();
        if (container instanceof IFolder && !(parent = (IFolder)container).exists()) {
            FileHelper.createContainers(monitor, (IResource)parent);
            parent.create(false, true, monitor);
        }
    }

    public static URL getFileFullUrl(String fileRelativePath) {
        return FileHelper.getFileFullUrl(FileHelper.getFileFullUri(fileRelativePath));
    }

    public static URL getFileFullUrl(URI fileFullUri) {
        URL result = null;
        try {
            result = FileLocator.resolve((URL)new URL(fileFullUri.toString()));
        }
        catch (Exception e) {
            EGFCommonPlugin.getDefault().logError(NLS.bind((String)"FileHelper.getFileFullPath(..) _ Unable to resolve the url for ''{0}''", (Object)fileFullUri.toString()), e);
        }
        return result;
    }

    public static URI getFileFullUri(String fileRelativePath) {
        URI fileUri = null;
        if (fileRelativePath == null) {
            return fileUri;
        }
        Path path = new Path(fileRelativePath);
        IPluginModelBase modelBase = PluginRegistry.findModel((String)path.segment(0));
        IResource resource = modelBase != null ? modelBase.getUnderlyingResource() : null;
        fileUri = resource != null ? URI.createPlatformResourceURI((String)fileRelativePath, (boolean)true) : URI.createPlatformPluginURI((String)fileRelativePath, (boolean)true);
        return fileUri;
    }

    public static String convertPackageNameToFolderPath(String packageName) {
        return packageName != null ? packageName.replace('.', '/') : null;
    }

    public static byte[] readFile(InputStream inputStream) {
        byte[] data;
        block14: {
            data = null;
            try {
                try {
                    data = new byte[inputStream.available()];
                    inputStream.read(data);
                }
                catch (Exception e) {
                    EGFCommonPlugin.getDefault().logError("FileHelper.readFile(..) _ Failed to read the input stream !", e);
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException ioe) {
                            EGFCommonPlugin.getDefault().logError("FileHelper.readFile(..) _ Failed to close input stream !", ioe);
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException ioe) {
                        EGFCommonPlugin.getDefault().logError("FileHelper.readFile(..) _ Failed to close input stream !", ioe);
                    }
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ioe) {
                    EGFCommonPlugin.getDefault().logError("FileHelper.readFile(..) _ Failed to close input stream !", ioe);
                }
            }
        }
        return data == null ? new byte[]{} : data;
    }

    public static String readFile(String filePath) {
        byte[] rawContent = FileHelper.readRawFile(filePath);
        return rawContent.length == 0 ? "" : new String(rawContent);
    }

    public static InputStream readFileAsStream(String filePath) {
        InputStream result = null;
        URL fileURL = FileHelper.getFileFullUrl(filePath);
        try {
            result = fileURL.openStream();
        }
        catch (Exception e) {
            EGFCommonPlugin.getDefault().logError(NLS.bind((String)"FileHelper.readFileAsStream(..) _ Failed to load ''{0}''", (Object)filePath), e);
        }
        return result;
    }

    public static byte[] readRawFile(String filePath) {
        byte[] result = null;
        InputStream inputStream = FileHelper.readFileAsStream(filePath);
        if (inputStream != null) {
            result = FileHelper.readFile(inputStream);
        }
        return result == null ? new byte[]{} : result;
    }

    public static void copyFile(String sourceFileRelativePath, String targetFileRelativePath) {
        FileHelper.writeFile(targetFileRelativePath, true, FileHelper.readRawFile(sourceFileRelativePath));
    }

    public static boolean writeFile(String filePath, boolean ensureFolders, String contents) {
        return FileHelper.writeFile(filePath, ensureFolders, contents.getBytes());
    }

    public static boolean writeFile(String filePath, boolean ensureFolders, byte[] contents) {
        AbstractInterruptibleChannel channel = null;
        try {
            try {
                String fileFullPath = FileHelper.getFileFullUrl(filePath).getFile();
                if (ensureFolders) {
                    FileHelper.ensurePathAvailability(fileFullPath);
                }
                channel = new FileOutputStream(fileFullPath).getChannel();
                ((FileChannel)channel).write(ByteBuffer.wrap(contents));
            }
            catch (Exception e) {
                EGFCommonPlugin.getDefault().logError(NLS.bind((String)"FileHelper.writeFile(..) _ Failed to open channel in write mode for ''{0}'' !", (Object)filePath), e);
                if (channel != null && channel.isOpen()) {
                    try {
                        channel.close();
                    }
                    catch (IOException e2) {
                        EGFCommonPlugin.getDefault().logError(NLS.bind((String)"FileHelper.writeFile(..) _ Failed to close opened channel in write mode ! ''{0}'' may no longer be usable.", (Object)filePath), e2);
                    }
                }
                return false;
            }
        }
        finally {
            if (channel != null && channel.isOpen()) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    EGFCommonPlugin.getDefault().logError(NLS.bind((String)"FileHelper.writeFile(..) _ Failed to close opened channel in write mode ! ''{0}'' may no longer be usable.", (Object)filePath), e);
                }
            }
        }
        return true;
    }

    public static boolean renameFile(String sourceFileRelativePath, String destinationFileRelativePath) {
        if (sourceFileRelativePath == null || destinationFileRelativePath == null) {
            return false;
        }
        IFile sourceFile = FileHelper.getFile(sourceFileRelativePath);
        IPath destinationPath = FileHelper.getFile(destinationFileRelativePath).getFullPath();
        return FileHelper.moveResource((IResource)sourceFile, destinationPath);
    }

    public static boolean renameFolder(String sourceFolderRelativePath, String destinationFolderRelativePath) {
        if (sourceFolderRelativePath == null || destinationFolderRelativePath == null) {
            return false;
        }
        IFolder sourceFolder = FileHelper.getFolder(sourceFolderRelativePath);
        IPath destinationPath = FileHelper.getFolder(destinationFolderRelativePath).getFullPath();
        return FileHelper.moveResource((IResource)sourceFolder, destinationPath);
    }

    public static boolean moveResource(IResource resource, IPath destinationPath) {
        boolean result = false;
        try {
            resource.move(destinationPath, true, (IProgressMonitor)new NullProgressMonitor());
            result = true;
        }
        catch (Exception e) {
            EGFCommonPlugin.getDefault().logError(NLS.bind((String)"FileHelper.moveResource(..) _ Could not move ''{0}'' to ''{1}''", (Object)resource.getFullPath(), (Object)destinationPath), e);
        }
        return result;
    }

    public static boolean exists(String fileRelativePath) {
        IFile file = FileHelper.getFile(fileRelativePath);
        return file != null ? file.exists() : false;
    }

    public static boolean ensurePathAvailability(String fileFullPath) {
        IPath parentFolderPath = new Path(fileFullPath).removeFileExtension().removeLastSegments(1);
        if (!parentFolderPath.isEmpty()) {
            File parentFolder = parentFolderPath.toFile();
            return parentFolder.mkdirs();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean deleteIResource(IProgressMonitor monitor, IFolder root, IResource resource, boolean deleteParent) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        subMonitor.beginTask(null, 100);
        try {
            if (root == null) return false;
            if (!root.exists()) return false;
            if (resource == null) return false;
            if (!resource.exists()) return false;
            if (resource.equals((Object)root)) {
                return false;
            }
            if (!FileHelper.deleteResource((IProgressMonitor)subMonitor, resource, false)) return false;
            if (!deleteParent) return true;
            IContainer container = resource.getParent();
            while (!container.equals((Object)root)) {
                IResource[] members = container.members();
                if (members != null) {
                    if (members.length != 0) return true;
                }
                if (!FileHelper.deleteResource((IProgressMonitor)subMonitor, (IResource)container, false)) return true;
                container = container.getParent();
            }
            return true;
        }
        finally {
            subMonitor.worked(100);
        }
    }

    public static void deleteFile(IProgressMonitor monitor, String path) throws CoreException {
        if (path == null || path.trim().length() == 0) {
            return;
        }
        FileHelper.deleteResource(monitor, (IResource)FileHelper.getFile(path), false);
    }

    public static void deleteFolder(IProgressMonitor monitor, String path) throws CoreException {
        if (path == null || path.trim().length() == 0) {
            return;
        }
        FileHelper.deleteResource(monitor, (IResource)FileHelper.getFolder(path), false);
    }

    public static boolean deleteResource(IProgressMonitor monitor, IResource resource, boolean removeParentIfEmpty) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        subMonitor.beginTask(null, 200);
        if (resource == null || !resource.exists()) {
            subMonitor.worked(200);
            return false;
        }
        resource.delete(3, (IProgressMonitor)subMonitor.newChild(100, 0));
        if (removeParentIfEmpty) {
            if (resource.getParent().members() == null || resource.getParent().members().length == 0) {
                resource.getParent().delete(3, (IProgressMonitor)subMonitor.newChild(100, 0));
            } else {
                subMonitor.worked(100);
            }
        } else {
            subMonitor.worked(100);
        }
        return true;
    }

    public static IResource getPlatformResource(IPath path) {
        if (path == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().findMember(path);
    }

    public static IFile getFile(String fileRelativePath) {
        if (fileRelativePath == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileRelativePath));
    }

    public static IFile getFile(IPath fileRelativePath) {
        if (fileRelativePath == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFile(fileRelativePath);
    }

    public static IFolder getFolder(String folderRelativePath) {
        if (folderRelativePath == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(folderRelativePath));
    }

    public static IFolder getFolder(IPath folderRelativePath) {
        if (folderRelativePath == null) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFolder(folderRelativePath);
    }

    public static String getFileExtension(String filePath) {
        if (filePath == null) {
            return null;
        }
        return new Path(filePath).getFileExtension();
    }

    public static IFile getFile(IFolder folder, IPath path) {
        if (folder == null || path == null) {
            return null;
        }
        IResource resource = folder.findMember(path);
        if (resource != null && resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }
}

